/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.PlayReadyLicenseRemovalPolicy;
import com.kaltura.client.enums.PlayReadyMinimumLicenseSecurityLevel;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.DrmPolicy;
import com.kaltura.client.types.PlayReadyRight;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class PlayReadyPolicy
extends DrmPolicy {
    private Integer gracePeriod;
    private PlayReadyLicenseRemovalPolicy licenseRemovalPolicy;
    private Integer licenseRemovalDuration;
    private PlayReadyMinimumLicenseSecurityLevel minSecurityLevel;
    private List<PlayReadyRight> rights;

    public Integer getGracePeriod() {
        return this.gracePeriod;
    }

    public void setGracePeriod(Integer gracePeriod) {
        this.gracePeriod = gracePeriod;
    }

    public void gracePeriod(String multirequestToken) {
        this.setToken("gracePeriod", multirequestToken);
    }

    public PlayReadyLicenseRemovalPolicy getLicenseRemovalPolicy() {
        return this.licenseRemovalPolicy;
    }

    public void setLicenseRemovalPolicy(PlayReadyLicenseRemovalPolicy licenseRemovalPolicy) {
        this.licenseRemovalPolicy = licenseRemovalPolicy;
    }

    public void licenseRemovalPolicy(String multirequestToken) {
        this.setToken("licenseRemovalPolicy", multirequestToken);
    }

    public Integer getLicenseRemovalDuration() {
        return this.licenseRemovalDuration;
    }

    public void setLicenseRemovalDuration(Integer licenseRemovalDuration) {
        this.licenseRemovalDuration = licenseRemovalDuration;
    }

    public void licenseRemovalDuration(String multirequestToken) {
        this.setToken("licenseRemovalDuration", multirequestToken);
    }

    public PlayReadyMinimumLicenseSecurityLevel getMinSecurityLevel() {
        return this.minSecurityLevel;
    }

    public void setMinSecurityLevel(PlayReadyMinimumLicenseSecurityLevel minSecurityLevel) {
        this.minSecurityLevel = minSecurityLevel;
    }

    public void minSecurityLevel(String multirequestToken) {
        this.setToken("minSecurityLevel", multirequestToken);
    }

    public List<PlayReadyRight> getRights() {
        return this.rights;
    }

    public void setRights(List<PlayReadyRight> rights) {
        this.rights = rights;
    }

    public PlayReadyPolicy() {
    }

    public PlayReadyPolicy(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.gracePeriod = GsonParser.parseInt(jsonObject.get("gracePeriod"));
        this.licenseRemovalPolicy = PlayReadyLicenseRemovalPolicy.get(GsonParser.parseInt(jsonObject.get("licenseRemovalPolicy")));
        this.licenseRemovalDuration = GsonParser.parseInt(jsonObject.get("licenseRemovalDuration"));
        this.minSecurityLevel = PlayReadyMinimumLicenseSecurityLevel.get(GsonParser.parseInt(jsonObject.get("minSecurityLevel")));
        this.rights = GsonParser.parseArray(jsonObject.getAsJsonArray("rights"), PlayReadyRight.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaPlayReadyPolicy");
        kparams.add("gracePeriod", this.gracePeriod);
        kparams.add("licenseRemovalPolicy", this.licenseRemovalPolicy);
        kparams.add("licenseRemovalDuration", this.licenseRemovalDuration);
        kparams.add("minSecurityLevel", this.minSecurityLevel);
        kparams.add("rights", this.rights);
        return kparams;
    }

    public static interface Tokenizer
    extends DrmPolicy.Tokenizer {
        public String gracePeriod();

        public String licenseRemovalPolicy();

        public String licenseRemovalDuration();

        public String minSecurityLevel();

        public RequestBuilder.ListTokenizer<PlayReadyRight.Tokenizer> rights();
    }
}

