/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ContentResource;
import com.kaltura.client.types.OperationAttributes;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class OperationResource
extends ContentResource {
    private ContentResource resource;
    private List<OperationAttributes> operationAttributes;
    private Integer assetParamsId;

    public ContentResource getResource() {
        return this.resource;
    }

    public void setResource(ContentResource resource) {
        this.resource = resource;
    }

    public List<OperationAttributes> getOperationAttributes() {
        return this.operationAttributes;
    }

    public void setOperationAttributes(List<OperationAttributes> operationAttributes) {
        this.operationAttributes = operationAttributes;
    }

    public Integer getAssetParamsId() {
        return this.assetParamsId;
    }

    public void setAssetParamsId(Integer assetParamsId) {
        this.assetParamsId = assetParamsId;
    }

    public void assetParamsId(String multirequestToken) {
        this.setToken("assetParamsId", multirequestToken);
    }

    public OperationResource() {
    }

    public OperationResource(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.resource = GsonParser.parseObject(jsonObject.getAsJsonObject("resource"), ContentResource.class);
        this.operationAttributes = GsonParser.parseArray(jsonObject.getAsJsonArray("operationAttributes"), OperationAttributes.class);
        this.assetParamsId = GsonParser.parseInt(jsonObject.get("assetParamsId"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaOperationResource");
        kparams.add("resource", this.resource);
        kparams.add("operationAttributes", this.operationAttributes);
        kparams.add("assetParamsId", this.assetParamsId);
        return kparams;
    }

    public static interface Tokenizer
    extends ContentResource.Tokenizer {
        public ContentResource.Tokenizer resource();

        public RequestBuilder.ListTokenizer<OperationAttributes.Tokenizer> operationAttributes();

        public String assetParamsId();
    }
}

