/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.DeliveryServerNode;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public abstract class MediaServerNode
extends DeliveryServerNode {
    private String applicationName;
    private List<KeyValue> mediaServerPortConfig;
    private List<KeyValue> mediaServerPlaybackDomainConfig;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void applicationName(String multirequestToken) {
        this.setToken("applicationName", multirequestToken);
    }

    public List<KeyValue> getMediaServerPortConfig() {
        return this.mediaServerPortConfig;
    }

    public void setMediaServerPortConfig(List<KeyValue> mediaServerPortConfig) {
        this.mediaServerPortConfig = mediaServerPortConfig;
    }

    public List<KeyValue> getMediaServerPlaybackDomainConfig() {
        return this.mediaServerPlaybackDomainConfig;
    }

    public void setMediaServerPlaybackDomainConfig(List<KeyValue> mediaServerPlaybackDomainConfig) {
        this.mediaServerPlaybackDomainConfig = mediaServerPlaybackDomainConfig;
    }

    public MediaServerNode() {
    }

    public MediaServerNode(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.applicationName = GsonParser.parseString(jsonObject.get("applicationName"));
        this.mediaServerPortConfig = GsonParser.parseArray(jsonObject.getAsJsonArray("mediaServerPortConfig"), KeyValue.class);
        this.mediaServerPlaybackDomainConfig = GsonParser.parseArray(jsonObject.getAsJsonArray("mediaServerPlaybackDomainConfig"), KeyValue.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaMediaServerNode");
        kparams.add("applicationName", this.applicationName);
        kparams.add("mediaServerPortConfig", this.mediaServerPortConfig);
        kparams.add("mediaServerPlaybackDomainConfig", this.mediaServerPlaybackDomainConfig);
        return kparams;
    }

    public static interface Tokenizer
    extends DeliveryServerNode.Tokenizer {
        public String applicationName();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> mediaServerPortConfig();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> mediaServerPlaybackDomainConfig();
    }
}

