/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.CsvAdditionalFieldInfo;
import com.kaltura.client.types.ExportCsvJobData;
import com.kaltura.client.types.ExportToCsvOptions;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public abstract class MappedObjectsCsvJobData
extends ExportCsvJobData {
    private Integer metadataProfileId;
    private List<CsvAdditionalFieldInfo> additionalFields;
    private List<KeyValue> mappedFields;
    private ExportToCsvOptions options;

    public Integer getMetadataProfileId() {
        return this.metadataProfileId;
    }

    public void setMetadataProfileId(Integer metadataProfileId) {
        this.metadataProfileId = metadataProfileId;
    }

    public void metadataProfileId(String multirequestToken) {
        this.setToken("metadataProfileId", multirequestToken);
    }

    public List<CsvAdditionalFieldInfo> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(List<CsvAdditionalFieldInfo> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public List<KeyValue> getMappedFields() {
        return this.mappedFields;
    }

    public void setMappedFields(List<KeyValue> mappedFields) {
        this.mappedFields = mappedFields;
    }

    public ExportToCsvOptions getOptions() {
        return this.options;
    }

    public void setOptions(ExportToCsvOptions options) {
        this.options = options;
    }

    public MappedObjectsCsvJobData() {
    }

    public MappedObjectsCsvJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.metadataProfileId = GsonParser.parseInt(jsonObject.get("metadataProfileId"));
        this.additionalFields = GsonParser.parseArray(jsonObject.getAsJsonArray("additionalFields"), CsvAdditionalFieldInfo.class);
        this.mappedFields = GsonParser.parseArray(jsonObject.getAsJsonArray("mappedFields"), KeyValue.class);
        this.options = GsonParser.parseObject(jsonObject.getAsJsonObject("options"), ExportToCsvOptions.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaMappedObjectsCsvJobData");
        kparams.add("metadataProfileId", this.metadataProfileId);
        kparams.add("additionalFields", this.additionalFields);
        kparams.add("mappedFields", this.mappedFields);
        kparams.add("options", this.options);
        return kparams;
    }

    public static interface Tokenizer
    extends ExportCsvJobData.Tokenizer {
        public String metadataProfileId();

        public RequestBuilder.ListTokenizer<CsvAdditionalFieldInfo.Tokenizer> additionalFields();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> mappedFields();

        public ExportToCsvOptions.Tokenizer options();
    }
}

