/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BaseLiveScheduleEvent;
import com.kaltura.client.types.LiveFeature;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class LiveStreamScheduleEvent
extends BaseLiveScheduleEvent {
    private String sourceEntryId;
    private Integer projectedAudience;
    private Integer preStartTime;
    private Integer postEndTime;
    private String preStartEntryId;
    private String postEndEntryId;
    private Boolean isContentInterruptible;
    private List<LiveFeature> liveFeatures;

    public String getSourceEntryId() {
        return this.sourceEntryId;
    }

    public void setSourceEntryId(String sourceEntryId) {
        this.sourceEntryId = sourceEntryId;
    }

    public void sourceEntryId(String multirequestToken) {
        this.setToken("sourceEntryId", multirequestToken);
    }

    public Integer getProjectedAudience() {
        return this.projectedAudience;
    }

    public void setProjectedAudience(Integer projectedAudience) {
        this.projectedAudience = projectedAudience;
    }

    public void projectedAudience(String multirequestToken) {
        this.setToken("projectedAudience", multirequestToken);
    }

    public Integer getPreStartTime() {
        return this.preStartTime;
    }

    public void setPreStartTime(Integer preStartTime) {
        this.preStartTime = preStartTime;
    }

    public void preStartTime(String multirequestToken) {
        this.setToken("preStartTime", multirequestToken);
    }

    public Integer getPostEndTime() {
        return this.postEndTime;
    }

    public void setPostEndTime(Integer postEndTime) {
        this.postEndTime = postEndTime;
    }

    public void postEndTime(String multirequestToken) {
        this.setToken("postEndTime", multirequestToken);
    }

    public String getPreStartEntryId() {
        return this.preStartEntryId;
    }

    public void setPreStartEntryId(String preStartEntryId) {
        this.preStartEntryId = preStartEntryId;
    }

    public void preStartEntryId(String multirequestToken) {
        this.setToken("preStartEntryId", multirequestToken);
    }

    public String getPostEndEntryId() {
        return this.postEndEntryId;
    }

    public void setPostEndEntryId(String postEndEntryId) {
        this.postEndEntryId = postEndEntryId;
    }

    public void postEndEntryId(String multirequestToken) {
        this.setToken("postEndEntryId", multirequestToken);
    }

    public Boolean getIsContentInterruptible() {
        return this.isContentInterruptible;
    }

    public void setIsContentInterruptible(Boolean isContentInterruptible) {
        this.isContentInterruptible = isContentInterruptible;
    }

    public void isContentInterruptible(String multirequestToken) {
        this.setToken("isContentInterruptible", multirequestToken);
    }

    public List<LiveFeature> getLiveFeatures() {
        return this.liveFeatures;
    }

    public void setLiveFeatures(List<LiveFeature> liveFeatures) {
        this.liveFeatures = liveFeatures;
    }

    public LiveStreamScheduleEvent() {
    }

    public LiveStreamScheduleEvent(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.sourceEntryId = GsonParser.parseString(jsonObject.get("sourceEntryId"));
        this.projectedAudience = GsonParser.parseInt(jsonObject.get("projectedAudience"));
        this.preStartTime = GsonParser.parseInt(jsonObject.get("preStartTime"));
        this.postEndTime = GsonParser.parseInt(jsonObject.get("postEndTime"));
        this.preStartEntryId = GsonParser.parseString(jsonObject.get("preStartEntryId"));
        this.postEndEntryId = GsonParser.parseString(jsonObject.get("postEndEntryId"));
        this.isContentInterruptible = GsonParser.parseBoolean(jsonObject.get("isContentInterruptible"));
        this.liveFeatures = GsonParser.parseArray(jsonObject.getAsJsonArray("liveFeatures"), LiveFeature.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaLiveStreamScheduleEvent");
        kparams.add("sourceEntryId", this.sourceEntryId);
        kparams.add("projectedAudience", this.projectedAudience);
        kparams.add("preStartTime", this.preStartTime);
        kparams.add("postEndTime", this.postEndTime);
        kparams.add("preStartEntryId", this.preStartEntryId);
        kparams.add("postEndEntryId", this.postEndEntryId);
        kparams.add("isContentInterruptible", this.isContentInterruptible);
        kparams.add("liveFeatures", this.liveFeatures);
        return kparams;
    }

    public static interface Tokenizer
    extends BaseLiveScheduleEvent.Tokenizer {
        public String sourceEntryId();

        public String projectedAudience();

        public String preStartTime();

        public String postEndTime();

        public String preStartEntryId();

        public String postEndEntryId();

        public String isContentInterruptible();

        public RequestBuilder.ListTokenizer<LiveFeature.Tokenizer> liveFeatures();
    }
}

