/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.DVRStatus;
import com.kaltura.client.enums.EntryServerNodeStatus;
import com.kaltura.client.enums.LivePublishStatus;
import com.kaltura.client.enums.RecordStatus;
import com.kaltura.client.enums.RecordingStatus;
import com.kaltura.client.enums.ViewMode;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.LiveEntryRecordingOptions;
import com.kaltura.client.types.LiveStreamConfiguration;
import com.kaltura.client.types.LiveStreamPushPublishConfiguration;
import com.kaltura.client.types.MediaEntry;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public abstract class LiveEntry
extends MediaEntry {
    private String offlineMessage;
    private RecordStatus recordStatus;
    private DVRStatus dvrStatus;
    private Integer dvrWindow;
    private Integer lastElapsedRecordingTime;
    private List<LiveStreamConfiguration> liveStreamConfigurations;
    private String recordedEntryId;
    private LivePublishStatus pushPublishEnabled;
    private List<LiveStreamPushPublishConfiguration> publishConfigurations;
    private Integer firstBroadcast;
    private Integer lastBroadcast;
    private Double currentBroadcastStartTime;
    private LiveEntryRecordingOptions recordingOptions;
    private EntryServerNodeStatus liveStatus;
    private Integer segmentDuration;
    private Boolean explicitLive;
    private ViewMode viewMode;
    private RecordingStatus recordingStatus;
    private Integer lastBroadcastEndTime;
    private Integer broadcastTime;

    public String getOfflineMessage() {
        return this.offlineMessage;
    }

    public void setOfflineMessage(String offlineMessage) {
        this.offlineMessage = offlineMessage;
    }

    public void offlineMessage(String multirequestToken) {
        this.setToken("offlineMessage", multirequestToken);
    }

    public RecordStatus getRecordStatus() {
        return this.recordStatus;
    }

    public void setRecordStatus(RecordStatus recordStatus) {
        this.recordStatus = recordStatus;
    }

    public void recordStatus(String multirequestToken) {
        this.setToken("recordStatus", multirequestToken);
    }

    public DVRStatus getDvrStatus() {
        return this.dvrStatus;
    }

    public void setDvrStatus(DVRStatus dvrStatus) {
        this.dvrStatus = dvrStatus;
    }

    public void dvrStatus(String multirequestToken) {
        this.setToken("dvrStatus", multirequestToken);
    }

    public Integer getDvrWindow() {
        return this.dvrWindow;
    }

    public void setDvrWindow(Integer dvrWindow) {
        this.dvrWindow = dvrWindow;
    }

    public void dvrWindow(String multirequestToken) {
        this.setToken("dvrWindow", multirequestToken);
    }

    public Integer getLastElapsedRecordingTime() {
        return this.lastElapsedRecordingTime;
    }

    public void setLastElapsedRecordingTime(Integer lastElapsedRecordingTime) {
        this.lastElapsedRecordingTime = lastElapsedRecordingTime;
    }

    public void lastElapsedRecordingTime(String multirequestToken) {
        this.setToken("lastElapsedRecordingTime", multirequestToken);
    }

    public List<LiveStreamConfiguration> getLiveStreamConfigurations() {
        return this.liveStreamConfigurations;
    }

    public void setLiveStreamConfigurations(List<LiveStreamConfiguration> liveStreamConfigurations) {
        this.liveStreamConfigurations = liveStreamConfigurations;
    }

    public String getRecordedEntryId() {
        return this.recordedEntryId;
    }

    public void setRecordedEntryId(String recordedEntryId) {
        this.recordedEntryId = recordedEntryId;
    }

    public void recordedEntryId(String multirequestToken) {
        this.setToken("recordedEntryId", multirequestToken);
    }

    public LivePublishStatus getPushPublishEnabled() {
        return this.pushPublishEnabled;
    }

    public void setPushPublishEnabled(LivePublishStatus pushPublishEnabled) {
        this.pushPublishEnabled = pushPublishEnabled;
    }

    public void pushPublishEnabled(String multirequestToken) {
        this.setToken("pushPublishEnabled", multirequestToken);
    }

    public List<LiveStreamPushPublishConfiguration> getPublishConfigurations() {
        return this.publishConfigurations;
    }

    public void setPublishConfigurations(List<LiveStreamPushPublishConfiguration> publishConfigurations) {
        this.publishConfigurations = publishConfigurations;
    }

    public Integer getFirstBroadcast() {
        return this.firstBroadcast;
    }

    public Integer getLastBroadcast() {
        return this.lastBroadcast;
    }

    public Double getCurrentBroadcastStartTime() {
        return this.currentBroadcastStartTime;
    }

    public void setCurrentBroadcastStartTime(Double currentBroadcastStartTime) {
        this.currentBroadcastStartTime = currentBroadcastStartTime;
    }

    public void currentBroadcastStartTime(String multirequestToken) {
        this.setToken("currentBroadcastStartTime", multirequestToken);
    }

    public LiveEntryRecordingOptions getRecordingOptions() {
        return this.recordingOptions;
    }

    public void setRecordingOptions(LiveEntryRecordingOptions recordingOptions) {
        this.recordingOptions = recordingOptions;
    }

    public EntryServerNodeStatus getLiveStatus() {
        return this.liveStatus;
    }

    public Integer getSegmentDuration() {
        return this.segmentDuration;
    }

    public void setSegmentDuration(Integer segmentDuration) {
        this.segmentDuration = segmentDuration;
    }

    public void segmentDuration(String multirequestToken) {
        this.setToken("segmentDuration", multirequestToken);
    }

    public Boolean getExplicitLive() {
        return this.explicitLive;
    }

    public void setExplicitLive(Boolean explicitLive) {
        this.explicitLive = explicitLive;
    }

    public void explicitLive(String multirequestToken) {
        this.setToken("explicitLive", multirequestToken);
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(ViewMode viewMode) {
        this.viewMode = viewMode;
    }

    public void viewMode(String multirequestToken) {
        this.setToken("viewMode", multirequestToken);
    }

    public RecordingStatus getRecordingStatus() {
        return this.recordingStatus;
    }

    public void setRecordingStatus(RecordingStatus recordingStatus) {
        this.recordingStatus = recordingStatus;
    }

    public void recordingStatus(String multirequestToken) {
        this.setToken("recordingStatus", multirequestToken);
    }

    public Integer getLastBroadcastEndTime() {
        return this.lastBroadcastEndTime;
    }

    public Integer getBroadcastTime() {
        return this.broadcastTime;
    }

    public void setBroadcastTime(Integer broadcastTime) {
        this.broadcastTime = broadcastTime;
    }

    public void broadcastTime(String multirequestToken) {
        this.setToken("broadcastTime", multirequestToken);
    }

    public LiveEntry() {
    }

    public LiveEntry(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.offlineMessage = GsonParser.parseString(jsonObject.get("offlineMessage"));
        this.recordStatus = RecordStatus.get(GsonParser.parseInt(jsonObject.get("recordStatus")));
        this.dvrStatus = DVRStatus.get(GsonParser.parseInt(jsonObject.get("dvrStatus")));
        this.dvrWindow = GsonParser.parseInt(jsonObject.get("dvrWindow"));
        this.lastElapsedRecordingTime = GsonParser.parseInt(jsonObject.get("lastElapsedRecordingTime"));
        this.liveStreamConfigurations = GsonParser.parseArray(jsonObject.getAsJsonArray("liveStreamConfigurations"), LiveStreamConfiguration.class);
        this.recordedEntryId = GsonParser.parseString(jsonObject.get("recordedEntryId"));
        this.pushPublishEnabled = LivePublishStatus.get(GsonParser.parseInt(jsonObject.get("pushPublishEnabled")));
        this.publishConfigurations = GsonParser.parseArray(jsonObject.getAsJsonArray("publishConfigurations"), LiveStreamPushPublishConfiguration.class);
        this.firstBroadcast = GsonParser.parseInt(jsonObject.get("firstBroadcast"));
        this.lastBroadcast = GsonParser.parseInt(jsonObject.get("lastBroadcast"));
        this.currentBroadcastStartTime = GsonParser.parseDouble(jsonObject.get("currentBroadcastStartTime"));
        this.recordingOptions = GsonParser.parseObject(jsonObject.getAsJsonObject("recordingOptions"), LiveEntryRecordingOptions.class);
        this.liveStatus = EntryServerNodeStatus.get(GsonParser.parseInt(jsonObject.get("liveStatus")));
        this.segmentDuration = GsonParser.parseInt(jsonObject.get("segmentDuration"));
        this.explicitLive = GsonParser.parseBoolean(jsonObject.get("explicitLive"));
        this.viewMode = ViewMode.get(GsonParser.parseInt(jsonObject.get("viewMode")));
        this.recordingStatus = RecordingStatus.get(GsonParser.parseInt(jsonObject.get("recordingStatus")));
        this.lastBroadcastEndTime = GsonParser.parseInt(jsonObject.get("lastBroadcastEndTime"));
        this.broadcastTime = GsonParser.parseInt(jsonObject.get("broadcastTime"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaLiveEntry");
        kparams.add("offlineMessage", this.offlineMessage);
        kparams.add("recordStatus", this.recordStatus);
        kparams.add("dvrStatus", this.dvrStatus);
        kparams.add("dvrWindow", this.dvrWindow);
        kparams.add("lastElapsedRecordingTime", this.lastElapsedRecordingTime);
        kparams.add("liveStreamConfigurations", this.liveStreamConfigurations);
        kparams.add("recordedEntryId", this.recordedEntryId);
        kparams.add("pushPublishEnabled", this.pushPublishEnabled);
        kparams.add("publishConfigurations", this.publishConfigurations);
        kparams.add("currentBroadcastStartTime", this.currentBroadcastStartTime);
        kparams.add("recordingOptions", this.recordingOptions);
        kparams.add("segmentDuration", this.segmentDuration);
        kparams.add("explicitLive", this.explicitLive);
        kparams.add("viewMode", this.viewMode);
        kparams.add("recordingStatus", this.recordingStatus);
        kparams.add("broadcastTime", this.broadcastTime);
        return kparams;
    }

    public static interface Tokenizer
    extends MediaEntry.Tokenizer {
        public String offlineMessage();

        public String recordStatus();

        public String dvrStatus();

        public String dvrWindow();

        public String lastElapsedRecordingTime();

        public RequestBuilder.ListTokenizer<LiveStreamConfiguration.Tokenizer> liveStreamConfigurations();

        public String recordedEntryId();

        public String pushPublishEnabled();

        public RequestBuilder.ListTokenizer<LiveStreamPushPublishConfiguration.Tokenizer> publishConfigurations();

        public String firstBroadcast();

        public String lastBroadcast();

        public String currentBroadcastStartTime();

        public LiveEntryRecordingOptions.Tokenizer recordingOptions();

        public String liveStatus();

        public String segmentDuration();

        public String explicitLive();

        public String viewMode();

        public String recordingStatus();

        public String lastBroadcastEndTime();

        public String broadcastTime();
    }
}

