/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.IntegrationProviderType;
import com.kaltura.client.enums.IntegrationTriggerType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.IntegrationJobProviderData;
import com.kaltura.client.types.IntegrationJobTriggerData;
import com.kaltura.client.types.JobData;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class IntegrationJobData
extends JobData {
    private String callbackNotificationUrl;
    private IntegrationProviderType providerType;
    private IntegrationJobProviderData providerData;
    private IntegrationTriggerType triggerType;
    private IntegrationJobTriggerData triggerData;

    public String getCallbackNotificationUrl() {
        return this.callbackNotificationUrl;
    }

    public IntegrationProviderType getProviderType() {
        return this.providerType;
    }

    public void setProviderType(IntegrationProviderType providerType) {
        this.providerType = providerType;
    }

    public void providerType(String multirequestToken) {
        this.setToken("providerType", multirequestToken);
    }

    public IntegrationJobProviderData getProviderData() {
        return this.providerData;
    }

    public void setProviderData(IntegrationJobProviderData providerData) {
        this.providerData = providerData;
    }

    public IntegrationTriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(IntegrationTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void triggerType(String multirequestToken) {
        this.setToken("triggerType", multirequestToken);
    }

    public IntegrationJobTriggerData getTriggerData() {
        return this.triggerData;
    }

    public void setTriggerData(IntegrationJobTriggerData triggerData) {
        this.triggerData = triggerData;
    }

    public IntegrationJobData() {
    }

    public IntegrationJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.callbackNotificationUrl = GsonParser.parseString(jsonObject.get("callbackNotificationUrl"));
        this.providerType = IntegrationProviderType.get(GsonParser.parseString(jsonObject.get("providerType")));
        this.providerData = GsonParser.parseObject(jsonObject.getAsJsonObject("providerData"), IntegrationJobProviderData.class);
        this.triggerType = IntegrationTriggerType.get(GsonParser.parseString(jsonObject.get("triggerType")));
        this.triggerData = GsonParser.parseObject(jsonObject.getAsJsonObject("triggerData"), IntegrationJobTriggerData.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaIntegrationJobData");
        kparams.add("providerType", this.providerType);
        kparams.add("providerData", this.providerData);
        kparams.add("triggerType", this.triggerType);
        kparams.add("triggerData", this.triggerData);
        return kparams;
    }

    public static interface Tokenizer
    extends JobData.Tokenizer {
        public String callbackNotificationUrl();

        public String providerType();

        public IntegrationJobProviderData.Tokenizer providerData();

        public String triggerType();

        public IntegrationJobTriggerData.Tokenizer triggerData();
    }
}

