/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.DrmLicenseExpirationPolicy;
import com.kaltura.client.enums.DrmLicenseScenario;
import com.kaltura.client.enums.DrmLicenseType;
import com.kaltura.client.enums.DrmPolicyStatus;
import com.kaltura.client.enums.DrmProviderType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class DrmPolicy
extends ObjectBase {
    private Integer id;
    private Integer partnerId;
    private String name;
    private String systemName;
    private String description;
    private DrmProviderType provider;
    private DrmPolicyStatus status;
    private DrmLicenseScenario scenario;
    private DrmLicenseType licenseType;
    private DrmLicenseExpirationPolicy licenseExpirationPolicy;
    private Integer duration;
    private Integer createdAt;
    private Integer updatedAt;
    private List<KeyValue> licenseParams;

    public Integer getId() {
        return this.id;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(Integer partnerId) {
        this.partnerId = partnerId;
    }

    public void partnerId(String multirequestToken) {
        this.setToken("partnerId", multirequestToken);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void systemName(String multirequestToken) {
        this.setToken("systemName", multirequestToken);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public DrmProviderType getProvider() {
        return this.provider;
    }

    public void setProvider(DrmProviderType provider) {
        this.provider = provider;
    }

    public void provider(String multirequestToken) {
        this.setToken("provider", multirequestToken);
    }

    public DrmPolicyStatus getStatus() {
        return this.status;
    }

    public void setStatus(DrmPolicyStatus status) {
        this.status = status;
    }

    public void status(String multirequestToken) {
        this.setToken("status", multirequestToken);
    }

    public DrmLicenseScenario getScenario() {
        return this.scenario;
    }

    public void setScenario(DrmLicenseScenario scenario) {
        this.scenario = scenario;
    }

    public void scenario(String multirequestToken) {
        this.setToken("scenario", multirequestToken);
    }

    public DrmLicenseType getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(DrmLicenseType licenseType) {
        this.licenseType = licenseType;
    }

    public void licenseType(String multirequestToken) {
        this.setToken("licenseType", multirequestToken);
    }

    public DrmLicenseExpirationPolicy getLicenseExpirationPolicy() {
        return this.licenseExpirationPolicy;
    }

    public void setLicenseExpirationPolicy(DrmLicenseExpirationPolicy licenseExpirationPolicy) {
        this.licenseExpirationPolicy = licenseExpirationPolicy;
    }

    public void licenseExpirationPolicy(String multirequestToken) {
        this.setToken("licenseExpirationPolicy", multirequestToken);
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void duration(String multirequestToken) {
        this.setToken("duration", multirequestToken);
    }

    public Integer getCreatedAt() {
        return this.createdAt;
    }

    public Integer getUpdatedAt() {
        return this.updatedAt;
    }

    public List<KeyValue> getLicenseParams() {
        return this.licenseParams;
    }

    public void setLicenseParams(List<KeyValue> licenseParams) {
        this.licenseParams = licenseParams;
    }

    public DrmPolicy() {
    }

    public DrmPolicy(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.systemName = GsonParser.parseString(jsonObject.get("systemName"));
        this.description = GsonParser.parseString(jsonObject.get("description"));
        this.provider = DrmProviderType.get(GsonParser.parseString(jsonObject.get("provider")));
        this.status = DrmPolicyStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.scenario = DrmLicenseScenario.get(GsonParser.parseString(jsonObject.get("scenario")));
        this.licenseType = DrmLicenseType.get(GsonParser.parseString(jsonObject.get("licenseType")));
        this.licenseExpirationPolicy = DrmLicenseExpirationPolicy.get(GsonParser.parseInt(jsonObject.get("licenseExpirationPolicy")));
        this.duration = GsonParser.parseInt(jsonObject.get("duration"));
        this.createdAt = GsonParser.parseInt(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseInt(jsonObject.get("updatedAt"));
        this.licenseParams = GsonParser.parseArray(jsonObject.getAsJsonArray("licenseParams"), KeyValue.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaDrmPolicy");
        kparams.add("partnerId", this.partnerId);
        kparams.add("name", this.name);
        kparams.add("systemName", this.systemName);
        kparams.add("description", this.description);
        kparams.add("provider", this.provider);
        kparams.add("status", this.status);
        kparams.add("scenario", this.scenario);
        kparams.add("licenseType", this.licenseType);
        kparams.add("licenseExpirationPolicy", this.licenseExpirationPolicy);
        kparams.add("duration", this.duration);
        kparams.add("licenseParams", this.licenseParams);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String partnerId();

        public String name();

        public String systemName();

        public String description();

        public String provider();

        public String status();

        public String scenario();

        public String licenseType();

        public String licenseExpirationPolicy();

        public String duration();

        public String createdAt();

        public String updatedAt();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> licenseParams();
    }
}

