/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.DocumentType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BaseEntry;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class DocumentEntry
extends BaseEntry {
    private DocumentType documentType;
    private String assetParamsIds;

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType;
    }

    public void documentType(String multirequestToken) {
        this.setToken("documentType", multirequestToken);
    }

    public String getAssetParamsIds() {
        return this.assetParamsIds;
    }

    public DocumentEntry() {
    }

    public DocumentEntry(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.documentType = DocumentType.get(GsonParser.parseInt(jsonObject.get("documentType")));
        this.assetParamsIds = GsonParser.parseString(jsonObject.get("assetParamsIds"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaDocumentEntry");
        kparams.add("documentType", this.documentType);
        return kparams;
    }

    public static interface Tokenizer
    extends BaseEntry.Tokenizer {
        public String documentType();

        public String assetParamsIds();
    }
}

