/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ResponseProfileType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BaseResponseProfile;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.RelatedFilter;
import com.kaltura.client.types.ResponseProfileMapping;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class DetachedResponseProfile
extends BaseResponseProfile {
    private String name;
    private ResponseProfileType type;
    private String fields;
    private RelatedFilter filter;
    private FilterPager pager;
    private List<DetachedResponseProfile> relatedProfiles;
    private List<ResponseProfileMapping> mappings;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public ResponseProfileType getType() {
        return this.type;
    }

    public void setType(ResponseProfileType type) {
        this.type = type;
    }

    public void type(String multirequestToken) {
        this.setToken("type", multirequestToken);
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public void fields(String multirequestToken) {
        this.setToken("fields", multirequestToken);
    }

    public RelatedFilter getFilter() {
        return this.filter;
    }

    public void setFilter(RelatedFilter filter) {
        this.filter = filter;
    }

    public FilterPager getPager() {
        return this.pager;
    }

    public void setPager(FilterPager pager) {
        this.pager = pager;
    }

    public List<DetachedResponseProfile> getRelatedProfiles() {
        return this.relatedProfiles;
    }

    public void setRelatedProfiles(List<DetachedResponseProfile> relatedProfiles) {
        this.relatedProfiles = relatedProfiles;
    }

    public List<ResponseProfileMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<ResponseProfileMapping> mappings) {
        this.mappings = mappings;
    }

    public DetachedResponseProfile() {
    }

    public DetachedResponseProfile(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.type = ResponseProfileType.get(GsonParser.parseInt(jsonObject.get("type")));
        this.fields = GsonParser.parseString(jsonObject.get("fields"));
        this.filter = GsonParser.parseObject(jsonObject.getAsJsonObject("filter"), RelatedFilter.class);
        this.pager = GsonParser.parseObject(jsonObject.getAsJsonObject("pager"), FilterPager.class);
        this.relatedProfiles = GsonParser.parseArray(jsonObject.getAsJsonArray("relatedProfiles"), DetachedResponseProfile.class);
        this.mappings = GsonParser.parseArray(jsonObject.getAsJsonArray("mappings"), ResponseProfileMapping.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaDetachedResponseProfile");
        kparams.add("name", this.name);
        kparams.add("type", this.type);
        kparams.add("fields", this.fields);
        kparams.add("filter", this.filter);
        kparams.add("pager", this.pager);
        kparams.add("relatedProfiles", this.relatedProfiles);
        kparams.add("mappings", this.mappings);
        return kparams;
    }

    public static interface Tokenizer
    extends BaseResponseProfile.Tokenizer {
        public String name();

        public String type();

        public String fields();

        public RelatedFilter.Tokenizer filter();

        public FilterPager.Tokenizer pager();

        public RequestBuilder.ListTokenizer<Tokenizer> relatedProfiles();

        public RequestBuilder.ListTokenizer<ResponseProfileMapping.Tokenizer> mappings();
    }
}

