/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ConvartableJobData;
import com.kaltura.client.types.ConvertCollectionFlavorData;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ConvertCollectionJobData
extends ConvartableJobData {
    private String destDirLocalPath;
    private String destDirRemoteUrl;
    private String destFileName;
    private String inputXmlLocalPath;
    private String inputXmlRemoteUrl;
    private String commandLinesStr;
    private List<ConvertCollectionFlavorData> flavors;

    public String getDestDirLocalPath() {
        return this.destDirLocalPath;
    }

    public void setDestDirLocalPath(String destDirLocalPath) {
        this.destDirLocalPath = destDirLocalPath;
    }

    public void destDirLocalPath(String multirequestToken) {
        this.setToken("destDirLocalPath", multirequestToken);
    }

    public String getDestDirRemoteUrl() {
        return this.destDirRemoteUrl;
    }

    public void setDestDirRemoteUrl(String destDirRemoteUrl) {
        this.destDirRemoteUrl = destDirRemoteUrl;
    }

    public void destDirRemoteUrl(String multirequestToken) {
        this.setToken("destDirRemoteUrl", multirequestToken);
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    public void setDestFileName(String destFileName) {
        this.destFileName = destFileName;
    }

    public void destFileName(String multirequestToken) {
        this.setToken("destFileName", multirequestToken);
    }

    public String getInputXmlLocalPath() {
        return this.inputXmlLocalPath;
    }

    public void setInputXmlLocalPath(String inputXmlLocalPath) {
        this.inputXmlLocalPath = inputXmlLocalPath;
    }

    public void inputXmlLocalPath(String multirequestToken) {
        this.setToken("inputXmlLocalPath", multirequestToken);
    }

    public String getInputXmlRemoteUrl() {
        return this.inputXmlRemoteUrl;
    }

    public void setInputXmlRemoteUrl(String inputXmlRemoteUrl) {
        this.inputXmlRemoteUrl = inputXmlRemoteUrl;
    }

    public void inputXmlRemoteUrl(String multirequestToken) {
        this.setToken("inputXmlRemoteUrl", multirequestToken);
    }

    public String getCommandLinesStr() {
        return this.commandLinesStr;
    }

    public void setCommandLinesStr(String commandLinesStr) {
        this.commandLinesStr = commandLinesStr;
    }

    public void commandLinesStr(String multirequestToken) {
        this.setToken("commandLinesStr", multirequestToken);
    }

    public List<ConvertCollectionFlavorData> getFlavors() {
        return this.flavors;
    }

    public void setFlavors(List<ConvertCollectionFlavorData> flavors) {
        this.flavors = flavors;
    }

    public ConvertCollectionJobData() {
    }

    public ConvertCollectionJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.destDirLocalPath = GsonParser.parseString(jsonObject.get("destDirLocalPath"));
        this.destDirRemoteUrl = GsonParser.parseString(jsonObject.get("destDirRemoteUrl"));
        this.destFileName = GsonParser.parseString(jsonObject.get("destFileName"));
        this.inputXmlLocalPath = GsonParser.parseString(jsonObject.get("inputXmlLocalPath"));
        this.inputXmlRemoteUrl = GsonParser.parseString(jsonObject.get("inputXmlRemoteUrl"));
        this.commandLinesStr = GsonParser.parseString(jsonObject.get("commandLinesStr"));
        this.flavors = GsonParser.parseArray(jsonObject.getAsJsonArray("flavors"), ConvertCollectionFlavorData.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaConvertCollectionJobData");
        kparams.add("destDirLocalPath", this.destDirLocalPath);
        kparams.add("destDirRemoteUrl", this.destDirRemoteUrl);
        kparams.add("destFileName", this.destFileName);
        kparams.add("inputXmlLocalPath", this.inputXmlLocalPath);
        kparams.add("inputXmlRemoteUrl", this.inputXmlRemoteUrl);
        kparams.add("commandLinesStr", this.commandLinesStr);
        kparams.add("flavors", this.flavors);
        return kparams;
    }

    public static interface Tokenizer
    extends ConvartableJobData.Tokenizer {
        public String destDirLocalPath();

        public String destDirRemoteUrl();

        public String destFileName();

        public String inputXmlLocalPath();

        public String inputXmlRemoteUrl();

        public String commandLinesStr();

        public RequestBuilder.ListTokenizer<ConvertCollectionFlavorData.Tokenizer> flavors();
    }
}

