/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.ReportFilter;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class AnalyticsFilter
extends ObjectBase {
    private String from_time;
    private String to_time;
    private String metrics;
    private Double utcOffset;
    private String dimensions;
    private List<ReportFilter> filters;
    private String orderBy;

    public String getFrom_time() {
        return this.from_time;
    }

    public void setFrom_time(String from_time) {
        this.from_time = from_time;
    }

    public void from_time(String multirequestToken) {
        this.setToken("from_time", multirequestToken);
    }

    public String getTo_time() {
        return this.to_time;
    }

    public void setTo_time(String to_time) {
        this.to_time = to_time;
    }

    public void to_time(String multirequestToken) {
        this.setToken("to_time", multirequestToken);
    }

    public String getMetrics() {
        return this.metrics;
    }

    public void setMetrics(String metrics) {
        this.metrics = metrics;
    }

    public void metrics(String multirequestToken) {
        this.setToken("metrics", multirequestToken);
    }

    public Double getUtcOffset() {
        return this.utcOffset;
    }

    public void setUtcOffset(Double utcOffset) {
        this.utcOffset = utcOffset;
    }

    public void utcOffset(String multirequestToken) {
        this.setToken("utcOffset", multirequestToken);
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(String dimensions) {
        this.dimensions = dimensions;
    }

    public void dimensions(String multirequestToken) {
        this.setToken("dimensions", multirequestToken);
    }

    public List<ReportFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ReportFilter> filters) {
        this.filters = filters;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void orderBy(String multirequestToken) {
        this.setToken("orderBy", multirequestToken);
    }

    public AnalyticsFilter() {
    }

    public AnalyticsFilter(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.from_time = GsonParser.parseString(jsonObject.get("from_time"));
        this.to_time = GsonParser.parseString(jsonObject.get("to_time"));
        this.metrics = GsonParser.parseString(jsonObject.get("metrics"));
        this.utcOffset = GsonParser.parseDouble(jsonObject.get("utcOffset"));
        this.dimensions = GsonParser.parseString(jsonObject.get("dimensions"));
        this.filters = GsonParser.parseArray(jsonObject.getAsJsonArray("filters"), ReportFilter.class);
        this.orderBy = GsonParser.parseString(jsonObject.get("orderBy"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaAnalyticsFilter");
        kparams.add("from_time", this.from_time);
        kparams.add("to_time", this.to_time);
        kparams.add("metrics", this.metrics);
        kparams.add("utcOffset", this.utcOffset);
        kparams.add("dimensions", this.dimensions);
        kparams.add("filters", this.filters);
        kparams.add("orderBy", this.orderBy);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String from_time();

        public String to_time();

        public String metrics();

        public String utcOffset();

        public String dimensions();

        public RequestBuilder.ListTokenizer<ReportFilter.Tokenizer> filters();

        public String orderBy();
    }
}

