/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.Rule;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class AccessControlProfile
extends ObjectBase {
    private Integer id;
    private Integer partnerId;
    private String name;
    private String systemName;
    private String description;
    private Long createdAt;
    private Long updatedAt;
    private Boolean isDefault;
    private List<Rule> rules;

    public Integer getId() {
        return this.id;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void systemName(String multirequestToken) {
        this.setToken("systemName", multirequestToken);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void isDefault(String multirequestToken) {
        this.setToken("isDefault", multirequestToken);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public AccessControlProfile() {
    }

    public AccessControlProfile(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.systemName = GsonParser.parseString(jsonObject.get("systemName"));
        this.description = GsonParser.parseString(jsonObject.get("description"));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.isDefault = GsonParser.parseBoolean(jsonObject.get("isDefault"));
        this.rules = GsonParser.parseArray(jsonObject.getAsJsonArray("rules"), Rule.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaAccessControlProfile");
        kparams.add("name", this.name);
        kparams.add("systemName", this.systemName);
        kparams.add("description", this.description);
        kparams.add("isDefault", this.isDefault);
        kparams.add("rules", this.rules);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String partnerId();

        public String name();

        public String systemName();

        public String description();

        public String createdAt();

        public String updatedAt();

        public String isDefault();

        public RequestBuilder.ListTokenizer<Rule.Tokenizer> rules();
    }
}

