/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.Sso;
import com.kaltura.client.types.SsoFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class SsoService {
    public static AddSsoBuilder add(Sso sso) {
        return new AddSsoBuilder(sso);
    }

    public static DeleteSsoBuilder delete(int ssoId) {
        return new DeleteSsoBuilder(ssoId);
    }

    public static GetSsoBuilder get(int ssoId) {
        return new GetSsoBuilder(ssoId);
    }

    public static ListSsoBuilder list() {
        return SsoService.list(null);
    }

    public static ListSsoBuilder list(SsoFilter filter) {
        return SsoService.list(filter, null);
    }

    public static ListSsoBuilder list(SsoFilter filter, FilterPager pager) {
        return new ListSsoBuilder(filter, pager);
    }

    public static LoginSsoBuilder login(String userId, String applicationType) {
        return SsoService.login(userId, applicationType, Integer.MIN_VALUE);
    }

    public static LoginSsoBuilder login(String userId, String applicationType, int partnerId) {
        return new LoginSsoBuilder(userId, applicationType, partnerId);
    }

    public static UpdateSsoBuilder update(int ssoId, Sso sso) {
        return new UpdateSsoBuilder(ssoId, sso);
    }

    public static class UpdateSsoBuilder
    extends RequestBuilder<Sso, Sso.Tokenizer, UpdateSsoBuilder> {
        public UpdateSsoBuilder(int ssoId, Sso sso) {
            super(Sso.class, "sso_sso", "update");
            this.params.add("ssoId", ssoId);
            this.params.add("sso", sso);
        }

        public void ssoId(String multirequestToken) {
            this.params.add("ssoId", multirequestToken);
        }
    }

    public static class LoginSsoBuilder
    extends RequestBuilder<String, String, LoginSsoBuilder> {
        public LoginSsoBuilder(String userId, String applicationType, int partnerId) {
            super(String.class, "sso_sso", "login");
            this.params.add("userId", userId);
            this.params.add("applicationType", applicationType);
            this.params.add("partnerId", partnerId);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void applicationType(String multirequestToken) {
            this.params.add("applicationType", multirequestToken);
        }

        public void partnerId(String multirequestToken) {
            this.params.add("partnerId", multirequestToken);
        }
    }

    public static class ListSsoBuilder
    extends ListResponseRequestBuilder<Sso, Sso.Tokenizer, ListSsoBuilder> {
        public ListSsoBuilder(SsoFilter filter, FilterPager pager) {
            super(Sso.class, "sso_sso", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetSsoBuilder
    extends RequestBuilder<Sso, Sso.Tokenizer, GetSsoBuilder> {
        public GetSsoBuilder(int ssoId) {
            super(Sso.class, "sso_sso", "get");
            this.params.add("ssoId", ssoId);
        }

        public void ssoId(String multirequestToken) {
            this.params.add("ssoId", multirequestToken);
        }
    }

    public static class DeleteSsoBuilder
    extends RequestBuilder<Sso, Sso.Tokenizer, DeleteSsoBuilder> {
        public DeleteSsoBuilder(int ssoId) {
            super(Sso.class, "sso_sso", "delete");
            this.params.add("ssoId", ssoId);
        }

        public void ssoId(String multirequestToken) {
            this.params.add("ssoId", multirequestToken);
        }
    }

    public static class AddSsoBuilder
    extends RequestBuilder<Sso, Sso.Tokenizer, AddSsoBuilder> {
        public AddSsoBuilder(Sso sso) {
            super(Sso.class, "sso_sso", "add");
            this.params.add("sso", sso);
        }
    }
}

