/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.ServerNodeStatus;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.ServerNode;
import com.kaltura.client.types.ServerNodeFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class ServerNodeService {
    public static AddServerNodeBuilder add(ServerNode serverNode) {
        return new AddServerNodeBuilder(serverNode);
    }

    public static DeleteServerNodeBuilder delete(String serverNodeId) {
        return new DeleteServerNodeBuilder(serverNodeId);
    }

    public static DisableServerNodeBuilder disable(String serverNodeId) {
        return new DisableServerNodeBuilder(serverNodeId);
    }

    public static EnableServerNodeBuilder enable(String serverNodeId) {
        return new EnableServerNodeBuilder(serverNodeId);
    }

    public static GetServerNodeBuilder get(int serverNodeId) {
        return new GetServerNodeBuilder(serverNodeId);
    }

    public static GetFullPathServerNodeBuilder getFullPath(String hostName) {
        return ServerNodeService.getFullPath(hostName, "http");
    }

    public static GetFullPathServerNodeBuilder getFullPath(String hostName, String protocol) {
        return ServerNodeService.getFullPath(hostName, protocol, null);
    }

    public static GetFullPathServerNodeBuilder getFullPath(String hostName, String protocol, String deliveryFormat) {
        return ServerNodeService.getFullPath(hostName, protocol, deliveryFormat, null);
    }

    public static GetFullPathServerNodeBuilder getFullPath(String hostName, String protocol, String deliveryFormat, String deliveryType) {
        return new GetFullPathServerNodeBuilder(hostName, protocol, deliveryFormat, deliveryType);
    }

    public static ListServerNodeBuilder list() {
        return ServerNodeService.list(null);
    }

    public static ListServerNodeBuilder list(ServerNodeFilter filter) {
        return ServerNodeService.list(filter, null);
    }

    public static ListServerNodeBuilder list(ServerNodeFilter filter, FilterPager pager) {
        return new ListServerNodeBuilder(filter, pager);
    }

    public static MarkOfflineServerNodeBuilder markOffline(String serverNodeId) {
        return new MarkOfflineServerNodeBuilder(serverNodeId);
    }

    public static ReportStatusServerNodeBuilder reportStatus(String hostName) {
        return ServerNodeService.reportStatus(hostName, null);
    }

    public static ReportStatusServerNodeBuilder reportStatus(String hostName, ServerNode serverNode) {
        return ServerNodeService.reportStatus(hostName, serverNode, ServerNodeStatus.get(1));
    }

    public static ReportStatusServerNodeBuilder reportStatus(String hostName, ServerNode serverNode, ServerNodeStatus serverNodeStatus) {
        return new ReportStatusServerNodeBuilder(hostName, serverNode, serverNodeStatus);
    }

    public static UpdateServerNodeBuilder update(int serverNodeId, ServerNode serverNode) {
        return new UpdateServerNodeBuilder(serverNodeId, serverNode);
    }

    public static class UpdateServerNodeBuilder
    extends RequestBuilder<ServerNode, ServerNode.Tokenizer, UpdateServerNodeBuilder> {
        public UpdateServerNodeBuilder(int serverNodeId, ServerNode serverNode) {
            super(ServerNode.class, "servernode", "update");
            this.params.add("serverNodeId", serverNodeId);
            this.params.add("serverNode", serverNode);
        }

        public void serverNodeId(String multirequestToken) {
            this.params.add("serverNodeId", multirequestToken);
        }
    }

    public static class ReportStatusServerNodeBuilder
    extends RequestBuilder<ServerNode, ServerNode.Tokenizer, ReportStatusServerNodeBuilder> {
        public ReportStatusServerNodeBuilder(String hostName, ServerNode serverNode, ServerNodeStatus serverNodeStatus) {
            super(ServerNode.class, "servernode", "reportStatus");
            this.params.add("hostName", hostName);
            this.params.add("serverNode", serverNode);
            this.params.add("serverNodeStatus", serverNodeStatus);
        }

        public void hostName(String multirequestToken) {
            this.params.add("hostName", multirequestToken);
        }

        public void serverNodeStatus(String multirequestToken) {
            this.params.add("serverNodeStatus", multirequestToken);
        }
    }

    public static class MarkOfflineServerNodeBuilder
    extends RequestBuilder<ServerNode, ServerNode.Tokenizer, MarkOfflineServerNodeBuilder> {
        public MarkOfflineServerNodeBuilder(String serverNodeId) {
            super(ServerNode.class, "servernode", "markOffline");
            this.params.add("serverNodeId", serverNodeId);
        }

        public void serverNodeId(String multirequestToken) {
            this.params.add("serverNodeId", multirequestToken);
        }
    }

    public static class ListServerNodeBuilder
    extends ListResponseRequestBuilder<ServerNode, ServerNode.Tokenizer, ListServerNodeBuilder> {
        public ListServerNodeBuilder(ServerNodeFilter filter, FilterPager pager) {
            super(ServerNode.class, "servernode", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetFullPathServerNodeBuilder
    extends RequestBuilder<String, String, GetFullPathServerNodeBuilder> {
        public GetFullPathServerNodeBuilder(String hostName, String protocol, String deliveryFormat, String deliveryType) {
            super(String.class, "servernode", "getFullPath");
            this.params.add("hostName", hostName);
            this.params.add("protocol", protocol);
            this.params.add("deliveryFormat", deliveryFormat);
            this.params.add("deliveryType", deliveryType);
        }

        public void hostName(String multirequestToken) {
            this.params.add("hostName", multirequestToken);
        }

        public void protocol(String multirequestToken) {
            this.params.add("protocol", multirequestToken);
        }

        public void deliveryFormat(String multirequestToken) {
            this.params.add("deliveryFormat", multirequestToken);
        }

        public void deliveryType(String multirequestToken) {
            this.params.add("deliveryType", multirequestToken);
        }
    }

    public static class GetServerNodeBuilder
    extends RequestBuilder<ServerNode, ServerNode.Tokenizer, GetServerNodeBuilder> {
        public GetServerNodeBuilder(int serverNodeId) {
            super(ServerNode.class, "servernode", "get");
            this.params.add("serverNodeId", serverNodeId);
        }

        public void serverNodeId(String multirequestToken) {
            this.params.add("serverNodeId", multirequestToken);
        }
    }

    public static class EnableServerNodeBuilder
    extends RequestBuilder<ServerNode, ServerNode.Tokenizer, EnableServerNodeBuilder> {
        public EnableServerNodeBuilder(String serverNodeId) {
            super(ServerNode.class, "servernode", "enable");
            this.params.add("serverNodeId", serverNodeId);
        }

        public void serverNodeId(String multirequestToken) {
            this.params.add("serverNodeId", multirequestToken);
        }
    }

    public static class DisableServerNodeBuilder
    extends RequestBuilder<ServerNode, ServerNode.Tokenizer, DisableServerNodeBuilder> {
        public DisableServerNodeBuilder(String serverNodeId) {
            super(ServerNode.class, "servernode", "disable");
            this.params.add("serverNodeId", serverNodeId);
        }

        public void serverNodeId(String multirequestToken) {
            this.params.add("serverNodeId", multirequestToken);
        }
    }

    public static class DeleteServerNodeBuilder
    extends NullRequestBuilder {
        public DeleteServerNodeBuilder(String serverNodeId) {
            super("servernode", "delete");
            this.params.add("serverNodeId", serverNodeId);
        }

        public void serverNodeId(String multirequestToken) {
            this.params.add("serverNodeId", multirequestToken);
        }
    }

    public static class AddServerNodeBuilder
    extends RequestBuilder<ServerNode, ServerNode.Tokenizer, AddServerNodeBuilder> {
        public AddServerNodeBuilder(ServerNode serverNode) {
            super(ServerNode.class, "servernode", "add");
            this.params.add("serverNode", serverNode);
        }
    }
}

