/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.MediaType;
import com.kaltura.client.enums.SearchProviderType;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.Search;
import com.kaltura.client.types.SearchAuthData;
import com.kaltura.client.types.SearchResult;
import com.kaltura.client.types.SearchResultResponse;
import com.kaltura.client.utils.request.RequestBuilder;

public class SearchService {
    public static ExternalLoginSearchBuilder externalLogin(SearchProviderType searchSource, String userName, String password) {
        return new ExternalLoginSearchBuilder(searchSource, userName, password);
    }

    public static GetMediaInfoSearchBuilder getMediaInfo(SearchResult searchResult) {
        return new GetMediaInfoSearchBuilder(searchResult);
    }

    public static SearchSearchBuilder search(Search search) {
        return SearchService.search(search, null);
    }

    public static SearchSearchBuilder search(Search search, FilterPager pager) {
        return new SearchSearchBuilder(search, pager);
    }

    public static SearchUrlSearchBuilder searchUrl(MediaType mediaType, String url) {
        return new SearchUrlSearchBuilder(mediaType, url);
    }

    public static class SearchUrlSearchBuilder
    extends RequestBuilder<SearchResult, SearchResult.Tokenizer, SearchUrlSearchBuilder> {
        public SearchUrlSearchBuilder(MediaType mediaType, String url) {
            super(SearchResult.class, "search", "searchUrl");
            this.params.add("mediaType", mediaType);
            this.params.add("url", url);
        }

        public void mediaType(String multirequestToken) {
            this.params.add("mediaType", multirequestToken);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class SearchSearchBuilder
    extends RequestBuilder<SearchResultResponse, SearchResultResponse.Tokenizer, SearchSearchBuilder> {
        public SearchSearchBuilder(Search search, FilterPager pager) {
            super(SearchResultResponse.class, "search", "search");
            this.params.add("search", search);
            this.params.add("pager", pager);
        }
    }

    public static class GetMediaInfoSearchBuilder
    extends RequestBuilder<SearchResult, SearchResult.Tokenizer, GetMediaInfoSearchBuilder> {
        public GetMediaInfoSearchBuilder(SearchResult searchResult) {
            super(SearchResult.class, "search", "getMediaInfo");
            this.params.add("searchResult", searchResult);
        }
    }

    public static class ExternalLoginSearchBuilder
    extends RequestBuilder<SearchAuthData, SearchAuthData.Tokenizer, ExternalLoginSearchBuilder> {
        public ExternalLoginSearchBuilder(SearchProviderType searchSource, String userName, String password) {
            super(SearchAuthData.class, "search", "externalLogin");
            this.params.add("searchSource", searchSource);
            this.params.add("userName", userName);
            this.params.add("password", password);
        }

        public void searchSource(String multirequestToken) {
            this.params.add("searchSource", multirequestToken);
        }

        public void userName(String multirequestToken) {
            this.params.add("userName", multirequestToken);
        }

        public void password(String multirequestToken) {
            this.params.add("password", multirequestToken);
        }
    }
}

