/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.enums.ScheduleEventConflictType;
import com.kaltura.client.types.BulkUpload;
import com.kaltura.client.types.BulkUploadScheduleEventJobData;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.LiveFeature;
import com.kaltura.client.types.LiveStreamScheduleEvent;
import com.kaltura.client.types.ScheduleEvent;
import com.kaltura.client.types.ScheduleEventFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ScheduleEventService {
    public static AddScheduleEventBuilder add(ScheduleEvent scheduleEvent) {
        return new AddScheduleEventBuilder(scheduleEvent);
    }

    public static AddFromBulkUploadScheduleEventBuilder addFromBulkUpload(FileHolder fileData) {
        return ScheduleEventService.addFromBulkUpload(fileData, null);
    }

    public static AddFromBulkUploadScheduleEventBuilder addFromBulkUpload(File fileData) {
        return ScheduleEventService.addFromBulkUpload(new FileHolder(fileData), null);
    }

    public static AddFromBulkUploadScheduleEventBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return ScheduleEventService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), null);
    }

    public static AddFromBulkUploadScheduleEventBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return ScheduleEventService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), null);
    }

    public static AddFromBulkUploadScheduleEventBuilder addFromBulkUpload(File fileData, BulkUploadScheduleEventJobData bulkUploadData) {
        return ScheduleEventService.addFromBulkUpload(new FileHolder(fileData), bulkUploadData);
    }

    public static AddFromBulkUploadScheduleEventBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadScheduleEventJobData bulkUploadData) {
        return ScheduleEventService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData);
    }

    public static AddFromBulkUploadScheduleEventBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadScheduleEventJobData bulkUploadData) {
        return ScheduleEventService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData);
    }

    public static AddFromBulkUploadScheduleEventBuilder addFromBulkUpload(FileHolder fileData, BulkUploadScheduleEventJobData bulkUploadData) {
        return new AddFromBulkUploadScheduleEventBuilder(fileData, bulkUploadData);
    }

    public static CancelScheduleEventBuilder cancel(int scheduleEventId) {
        return new CancelScheduleEventBuilder(scheduleEventId);
    }

    public static DeleteScheduleEventBuilder delete(int scheduleEventId) {
        return new DeleteScheduleEventBuilder(scheduleEventId);
    }

    public static GetScheduleEventBuilder get(int scheduleEventId) {
        return new GetScheduleEventBuilder(scheduleEventId);
    }

    public static GetConflictsScheduleEventBuilder getConflicts(String resourceIds, ScheduleEvent scheduleEvent) {
        return ScheduleEventService.getConflicts(resourceIds, scheduleEvent, null);
    }

    public static GetConflictsScheduleEventBuilder getConflicts(String resourceIds, ScheduleEvent scheduleEvent, String scheduleEventIdToIgnore) {
        return ScheduleEventService.getConflicts(resourceIds, scheduleEvent, scheduleEventIdToIgnore, ScheduleEventConflictType.get(1));
    }

    public static GetConflictsScheduleEventBuilder getConflicts(String resourceIds, ScheduleEvent scheduleEvent, String scheduleEventIdToIgnore, ScheduleEventConflictType scheduleEventConflictType) {
        return new GetConflictsScheduleEventBuilder(resourceIds, scheduleEvent, scheduleEventIdToIgnore, scheduleEventConflictType);
    }

    public static ListScheduleEventBuilder list() {
        return ScheduleEventService.list(null);
    }

    public static ListScheduleEventBuilder list(ScheduleEventFilter filter) {
        return ScheduleEventService.list(filter, null);
    }

    public static ListScheduleEventBuilder list(ScheduleEventFilter filter, FilterPager pager) {
        return new ListScheduleEventBuilder(filter, pager);
    }

    public static UpdateScheduleEventBuilder update(int scheduleEventId, ScheduleEvent scheduleEvent) {
        return new UpdateScheduleEventBuilder(scheduleEventId, scheduleEvent);
    }

    public static UpdateLiveFeatureScheduleEventBuilder updateLiveFeature(int scheduledEventId, String featureName, LiveFeature liveFeature) {
        return new UpdateLiveFeatureScheduleEventBuilder(scheduledEventId, featureName, liveFeature);
    }

    public static class UpdateLiveFeatureScheduleEventBuilder
    extends RequestBuilder<LiveStreamScheduleEvent, LiveStreamScheduleEvent.Tokenizer, UpdateLiveFeatureScheduleEventBuilder> {
        public UpdateLiveFeatureScheduleEventBuilder(int scheduledEventId, String featureName, LiveFeature liveFeature) {
            super(LiveStreamScheduleEvent.class, "schedule_scheduleevent", "updateLiveFeature");
            this.params.add("scheduledEventId", scheduledEventId);
            this.params.add("featureName", featureName);
            this.params.add("liveFeature", liveFeature);
        }

        public void scheduledEventId(String multirequestToken) {
            this.params.add("scheduledEventId", multirequestToken);
        }

        public void featureName(String multirequestToken) {
            this.params.add("featureName", multirequestToken);
        }
    }

    public static class UpdateScheduleEventBuilder
    extends RequestBuilder<ScheduleEvent, ScheduleEvent.Tokenizer, UpdateScheduleEventBuilder> {
        public UpdateScheduleEventBuilder(int scheduleEventId, ScheduleEvent scheduleEvent) {
            super(ScheduleEvent.class, "schedule_scheduleevent", "update");
            this.params.add("scheduleEventId", scheduleEventId);
            this.params.add("scheduleEvent", scheduleEvent);
        }

        public void scheduleEventId(String multirequestToken) {
            this.params.add("scheduleEventId", multirequestToken);
        }
    }

    public static class ListScheduleEventBuilder
    extends ListResponseRequestBuilder<ScheduleEvent, ScheduleEvent.Tokenizer, ListScheduleEventBuilder> {
        public ListScheduleEventBuilder(ScheduleEventFilter filter, FilterPager pager) {
            super(ScheduleEvent.class, "schedule_scheduleevent", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetConflictsScheduleEventBuilder
    extends ListResponseRequestBuilder<ScheduleEvent, ScheduleEvent.Tokenizer, GetConflictsScheduleEventBuilder> {
        public GetConflictsScheduleEventBuilder(String resourceIds, ScheduleEvent scheduleEvent, String scheduleEventIdToIgnore, ScheduleEventConflictType scheduleEventConflictType) {
            super(ScheduleEvent.class, "schedule_scheduleevent", "getConflicts");
            this.params.add("resourceIds", resourceIds);
            this.params.add("scheduleEvent", scheduleEvent);
            this.params.add("scheduleEventIdToIgnore", scheduleEventIdToIgnore);
            this.params.add("scheduleEventConflictType", scheduleEventConflictType);
        }

        public void resourceIds(String multirequestToken) {
            this.params.add("resourceIds", multirequestToken);
        }

        public void scheduleEventIdToIgnore(String multirequestToken) {
            this.params.add("scheduleEventIdToIgnore", multirequestToken);
        }

        public void scheduleEventConflictType(String multirequestToken) {
            this.params.add("scheduleEventConflictType", multirequestToken);
        }
    }

    public static class GetScheduleEventBuilder
    extends RequestBuilder<ScheduleEvent, ScheduleEvent.Tokenizer, GetScheduleEventBuilder> {
        public GetScheduleEventBuilder(int scheduleEventId) {
            super(ScheduleEvent.class, "schedule_scheduleevent", "get");
            this.params.add("scheduleEventId", scheduleEventId);
        }

        public void scheduleEventId(String multirequestToken) {
            this.params.add("scheduleEventId", multirequestToken);
        }
    }

    public static class DeleteScheduleEventBuilder
    extends RequestBuilder<ScheduleEvent, ScheduleEvent.Tokenizer, DeleteScheduleEventBuilder> {
        public DeleteScheduleEventBuilder(int scheduleEventId) {
            super(ScheduleEvent.class, "schedule_scheduleevent", "delete");
            this.params.add("scheduleEventId", scheduleEventId);
        }

        public void scheduleEventId(String multirequestToken) {
            this.params.add("scheduleEventId", multirequestToken);
        }
    }

    public static class CancelScheduleEventBuilder
    extends RequestBuilder<ScheduleEvent, ScheduleEvent.Tokenizer, CancelScheduleEventBuilder> {
        public CancelScheduleEventBuilder(int scheduleEventId) {
            super(ScheduleEvent.class, "schedule_scheduleevent", "cancel");
            this.params.add("scheduleEventId", scheduleEventId);
        }

        public void scheduleEventId(String multirequestToken) {
            this.params.add("scheduleEventId", multirequestToken);
        }
    }

    public static class AddFromBulkUploadScheduleEventBuilder
    extends RequestBuilder<BulkUpload, BulkUpload.Tokenizer, AddFromBulkUploadScheduleEventBuilder> {
        public AddFromBulkUploadScheduleEventBuilder(FileHolder fileData, BulkUploadScheduleEventJobData bulkUploadData) {
            super(BulkUpload.class, "schedule_scheduleevent", "addFromBulkUpload");
            this.files = new Files();
            this.files.add("fileData", fileData);
            this.params.add("bulkUploadData", bulkUploadData);
        }
    }

    public static class AddScheduleEventBuilder
    extends RequestBuilder<ScheduleEvent, ScheduleEvent.Tokenizer, AddScheduleEventBuilder> {
        public AddScheduleEventBuilder(ScheduleEvent scheduleEvent) {
            super(ScheduleEvent.class, "schedule_scheduleevent", "add");
            this.params.add("scheduleEvent", scheduleEvent);
        }
    }
}

