/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.ResponseProfileStatus;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.ResponseProfile;
import com.kaltura.client.types.ResponseProfileCacheRecalculateOptions;
import com.kaltura.client.types.ResponseProfileCacheRecalculateResults;
import com.kaltura.client.types.ResponseProfileFilter;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class ResponseProfileService {
    public static AddResponseProfileBuilder add(ResponseProfile addResponseProfile) {
        return new AddResponseProfileBuilder(addResponseProfile);
    }

    public static CloneResponseProfileBuilder clone(long id, ResponseProfile profile) {
        return new CloneResponseProfileBuilder(id, profile);
    }

    public static DeleteResponseProfileBuilder delete(long id) {
        return new DeleteResponseProfileBuilder(id);
    }

    public static GetResponseProfileBuilder get(long id) {
        return new GetResponseProfileBuilder(id);
    }

    public static ListResponseProfileBuilder list() {
        return ResponseProfileService.list(null);
    }

    public static ListResponseProfileBuilder list(ResponseProfileFilter filter) {
        return ResponseProfileService.list(filter, null);
    }

    public static ListResponseProfileBuilder list(ResponseProfileFilter filter, FilterPager pager) {
        return new ListResponseProfileBuilder(filter, pager);
    }

    public static RecalculateResponseProfileBuilder recalculate(ResponseProfileCacheRecalculateOptions options) {
        return new RecalculateResponseProfileBuilder(options);
    }

    public static UpdateResponseProfileBuilder update(long id, ResponseProfile updateResponseProfile) {
        return new UpdateResponseProfileBuilder(id, updateResponseProfile);
    }

    public static UpdateStatusResponseProfileBuilder updateStatus(long id, ResponseProfileStatus status) {
        return new UpdateStatusResponseProfileBuilder(id, status);
    }

    public static class UpdateStatusResponseProfileBuilder
    extends RequestBuilder<ResponseProfile, ResponseProfile.Tokenizer, UpdateStatusResponseProfileBuilder> {
        public UpdateStatusResponseProfileBuilder(long id, ResponseProfileStatus status) {
            super(ResponseProfile.class, "responseprofile", "updateStatus");
            this.params.add("id", id);
            this.params.add("status", status);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void status(String multirequestToken) {
            this.params.add("status", multirequestToken);
        }
    }

    public static class UpdateResponseProfileBuilder
    extends RequestBuilder<ResponseProfile, ResponseProfile.Tokenizer, UpdateResponseProfileBuilder> {
        public UpdateResponseProfileBuilder(long id, ResponseProfile updateResponseProfile) {
            super(ResponseProfile.class, "responseprofile", "update");
            this.params.add("id", id);
            this.params.add("updateResponseProfile", updateResponseProfile);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class RecalculateResponseProfileBuilder
    extends RequestBuilder<ResponseProfileCacheRecalculateResults, ResponseProfileCacheRecalculateResults.Tokenizer, RecalculateResponseProfileBuilder> {
        public RecalculateResponseProfileBuilder(ResponseProfileCacheRecalculateOptions options) {
            super(ResponseProfileCacheRecalculateResults.class, "responseprofile", "recalculate");
            this.params.add("options", options);
        }
    }

    public static class ListResponseProfileBuilder
    extends ListResponseRequestBuilder<ResponseProfile, ResponseProfile.Tokenizer, ListResponseProfileBuilder> {
        public ListResponseProfileBuilder(ResponseProfileFilter filter, FilterPager pager) {
            super(ResponseProfile.class, "responseprofile", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetResponseProfileBuilder
    extends RequestBuilder<ResponseProfile, ResponseProfile.Tokenizer, GetResponseProfileBuilder> {
        public GetResponseProfileBuilder(long id) {
            super(ResponseProfile.class, "responseprofile", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class DeleteResponseProfileBuilder
    extends NullRequestBuilder {
        public DeleteResponseProfileBuilder(long id) {
            super("responseprofile", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class CloneResponseProfileBuilder
    extends RequestBuilder<ResponseProfile, ResponseProfile.Tokenizer, CloneResponseProfileBuilder> {
        public CloneResponseProfileBuilder(long id, ResponseProfile profile) {
            super(ResponseProfile.class, "responseprofile", "clone");
            this.params.add("id", id);
            this.params.add("profile", profile);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class AddResponseProfileBuilder
    extends RequestBuilder<ResponseProfile, ResponseProfile.Tokenizer, AddResponseProfileBuilder> {
        public AddResponseProfileBuilder(ResponseProfile addResponseProfile) {
            super(ResponseProfile.class, "responseprofile", "add");
            this.params.add("addResponseProfile", addResponseProfile);
        }
    }
}

