/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class PollService {
    public static AddPollBuilder add() {
        return PollService.add("SINGLE_ANONYMOUS");
    }

    public static AddPollBuilder add(String pollType) {
        return new AddPollBuilder(pollType);
    }

    public static GetVotePollBuilder getVote(String pollId, String userId) {
        return new GetVotePollBuilder(pollId, userId);
    }

    public static GetVotesPollBuilder getVotes(String pollId, String answerIds) {
        return new GetVotesPollBuilder(pollId, answerIds);
    }

    public static ResetVotesPollBuilder resetVotes(String pollId) {
        return new ResetVotesPollBuilder(pollId);
    }

    public static VotePollBuilder vote(String pollId, String userId, String answerIds) {
        return new VotePollBuilder(pollId, userId, answerIds);
    }

    public static class VotePollBuilder
    extends RequestBuilder<String, String, VotePollBuilder> {
        public VotePollBuilder(String pollId, String userId, String answerIds) {
            super(String.class, "poll_poll", "vote");
            this.params.add("pollId", pollId);
            this.params.add("userId", userId);
            this.params.add("answerIds", answerIds);
        }

        public void pollId(String multirequestToken) {
            this.params.add("pollId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void answerIds(String multirequestToken) {
            this.params.add("answerIds", multirequestToken);
        }
    }

    public static class ResetVotesPollBuilder
    extends NullRequestBuilder {
        public ResetVotesPollBuilder(String pollId) {
            super("poll_poll", "resetVotes");
            this.params.add("pollId", pollId);
        }

        public void pollId(String multirequestToken) {
            this.params.add("pollId", multirequestToken);
        }
    }

    public static class GetVotesPollBuilder
    extends RequestBuilder<String, String, GetVotesPollBuilder> {
        public GetVotesPollBuilder(String pollId, String answerIds) {
            super(String.class, "poll_poll", "getVotes");
            this.params.add("pollId", pollId);
            this.params.add("answerIds", answerIds);
        }

        public void pollId(String multirequestToken) {
            this.params.add("pollId", multirequestToken);
        }

        public void answerIds(String multirequestToken) {
            this.params.add("answerIds", multirequestToken);
        }
    }

    public static class GetVotePollBuilder
    extends RequestBuilder<String, String, GetVotePollBuilder> {
        public GetVotePollBuilder(String pollId, String userId) {
            super(String.class, "poll_poll", "getVote");
            this.params.add("pollId", pollId);
            this.params.add("userId", userId);
        }

        public void pollId(String multirequestToken) {
            this.params.add("pollId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }

    public static class AddPollBuilder
    extends RequestBuilder<String, String, AddPollBuilder> {
        public AddPollBuilder(String pollType) {
            super(String.class, "poll_poll", "add");
            this.params.add("pollType", pollType);
        }

        public void pollType(String multirequestToken) {
            this.params.add("pollType", multirequestToken);
        }
    }
}

