/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.PlaylistType;
import com.kaltura.client.types.BaseEntry;
import com.kaltura.client.types.Context;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.MediaEntryFilterForPlaylist;
import com.kaltura.client.types.Playlist;
import com.kaltura.client.types.PlaylistFilter;
import com.kaltura.client.utils.request.ArrayRequestBuilder;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

public class PlaylistService {
    public static AddPlaylistBuilder add(Playlist playlist) {
        return PlaylistService.add(playlist, false);
    }

    public static AddPlaylistBuilder add(Playlist playlist, boolean updateStats) {
        return new AddPlaylistBuilder(playlist, updateStats);
    }

    public static ClonePlaylistBuilder clone(String id) {
        return PlaylistService.clone(id, null);
    }

    public static ClonePlaylistBuilder clone(String id, Playlist newPlaylist) {
        return new ClonePlaylistBuilder(id, newPlaylist);
    }

    public static DeletePlaylistBuilder delete(String id) {
        return new DeletePlaylistBuilder(id);
    }

    public static ExecutePlaylistBuilder execute(String id) {
        return PlaylistService.execute(id, "");
    }

    public static ExecutePlaylistBuilder execute(String id, String detailed) {
        return PlaylistService.execute(id, detailed, null);
    }

    public static ExecutePlaylistBuilder execute(String id, String detailed, Context playlistContext) {
        return PlaylistService.execute(id, detailed, playlistContext, null);
    }

    public static ExecutePlaylistBuilder execute(String id, String detailed, Context playlistContext, MediaEntryFilterForPlaylist filter) {
        return PlaylistService.execute(id, detailed, playlistContext, filter, null);
    }

    public static ExecutePlaylistBuilder execute(String id, String detailed, Context playlistContext, MediaEntryFilterForPlaylist filter, FilterPager pager) {
        return new ExecutePlaylistBuilder(id, detailed, playlistContext, filter, pager);
    }

    public static ExecuteFromContentPlaylistBuilder executeFromContent(PlaylistType playlistType, String playlistContent) {
        return PlaylistService.executeFromContent(playlistType, playlistContent, "");
    }

    public static ExecuteFromContentPlaylistBuilder executeFromContent(PlaylistType playlistType, String playlistContent, String detailed) {
        return PlaylistService.executeFromContent(playlistType, playlistContent, detailed, null);
    }

    public static ExecuteFromContentPlaylistBuilder executeFromContent(PlaylistType playlistType, String playlistContent, String detailed, FilterPager pager) {
        return new ExecuteFromContentPlaylistBuilder(playlistType, playlistContent, detailed, pager);
    }

    public static ExecuteFromFiltersPlaylistBuilder executeFromFilters(List<MediaEntryFilterForPlaylist> filters, int totalResults) {
        return PlaylistService.executeFromFilters(filters, totalResults, "1");
    }

    public static ExecuteFromFiltersPlaylistBuilder executeFromFilters(List<MediaEntryFilterForPlaylist> filters, int totalResults, String detailed) {
        return PlaylistService.executeFromFilters(filters, totalResults, detailed, null);
    }

    public static ExecuteFromFiltersPlaylistBuilder executeFromFilters(List<MediaEntryFilterForPlaylist> filters, int totalResults, String detailed, FilterPager pager) {
        return new ExecuteFromFiltersPlaylistBuilder(filters, totalResults, detailed, pager);
    }

    public static GetPlaylistBuilder get(String id) {
        return PlaylistService.get(id, -1);
    }

    public static GetPlaylistBuilder get(String id, int version) {
        return new GetPlaylistBuilder(id, version);
    }

    public static GetStatsFromContentPlaylistBuilder getStatsFromContent(PlaylistType playlistType, String playlistContent) {
        return new GetStatsFromContentPlaylistBuilder(playlistType, playlistContent);
    }

    public static ListPlaylistBuilder list() {
        return PlaylistService.list(null);
    }

    public static ListPlaylistBuilder list(PlaylistFilter filter) {
        return PlaylistService.list(filter, null);
    }

    public static ListPlaylistBuilder list(PlaylistFilter filter, FilterPager pager) {
        return new ListPlaylistBuilder(filter, pager);
    }

    public static UpdatePlaylistBuilder update(String id, Playlist playlist) {
        return PlaylistService.update(id, playlist, false);
    }

    public static UpdatePlaylistBuilder update(String id, Playlist playlist, boolean updateStats) {
        return new UpdatePlaylistBuilder(id, playlist, updateStats);
    }

    public static class UpdatePlaylistBuilder
    extends RequestBuilder<Playlist, Playlist.Tokenizer, UpdatePlaylistBuilder> {
        public UpdatePlaylistBuilder(String id, Playlist playlist, boolean updateStats) {
            super(Playlist.class, "playlist", "update");
            this.params.add("id", id);
            this.params.add("playlist", playlist);
            this.params.add("updateStats", updateStats);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void updateStats(String multirequestToken) {
            this.params.add("updateStats", multirequestToken);
        }
    }

    public static class ListPlaylistBuilder
    extends ListResponseRequestBuilder<Playlist, Playlist.Tokenizer, ListPlaylistBuilder> {
        public ListPlaylistBuilder(PlaylistFilter filter, FilterPager pager) {
            super(Playlist.class, "playlist", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetStatsFromContentPlaylistBuilder
    extends RequestBuilder<Playlist, Playlist.Tokenizer, GetStatsFromContentPlaylistBuilder> {
        public GetStatsFromContentPlaylistBuilder(PlaylistType playlistType, String playlistContent) {
            super(Playlist.class, "playlist", "getStatsFromContent");
            this.params.add("playlistType", playlistType);
            this.params.add("playlistContent", playlistContent);
        }

        public void playlistType(String multirequestToken) {
            this.params.add("playlistType", multirequestToken);
        }

        public void playlistContent(String multirequestToken) {
            this.params.add("playlistContent", multirequestToken);
        }
    }

    public static class GetPlaylistBuilder
    extends RequestBuilder<Playlist, Playlist.Tokenizer, GetPlaylistBuilder> {
        public GetPlaylistBuilder(String id, int version) {
            super(Playlist.class, "playlist", "get");
            this.params.add("id", id);
            this.params.add("version", version);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class ExecuteFromFiltersPlaylistBuilder
    extends ArrayRequestBuilder<BaseEntry, BaseEntry.Tokenizer, ExecuteFromFiltersPlaylistBuilder> {
        public ExecuteFromFiltersPlaylistBuilder(List<MediaEntryFilterForPlaylist> filters, int totalResults, String detailed, FilterPager pager) {
            super(BaseEntry.class, "playlist", "executeFromFilters");
            this.params.add("filters", filters);
            this.params.add("totalResults", totalResults);
            this.params.add("detailed", detailed);
            this.params.add("pager", pager);
        }

        public void totalResults(String multirequestToken) {
            this.params.add("totalResults", multirequestToken);
        }

        public void detailed(String multirequestToken) {
            this.params.add("detailed", multirequestToken);
        }
    }

    public static class ExecuteFromContentPlaylistBuilder
    extends ArrayRequestBuilder<BaseEntry, BaseEntry.Tokenizer, ExecuteFromContentPlaylistBuilder> {
        public ExecuteFromContentPlaylistBuilder(PlaylistType playlistType, String playlistContent, String detailed, FilterPager pager) {
            super(BaseEntry.class, "playlist", "executeFromContent");
            this.params.add("playlistType", playlistType);
            this.params.add("playlistContent", playlistContent);
            this.params.add("detailed", detailed);
            this.params.add("pager", pager);
        }

        public void playlistType(String multirequestToken) {
            this.params.add("playlistType", multirequestToken);
        }

        public void playlistContent(String multirequestToken) {
            this.params.add("playlistContent", multirequestToken);
        }

        public void detailed(String multirequestToken) {
            this.params.add("detailed", multirequestToken);
        }
    }

    public static class ExecutePlaylistBuilder
    extends ArrayRequestBuilder<BaseEntry, BaseEntry.Tokenizer, ExecutePlaylistBuilder> {
        public ExecutePlaylistBuilder(String id, String detailed, Context playlistContext, MediaEntryFilterForPlaylist filter, FilterPager pager) {
            super(BaseEntry.class, "playlist", "execute");
            this.params.add("id", id);
            this.params.add("detailed", detailed);
            this.params.add("playlistContext", playlistContext);
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void detailed(String multirequestToken) {
            this.params.add("detailed", multirequestToken);
        }
    }

    public static class DeletePlaylistBuilder
    extends NullRequestBuilder {
        public DeletePlaylistBuilder(String id) {
            super("playlist", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ClonePlaylistBuilder
    extends RequestBuilder<Playlist, Playlist.Tokenizer, ClonePlaylistBuilder> {
        public ClonePlaylistBuilder(String id, Playlist newPlaylist) {
            super(Playlist.class, "playlist", "clone");
            this.params.add("id", id);
            this.params.add("newPlaylist", newPlaylist);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class AddPlaylistBuilder
    extends RequestBuilder<Playlist, Playlist.Tokenizer, AddPlaylistBuilder> {
        public AddPlaylistBuilder(Playlist playlist, boolean updateStats) {
            super(Playlist.class, "playlist", "add");
            this.params.add("playlist", playlist);
            this.params.add("updateStats", updateStats);
        }

        public void updateStats(String multirequestToken) {
            this.params.add("updateStats", multirequestToken);
        }
    }
}

