/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.types.BaseEntry;
import com.kaltura.client.types.BulkUpload;
import com.kaltura.client.types.BulkUploadEntryData;
import com.kaltura.client.types.BulkUploadJobData;
import com.kaltura.client.types.ConversionAttribute;
import com.kaltura.client.types.EntryReplacementOptions;
import com.kaltura.client.types.ExtendingItemMrssParameter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.MediaEntry;
import com.kaltura.client.types.MediaEntryFilter;
import com.kaltura.client.types.MediaEsearchExportToCsvJobData;
import com.kaltura.client.types.ModerationFlag;
import com.kaltura.client.types.Resource;
import com.kaltura.client.types.SearchResult;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

public class MediaService {
    public static AddMediaBuilder add(MediaEntry entry) {
        return new AddMediaBuilder(entry);
    }

    public static AddContentMediaBuilder addContent(String entryId) {
        return MediaService.addContent(entryId, null);
    }

    public static AddContentMediaBuilder addContent(String entryId, Resource resource) {
        return new AddContentMediaBuilder(entryId, resource);
    }

    public static AddFromBulkMediaBuilder addFromBulk(MediaEntry mediaEntry, String url, int bulkUploadId) {
        return new AddFromBulkMediaBuilder(mediaEntry, url, bulkUploadId);
    }

    public static AddFromEntryMediaBuilder addFromEntry(String sourceEntryId) {
        return MediaService.addFromEntry(sourceEntryId, null);
    }

    public static AddFromEntryMediaBuilder addFromEntry(String sourceEntryId, MediaEntry mediaEntry) {
        return MediaService.addFromEntry(sourceEntryId, mediaEntry, Integer.MIN_VALUE);
    }

    public static AddFromEntryMediaBuilder addFromEntry(String sourceEntryId, MediaEntry mediaEntry, int sourceFlavorParamsId) {
        return new AddFromEntryMediaBuilder(sourceEntryId, mediaEntry, sourceFlavorParamsId);
    }

    public static AddFromFlavorAssetMediaBuilder addFromFlavorAsset(String sourceFlavorAssetId) {
        return MediaService.addFromFlavorAsset(sourceFlavorAssetId, null);
    }

    public static AddFromFlavorAssetMediaBuilder addFromFlavorAsset(String sourceFlavorAssetId, MediaEntry mediaEntry) {
        return new AddFromFlavorAssetMediaBuilder(sourceFlavorAssetId, mediaEntry);
    }

    public static AddFromRecordedWebcamMediaBuilder addFromRecordedWebcam(MediaEntry mediaEntry, String webcamTokenId) {
        return new AddFromRecordedWebcamMediaBuilder(mediaEntry, webcamTokenId);
    }

    public static AddFromSearchResultMediaBuilder addFromSearchResult() {
        return MediaService.addFromSearchResult(null);
    }

    public static AddFromSearchResultMediaBuilder addFromSearchResult(MediaEntry mediaEntry) {
        return MediaService.addFromSearchResult(mediaEntry, null);
    }

    public static AddFromSearchResultMediaBuilder addFromSearchResult(MediaEntry mediaEntry, SearchResult searchResult) {
        return new AddFromSearchResultMediaBuilder(mediaEntry, searchResult);
    }

    public static AddFromUploadedFileMediaBuilder addFromUploadedFile(MediaEntry mediaEntry, String uploadTokenId) {
        return new AddFromUploadedFileMediaBuilder(mediaEntry, uploadTokenId);
    }

    public static AddFromUrlMediaBuilder addFromUrl(MediaEntry mediaEntry, String url) {
        return new AddFromUrlMediaBuilder(mediaEntry, url);
    }

    public static AnonymousRankMediaBuilder anonymousRank(String entryId, int rank) {
        return new AnonymousRankMediaBuilder(entryId, rank);
    }

    public static ApproveMediaBuilder approve(String entryId) {
        return new ApproveMediaBuilder(entryId);
    }

    public static ApproveReplaceMediaBuilder approveReplace(String entryId) {
        return new ApproveReplaceMediaBuilder(entryId);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(FileHolder fileData) {
        return MediaService.bulkUploadAdd(fileData, null);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(File fileData) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData), null);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), null);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData, fileDataMimeType, fileDataName), null);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(FileHolder fileData, BulkUploadJobData bulkUploadData) {
        return MediaService.bulkUploadAdd(fileData, bulkUploadData, null);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(File fileData, BulkUploadJobData bulkUploadData) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData), bulkUploadData, null);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, null);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, null);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(File fileData, BulkUploadJobData bulkUploadData, BulkUploadEntryData bulkUploadEntryData) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData), bulkUploadData, bulkUploadEntryData);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData, BulkUploadEntryData bulkUploadEntryData) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, bulkUploadEntryData);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData, BulkUploadEntryData bulkUploadEntryData) {
        return MediaService.bulkUploadAdd(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, bulkUploadEntryData);
    }

    public static BulkUploadAddMediaBuilder bulkUploadAdd(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadEntryData bulkUploadEntryData) {
        return new BulkUploadAddMediaBuilder(fileData, bulkUploadData, bulkUploadEntryData);
    }

    public static CancelReplaceMediaBuilder cancelReplace(String entryId) {
        return new CancelReplaceMediaBuilder(entryId);
    }

    public static ConvertMediaBuilder convert(String entryId) {
        return MediaService.convert(entryId, Integer.MIN_VALUE);
    }

    public static ConvertMediaBuilder convert(String entryId, int conversionProfileId) {
        return MediaService.convert(entryId, conversionProfileId, null);
    }

    public static ConvertMediaBuilder convert(String entryId, int conversionProfileId, List<ConversionAttribute> dynamicConversionAttributes) {
        return new ConvertMediaBuilder(entryId, conversionProfileId, dynamicConversionAttributes);
    }

    public static CountMediaBuilder count() {
        return MediaService.count(null);
    }

    public static CountMediaBuilder count(MediaEntryFilter filter) {
        return new CountMediaBuilder(filter);
    }

    public static DeleteMediaBuilder delete(String entryId) {
        return new DeleteMediaBuilder(entryId);
    }

    public static ExportToCsvMediaBuilder exportToCsv(MediaEsearchExportToCsvJobData data) {
        return new ExportToCsvMediaBuilder(data);
    }

    public static FlagMediaBuilder flag(ModerationFlag moderationFlag) {
        return new FlagMediaBuilder(moderationFlag);
    }

    public static GetMediaBuilder get(String entryId) {
        return MediaService.get(entryId, -1);
    }

    public static GetMediaBuilder get(String entryId, int version) {
        return new GetMediaBuilder(entryId, version);
    }

    public static GetMrssMediaBuilder getMrss(String entryId) {
        return MediaService.getMrss(entryId, null);
    }

    public static GetMrssMediaBuilder getMrss(String entryId, List<ExtendingItemMrssParameter> extendingItemsArray) {
        return MediaService.getMrss(entryId, extendingItemsArray, null);
    }

    public static GetMrssMediaBuilder getMrss(String entryId, List<ExtendingItemMrssParameter> extendingItemsArray, String features) {
        return new GetMrssMediaBuilder(entryId, extendingItemsArray, features);
    }

    public static GetVolumeMapMediaBuilder getVolumeMap(String entryId) {
        return new GetVolumeMapMediaBuilder(entryId);
    }

    public static ListMediaBuilder list() {
        return MediaService.list(null);
    }

    public static ListMediaBuilder list(MediaEntryFilter filter) {
        return MediaService.list(filter, null);
    }

    public static ListMediaBuilder list(MediaEntryFilter filter, FilterPager pager) {
        return new ListMediaBuilder(filter, pager);
    }

    public static ListFlagsMediaBuilder listFlags(String entryId) {
        return MediaService.listFlags(entryId, null);
    }

    public static ListFlagsMediaBuilder listFlags(String entryId, FilterPager pager) {
        return new ListFlagsMediaBuilder(entryId, pager);
    }

    public static RejectMediaBuilder reject(String entryId) {
        return new RejectMediaBuilder(entryId);
    }

    public static RequestConversionMediaBuilder requestConversion(String entryId, String fileFormat) {
        return new RequestConversionMediaBuilder(entryId, fileFormat);
    }

    public static UpdateMediaBuilder update(String entryId, MediaEntry mediaEntry) {
        return new UpdateMediaBuilder(entryId, mediaEntry);
    }

    public static UpdateContentMediaBuilder updateContent(String entryId, Resource resource) {
        return MediaService.updateContent(entryId, resource, Integer.MIN_VALUE);
    }

    public static UpdateContentMediaBuilder updateContent(String entryId, Resource resource, int conversionProfileId) {
        return MediaService.updateContent(entryId, resource, conversionProfileId, null);
    }

    public static UpdateContentMediaBuilder updateContent(String entryId, Resource resource, int conversionProfileId, EntryReplacementOptions advancedOptions) {
        return new UpdateContentMediaBuilder(entryId, resource, conversionProfileId, advancedOptions);
    }

    public static UpdateThumbnailMediaBuilder updateThumbnail(String entryId, int timeOffset) {
        return MediaService.updateThumbnail(entryId, timeOffset, Integer.MIN_VALUE);
    }

    public static UpdateThumbnailMediaBuilder updateThumbnail(String entryId, int timeOffset, int flavorParamsId) {
        return new UpdateThumbnailMediaBuilder(entryId, timeOffset, flavorParamsId);
    }

    public static UpdateThumbnailFromSourceEntryMediaBuilder updateThumbnailFromSourceEntry(String entryId, String sourceEntryId, int timeOffset) {
        return MediaService.updateThumbnailFromSourceEntry(entryId, sourceEntryId, timeOffset, Integer.MIN_VALUE);
    }

    public static UpdateThumbnailFromSourceEntryMediaBuilder updateThumbnailFromSourceEntry(String entryId, String sourceEntryId, int timeOffset, int flavorParamsId) {
        return new UpdateThumbnailFromSourceEntryMediaBuilder(entryId, sourceEntryId, timeOffset, flavorParamsId);
    }

    public static UpdateThumbnailFromUrlMediaBuilder updateThumbnailFromUrl(String entryId, String url) {
        return new UpdateThumbnailFromUrlMediaBuilder(entryId, url);
    }

    public static UpdateThumbnailJpegMediaBuilder updateThumbnailJpeg(String entryId, File fileData) {
        return MediaService.updateThumbnailJpeg(entryId, new FileHolder(fileData));
    }

    public static UpdateThumbnailJpegMediaBuilder updateThumbnailJpeg(String entryId, InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return MediaService.updateThumbnailJpeg(entryId, new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static UpdateThumbnailJpegMediaBuilder updateThumbnailJpeg(String entryId, FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return MediaService.updateThumbnailJpeg(entryId, new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static UpdateThumbnailJpegMediaBuilder updateThumbnailJpeg(String entryId, FileHolder fileData) {
        return new UpdateThumbnailJpegMediaBuilder(entryId, fileData);
    }

    public static UploadMediaBuilder upload(File fileData) {
        return MediaService.upload(new FileHolder(fileData));
    }

    public static UploadMediaBuilder upload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return MediaService.upload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize));
    }

    public static UploadMediaBuilder upload(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return MediaService.upload(new FileHolder(fileData, fileDataMimeType, fileDataName));
    }

    public static UploadMediaBuilder upload(FileHolder fileData) {
        return new UploadMediaBuilder(fileData);
    }

    public static class UploadMediaBuilder
    extends RequestBuilder<String, String, UploadMediaBuilder> {
        public UploadMediaBuilder(FileHolder fileData) {
            super(String.class, "media", "upload");
            this.files = new Files();
            this.files.add("fileData", fileData);
        }
    }

    public static class UpdateThumbnailJpegMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, UpdateThumbnailJpegMediaBuilder> {
        public UpdateThumbnailJpegMediaBuilder(String entryId, FileHolder fileData) {
            super(MediaEntry.class, "media", "updateThumbnailJpeg");
            this.params.add("entryId", entryId);
            this.files = new Files();
            this.files.add("fileData", fileData);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class UpdateThumbnailFromUrlMediaBuilder
    extends RequestBuilder<BaseEntry, BaseEntry.Tokenizer, UpdateThumbnailFromUrlMediaBuilder> {
        public UpdateThumbnailFromUrlMediaBuilder(String entryId, String url) {
            super(BaseEntry.class, "media", "updateThumbnailFromUrl");
            this.params.add("entryId", entryId);
            this.params.add("url", url);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class UpdateThumbnailFromSourceEntryMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, UpdateThumbnailFromSourceEntryMediaBuilder> {
        public UpdateThumbnailFromSourceEntryMediaBuilder(String entryId, String sourceEntryId, int timeOffset, int flavorParamsId) {
            super(MediaEntry.class, "media", "updateThumbnailFromSourceEntry");
            this.params.add("entryId", entryId);
            this.params.add("sourceEntryId", sourceEntryId);
            this.params.add("timeOffset", timeOffset);
            this.params.add("flavorParamsId", flavorParamsId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void sourceEntryId(String multirequestToken) {
            this.params.add("sourceEntryId", multirequestToken);
        }

        public void timeOffset(String multirequestToken) {
            this.params.add("timeOffset", multirequestToken);
        }

        public void flavorParamsId(String multirequestToken) {
            this.params.add("flavorParamsId", multirequestToken);
        }
    }

    public static class UpdateThumbnailMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, UpdateThumbnailMediaBuilder> {
        public UpdateThumbnailMediaBuilder(String entryId, int timeOffset, int flavorParamsId) {
            super(MediaEntry.class, "media", "updateThumbnail");
            this.params.add("entryId", entryId);
            this.params.add("timeOffset", timeOffset);
            this.params.add("flavorParamsId", flavorParamsId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void timeOffset(String multirequestToken) {
            this.params.add("timeOffset", multirequestToken);
        }

        public void flavorParamsId(String multirequestToken) {
            this.params.add("flavorParamsId", multirequestToken);
        }
    }

    public static class UpdateContentMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, UpdateContentMediaBuilder> {
        public UpdateContentMediaBuilder(String entryId, Resource resource, int conversionProfileId, EntryReplacementOptions advancedOptions) {
            super(MediaEntry.class, "media", "updateContent");
            this.params.add("entryId", entryId);
            this.params.add("resource", resource);
            this.params.add("conversionProfileId", conversionProfileId);
            this.params.add("advancedOptions", advancedOptions);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void conversionProfileId(String multirequestToken) {
            this.params.add("conversionProfileId", multirequestToken);
        }
    }

    public static class UpdateMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, UpdateMediaBuilder> {
        public UpdateMediaBuilder(String entryId, MediaEntry mediaEntry) {
            super(MediaEntry.class, "media", "update");
            this.params.add("entryId", entryId);
            this.params.add("mediaEntry", mediaEntry);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class RequestConversionMediaBuilder
    extends RequestBuilder<Integer, String, RequestConversionMediaBuilder> {
        public RequestConversionMediaBuilder(String entryId, String fileFormat) {
            super(Integer.class, "media", "requestConversion");
            this.params.add("entryId", entryId);
            this.params.add("fileFormat", fileFormat);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void fileFormat(String multirequestToken) {
            this.params.add("fileFormat", multirequestToken);
        }
    }

    public static class RejectMediaBuilder
    extends NullRequestBuilder {
        public RejectMediaBuilder(String entryId) {
            super("media", "reject");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ListFlagsMediaBuilder
    extends ListResponseRequestBuilder<ModerationFlag, ModerationFlag.Tokenizer, ListFlagsMediaBuilder> {
        public ListFlagsMediaBuilder(String entryId, FilterPager pager) {
            super(ModerationFlag.class, "media", "listFlags");
            this.params.add("entryId", entryId);
            this.params.add("pager", pager);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ListMediaBuilder
    extends ListResponseRequestBuilder<MediaEntry, MediaEntry.Tokenizer, ListMediaBuilder> {
        public ListMediaBuilder(MediaEntryFilter filter, FilterPager pager) {
            super(MediaEntry.class, "media", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetVolumeMapMediaBuilder
    extends ServeRequestBuilder {
        public GetVolumeMapMediaBuilder(String entryId) {
            super("media", "getVolumeMap");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class GetMrssMediaBuilder
    extends RequestBuilder<String, String, GetMrssMediaBuilder> {
        public GetMrssMediaBuilder(String entryId, List<ExtendingItemMrssParameter> extendingItemsArray, String features) {
            super(String.class, "media", "getMrss");
            this.params.add("entryId", entryId);
            this.params.add("extendingItemsArray", extendingItemsArray);
            this.params.add("features", features);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void features(String multirequestToken) {
            this.params.add("features", multirequestToken);
        }
    }

    public static class GetMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, GetMediaBuilder> {
        public GetMediaBuilder(String entryId, int version) {
            super(MediaEntry.class, "media", "get");
            this.params.add("entryId", entryId);
            this.params.add("version", version);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void version(String multirequestToken) {
            this.params.add("version", multirequestToken);
        }
    }

    public static class FlagMediaBuilder
    extends NullRequestBuilder {
        public FlagMediaBuilder(ModerationFlag moderationFlag) {
            super("media", "flag");
            this.params.add("moderationFlag", moderationFlag);
        }
    }

    public static class ExportToCsvMediaBuilder
    extends RequestBuilder<String, String, ExportToCsvMediaBuilder> {
        public ExportToCsvMediaBuilder(MediaEsearchExportToCsvJobData data) {
            super(String.class, "media", "exportToCsv");
            this.params.add("data", data);
        }
    }

    public static class DeleteMediaBuilder
    extends NullRequestBuilder {
        public DeleteMediaBuilder(String entryId) {
            super("media", "delete");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class CountMediaBuilder
    extends RequestBuilder<Integer, String, CountMediaBuilder> {
        public CountMediaBuilder(MediaEntryFilter filter) {
            super(Integer.class, "media", "count");
            this.params.add("filter", filter);
        }
    }

    public static class ConvertMediaBuilder
    extends RequestBuilder<Long, String, ConvertMediaBuilder> {
        public ConvertMediaBuilder(String entryId, int conversionProfileId, List<ConversionAttribute> dynamicConversionAttributes) {
            super(Long.class, "media", "convert");
            this.params.add("entryId", entryId);
            this.params.add("conversionProfileId", conversionProfileId);
            this.params.add("dynamicConversionAttributes", dynamicConversionAttributes);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void conversionProfileId(String multirequestToken) {
            this.params.add("conversionProfileId", multirequestToken);
        }
    }

    public static class CancelReplaceMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, CancelReplaceMediaBuilder> {
        public CancelReplaceMediaBuilder(String entryId) {
            super(MediaEntry.class, "media", "cancelReplace");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class BulkUploadAddMediaBuilder
    extends RequestBuilder<BulkUpload, BulkUpload.Tokenizer, BulkUploadAddMediaBuilder> {
        public BulkUploadAddMediaBuilder(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadEntryData bulkUploadEntryData) {
            super(BulkUpload.class, "media", "bulkUploadAdd");
            this.files = new Files();
            this.files.add("fileData", fileData);
            this.params.add("bulkUploadData", bulkUploadData);
            this.params.add("bulkUploadEntryData", bulkUploadEntryData);
        }
    }

    public static class ApproveReplaceMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, ApproveReplaceMediaBuilder> {
        public ApproveReplaceMediaBuilder(String entryId) {
            super(MediaEntry.class, "media", "approveReplace");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class ApproveMediaBuilder
    extends NullRequestBuilder {
        public ApproveMediaBuilder(String entryId) {
            super("media", "approve");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AnonymousRankMediaBuilder
    extends NullRequestBuilder {
        public AnonymousRankMediaBuilder(String entryId, int rank) {
            super("media", "anonymousRank");
            this.params.add("entryId", entryId);
            this.params.add("rank", rank);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void rank(String multirequestToken) {
            this.params.add("rank", multirequestToken);
        }
    }

    public static class AddFromUrlMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddFromUrlMediaBuilder> {
        public AddFromUrlMediaBuilder(MediaEntry mediaEntry, String url) {
            super(MediaEntry.class, "media", "addFromUrl");
            this.params.add("mediaEntry", mediaEntry);
            this.params.add("url", url);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }
    }

    public static class AddFromUploadedFileMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddFromUploadedFileMediaBuilder> {
        public AddFromUploadedFileMediaBuilder(MediaEntry mediaEntry, String uploadTokenId) {
            super(MediaEntry.class, "media", "addFromUploadedFile");
            this.params.add("mediaEntry", mediaEntry);
            this.params.add("uploadTokenId", uploadTokenId);
        }

        public void uploadTokenId(String multirequestToken) {
            this.params.add("uploadTokenId", multirequestToken);
        }
    }

    public static class AddFromSearchResultMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddFromSearchResultMediaBuilder> {
        public AddFromSearchResultMediaBuilder(MediaEntry mediaEntry, SearchResult searchResult) {
            super(MediaEntry.class, "media", "addFromSearchResult");
            this.params.add("mediaEntry", mediaEntry);
            this.params.add("searchResult", searchResult);
        }
    }

    public static class AddFromRecordedWebcamMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddFromRecordedWebcamMediaBuilder> {
        public AddFromRecordedWebcamMediaBuilder(MediaEntry mediaEntry, String webcamTokenId) {
            super(MediaEntry.class, "media", "addFromRecordedWebcam");
            this.params.add("mediaEntry", mediaEntry);
            this.params.add("webcamTokenId", webcamTokenId);
        }

        public void webcamTokenId(String multirequestToken) {
            this.params.add("webcamTokenId", multirequestToken);
        }
    }

    public static class AddFromFlavorAssetMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddFromFlavorAssetMediaBuilder> {
        public AddFromFlavorAssetMediaBuilder(String sourceFlavorAssetId, MediaEntry mediaEntry) {
            super(MediaEntry.class, "media", "addFromFlavorAsset");
            this.params.add("sourceFlavorAssetId", sourceFlavorAssetId);
            this.params.add("mediaEntry", mediaEntry);
        }

        public void sourceFlavorAssetId(String multirequestToken) {
            this.params.add("sourceFlavorAssetId", multirequestToken);
        }
    }

    public static class AddFromEntryMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddFromEntryMediaBuilder> {
        public AddFromEntryMediaBuilder(String sourceEntryId, MediaEntry mediaEntry, int sourceFlavorParamsId) {
            super(MediaEntry.class, "media", "addFromEntry");
            this.params.add("sourceEntryId", sourceEntryId);
            this.params.add("mediaEntry", mediaEntry);
            this.params.add("sourceFlavorParamsId", sourceFlavorParamsId);
        }

        public void sourceEntryId(String multirequestToken) {
            this.params.add("sourceEntryId", multirequestToken);
        }

        public void sourceFlavorParamsId(String multirequestToken) {
            this.params.add("sourceFlavorParamsId", multirequestToken);
        }
    }

    public static class AddFromBulkMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddFromBulkMediaBuilder> {
        public AddFromBulkMediaBuilder(MediaEntry mediaEntry, String url, int bulkUploadId) {
            super(MediaEntry.class, "media", "addFromBulk");
            this.params.add("mediaEntry", mediaEntry);
            this.params.add("url", url);
            this.params.add("bulkUploadId", bulkUploadId);
        }

        public void url(String multirequestToken) {
            this.params.add("url", multirequestToken);
        }

        public void bulkUploadId(String multirequestToken) {
            this.params.add("bulkUploadId", multirequestToken);
        }
    }

    public static class AddContentMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddContentMediaBuilder> {
        public AddContentMediaBuilder(String entryId, Resource resource) {
            super(MediaEntry.class, "media", "addContent");
            this.params.add("entryId", entryId);
            this.params.add("resource", resource);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class AddMediaBuilder
    extends RequestBuilder<MediaEntry, MediaEntry.Tokenizer, AddMediaBuilder> {
        public AddMediaBuilder(MediaEntry entry) {
            super(MediaEntry.class, "media", "add");
            this.params.add("entry", entry);
        }
    }
}

