/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.AssetFilter;
import com.kaltura.client.types.ContentResource;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.FlavorAsset;
import com.kaltura.client.types.FlavorAssetUrlOptions;
import com.kaltura.client.types.FlavorAssetWithParams;
import com.kaltura.client.types.RemotePath;
import com.kaltura.client.utils.request.ArrayRequestBuilder;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;

public class FlavorAssetService {
    public static AddFlavorAssetBuilder add(String entryId, FlavorAsset flavorAsset) {
        return new AddFlavorAssetBuilder(entryId, flavorAsset);
    }

    public static ConvertFlavorAssetBuilder convert(String entryId, int flavorParamsId) {
        return FlavorAssetService.convert(entryId, flavorParamsId, 0);
    }

    public static ConvertFlavorAssetBuilder convert(String entryId, int flavorParamsId, int priority) {
        return new ConvertFlavorAssetBuilder(entryId, flavorParamsId, priority);
    }

    public static DeleteFlavorAssetBuilder delete(String id) {
        return new DeleteFlavorAssetBuilder(id);
    }

    public static DeleteLocalContentFlavorAssetBuilder deleteLocalContent(String assetId) {
        return new DeleteLocalContentFlavorAssetBuilder(assetId);
    }

    public static ExportFlavorAssetBuilder export(String assetId, int storageProfileId) {
        return new ExportFlavorAssetBuilder(assetId, storageProfileId);
    }

    public static GetFlavorAssetBuilder get(String id) {
        return new GetFlavorAssetBuilder(id);
    }

    public static GetByEntryIdFlavorAssetBuilder getByEntryId(String entryId) {
        return new GetByEntryIdFlavorAssetBuilder(entryId);
    }

    public static GetDownloadUrlFlavorAssetBuilder getDownloadUrl(String id) {
        return FlavorAssetService.getDownloadUrl(id, false);
    }

    public static GetDownloadUrlFlavorAssetBuilder getDownloadUrl(String id, boolean useCdn) {
        return new GetDownloadUrlFlavorAssetBuilder(id, useCdn);
    }

    public static GetFlavorAssetsWithParamsFlavorAssetBuilder getFlavorAssetsWithParams(String entryId) {
        return new GetFlavorAssetsWithParamsFlavorAssetBuilder(entryId);
    }

    public static GetRemotePathsFlavorAssetBuilder getRemotePaths(String id) {
        return new GetRemotePathsFlavorAssetBuilder(id);
    }

    public static GetUrlFlavorAssetBuilder getUrl(String id) {
        return FlavorAssetService.getUrl(id, Integer.MIN_VALUE);
    }

    public static GetUrlFlavorAssetBuilder getUrl(String id, int storageId) {
        return FlavorAssetService.getUrl(id, storageId, false);
    }

    public static GetUrlFlavorAssetBuilder getUrl(String id, int storageId, boolean forceProxy) {
        return FlavorAssetService.getUrl(id, storageId, forceProxy, null);
    }

    public static GetUrlFlavorAssetBuilder getUrl(String id, int storageId, boolean forceProxy, FlavorAssetUrlOptions options) {
        return new GetUrlFlavorAssetBuilder(id, storageId, forceProxy, options);
    }

    public static GetVolumeMapFlavorAssetBuilder getVolumeMap(String flavorId) {
        return new GetVolumeMapFlavorAssetBuilder(flavorId);
    }

    public static GetWebPlayableByEntryIdFlavorAssetBuilder getWebPlayableByEntryId(String entryId) {
        return new GetWebPlayableByEntryIdFlavorAssetBuilder(entryId);
    }

    public static ListFlavorAssetBuilder list() {
        return FlavorAssetService.list(null);
    }

    public static ListFlavorAssetBuilder list(AssetFilter filter) {
        return FlavorAssetService.list(filter, null);
    }

    public static ListFlavorAssetBuilder list(AssetFilter filter, FilterPager pager) {
        return new ListFlavorAssetBuilder(filter, pager);
    }

    public static ReconvertFlavorAssetBuilder reconvert(String id) {
        return new ReconvertFlavorAssetBuilder(id);
    }

    public static ServeAdStitchCmdFlavorAssetBuilder serveAdStitchCmd(String assetId) {
        return FlavorAssetService.serveAdStitchCmd(assetId, null);
    }

    public static ServeAdStitchCmdFlavorAssetBuilder serveAdStitchCmd(String assetId, String ffprobeJson) {
        return FlavorAssetService.serveAdStitchCmd(assetId, ffprobeJson, null);
    }

    public static ServeAdStitchCmdFlavorAssetBuilder serveAdStitchCmd(String assetId, String ffprobeJson, String duration) {
        return new ServeAdStitchCmdFlavorAssetBuilder(assetId, ffprobeJson, duration);
    }

    public static SetAsSourceFlavorAssetBuilder setAsSource(String assetId) {
        return new SetAsSourceFlavorAssetBuilder(assetId);
    }

    public static SetContentFlavorAssetBuilder setContent(String id, ContentResource contentResource) {
        return new SetContentFlavorAssetBuilder(id, contentResource);
    }

    public static UpdateFlavorAssetBuilder update(String id, FlavorAsset flavorAsset) {
        return new UpdateFlavorAssetBuilder(id, flavorAsset);
    }

    public static class UpdateFlavorAssetBuilder
    extends RequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, UpdateFlavorAssetBuilder> {
        public UpdateFlavorAssetBuilder(String id, FlavorAsset flavorAsset) {
            super(FlavorAsset.class, "flavorasset", "update");
            this.params.add("id", id);
            this.params.add("flavorAsset", flavorAsset);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class SetContentFlavorAssetBuilder
    extends RequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, SetContentFlavorAssetBuilder> {
        public SetContentFlavorAssetBuilder(String id, ContentResource contentResource) {
            super(FlavorAsset.class, "flavorasset", "setContent");
            this.params.add("id", id);
            this.params.add("contentResource", contentResource);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class SetAsSourceFlavorAssetBuilder
    extends NullRequestBuilder {
        public SetAsSourceFlavorAssetBuilder(String assetId) {
            super("flavorasset", "setAsSource");
            this.params.add("assetId", assetId);
        }

        public void assetId(String multirequestToken) {
            this.params.add("assetId", multirequestToken);
        }
    }

    public static class ServeAdStitchCmdFlavorAssetBuilder
    extends RequestBuilder<String, String, ServeAdStitchCmdFlavorAssetBuilder> {
        public ServeAdStitchCmdFlavorAssetBuilder(String assetId, String ffprobeJson, String duration) {
            super(String.class, "flavorasset", "serveAdStitchCmd");
            this.params.add("assetId", assetId);
            this.params.add("ffprobeJson", ffprobeJson);
            this.params.add("duration", duration);
        }

        public void assetId(String multirequestToken) {
            this.params.add("assetId", multirequestToken);
        }

        public void ffprobeJson(String multirequestToken) {
            this.params.add("ffprobeJson", multirequestToken);
        }

        public void duration(String multirequestToken) {
            this.params.add("duration", multirequestToken);
        }
    }

    public static class ReconvertFlavorAssetBuilder
    extends NullRequestBuilder {
        public ReconvertFlavorAssetBuilder(String id) {
            super("flavorasset", "reconvert");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ListFlavorAssetBuilder
    extends ListResponseRequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, ListFlavorAssetBuilder> {
        public ListFlavorAssetBuilder(AssetFilter filter, FilterPager pager) {
            super(FlavorAsset.class, "flavorasset", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetWebPlayableByEntryIdFlavorAssetBuilder
    extends ArrayRequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, GetWebPlayableByEntryIdFlavorAssetBuilder> {
        public GetWebPlayableByEntryIdFlavorAssetBuilder(String entryId) {
            super(FlavorAsset.class, "flavorasset", "getWebPlayableByEntryId");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class GetVolumeMapFlavorAssetBuilder
    extends ServeRequestBuilder {
        public GetVolumeMapFlavorAssetBuilder(String flavorId) {
            super("flavorasset", "getVolumeMap");
            this.params.add("flavorId", flavorId);
        }

        public void flavorId(String multirequestToken) {
            this.params.add("flavorId", multirequestToken);
        }
    }

    public static class GetUrlFlavorAssetBuilder
    extends RequestBuilder<String, String, GetUrlFlavorAssetBuilder> {
        public GetUrlFlavorAssetBuilder(String id, int storageId, boolean forceProxy, FlavorAssetUrlOptions options) {
            super(String.class, "flavorasset", "getUrl");
            this.params.add("id", id);
            this.params.add("storageId", storageId);
            this.params.add("forceProxy", forceProxy);
            this.params.add("options", options);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void storageId(String multirequestToken) {
            this.params.add("storageId", multirequestToken);
        }

        public void forceProxy(String multirequestToken) {
            this.params.add("forceProxy", multirequestToken);
        }
    }

    public static class GetRemotePathsFlavorAssetBuilder
    extends ListResponseRequestBuilder<RemotePath, RemotePath.Tokenizer, GetRemotePathsFlavorAssetBuilder> {
        public GetRemotePathsFlavorAssetBuilder(String id) {
            super(RemotePath.class, "flavorasset", "getRemotePaths");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class GetFlavorAssetsWithParamsFlavorAssetBuilder
    extends ArrayRequestBuilder<FlavorAssetWithParams, FlavorAssetWithParams.Tokenizer, GetFlavorAssetsWithParamsFlavorAssetBuilder> {
        public GetFlavorAssetsWithParamsFlavorAssetBuilder(String entryId) {
            super(FlavorAssetWithParams.class, "flavorasset", "getFlavorAssetsWithParams");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class GetDownloadUrlFlavorAssetBuilder
    extends RequestBuilder<String, String, GetDownloadUrlFlavorAssetBuilder> {
        public GetDownloadUrlFlavorAssetBuilder(String id, boolean useCdn) {
            super(String.class, "flavorasset", "getDownloadUrl");
            this.params.add("id", id);
            this.params.add("useCdn", useCdn);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void useCdn(String multirequestToken) {
            this.params.add("useCdn", multirequestToken);
        }
    }

    public static class GetByEntryIdFlavorAssetBuilder
    extends ArrayRequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, GetByEntryIdFlavorAssetBuilder> {
        public GetByEntryIdFlavorAssetBuilder(String entryId) {
            super(FlavorAsset.class, "flavorasset", "getByEntryId");
            this.params.add("entryId", entryId);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }

    public static class GetFlavorAssetBuilder
    extends RequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, GetFlavorAssetBuilder> {
        public GetFlavorAssetBuilder(String id) {
            super(FlavorAsset.class, "flavorasset", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ExportFlavorAssetBuilder
    extends RequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, ExportFlavorAssetBuilder> {
        public ExportFlavorAssetBuilder(String assetId, int storageProfileId) {
            super(FlavorAsset.class, "flavorasset", "export");
            this.params.add("assetId", assetId);
            this.params.add("storageProfileId", storageProfileId);
        }

        public void assetId(String multirequestToken) {
            this.params.add("assetId", multirequestToken);
        }

        public void storageProfileId(String multirequestToken) {
            this.params.add("storageProfileId", multirequestToken);
        }
    }

    public static class DeleteLocalContentFlavorAssetBuilder
    extends NullRequestBuilder {
        public DeleteLocalContentFlavorAssetBuilder(String assetId) {
            super("flavorasset", "deleteLocalContent");
            this.params.add("assetId", assetId);
        }

        public void assetId(String multirequestToken) {
            this.params.add("assetId", multirequestToken);
        }
    }

    public static class DeleteFlavorAssetBuilder
    extends NullRequestBuilder {
        public DeleteFlavorAssetBuilder(String id) {
            super("flavorasset", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ConvertFlavorAssetBuilder
    extends NullRequestBuilder {
        public ConvertFlavorAssetBuilder(String entryId, int flavorParamsId, int priority) {
            super("flavorasset", "convert");
            this.params.add("entryId", entryId);
            this.params.add("flavorParamsId", flavorParamsId);
            this.params.add("priority", priority);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }

        public void flavorParamsId(String multirequestToken) {
            this.params.add("flavorParamsId", multirequestToken);
        }

        public void priority(String multirequestToken) {
            this.params.add("priority", multirequestToken);
        }
    }

    public static class AddFlavorAssetBuilder
    extends RequestBuilder<FlavorAsset, FlavorAsset.Tokenizer, AddFlavorAssetBuilder> {
        public AddFlavorAssetBuilder(String entryId, FlavorAsset flavorAsset) {
            super(FlavorAsset.class, "flavorasset", "add");
            this.params.add("entryId", entryId);
            this.params.add("flavorAsset", flavorAsset);
        }

        public void entryId(String multirequestToken) {
            this.params.add("entryId", multirequestToken);
        }
    }
}

