/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.ContentResource;
import com.kaltura.client.types.FileAsset;
import com.kaltura.client.types.FileAssetFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import com.kaltura.client.utils.request.ServeRequestBuilder;

public class FileAssetService {
    public static AddFileAssetBuilder add(FileAsset fileAsset) {
        return new AddFileAssetBuilder(fileAsset);
    }

    public static DeleteFileAssetBuilder delete(long id) {
        return new DeleteFileAssetBuilder(id);
    }

    public static GetFileAssetBuilder get(long id) {
        return new GetFileAssetBuilder(id);
    }

    public static ListFileAssetBuilder list(FileAssetFilter filter) {
        return FileAssetService.list(filter, null);
    }

    public static ListFileAssetBuilder list(FileAssetFilter filter, FilterPager pager) {
        return new ListFileAssetBuilder(filter, pager);
    }

    public static ServeFileAssetBuilder serve(long id) {
        return new ServeFileAssetBuilder(id);
    }

    public static SetContentFileAssetBuilder setContent(long id, ContentResource contentResource) {
        return new SetContentFileAssetBuilder(id, contentResource);
    }

    public static UpdateFileAssetBuilder update(long id, FileAsset fileAsset) {
        return new UpdateFileAssetBuilder(id, fileAsset);
    }

    public static class UpdateFileAssetBuilder
    extends RequestBuilder<FileAsset, FileAsset.Tokenizer, UpdateFileAssetBuilder> {
        public UpdateFileAssetBuilder(long id, FileAsset fileAsset) {
            super(FileAsset.class, "fileasset", "update");
            this.params.add("id", id);
            this.params.add("fileAsset", fileAsset);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class SetContentFileAssetBuilder
    extends RequestBuilder<FileAsset, FileAsset.Tokenizer, SetContentFileAssetBuilder> {
        public SetContentFileAssetBuilder(long id, ContentResource contentResource) {
            super(FileAsset.class, "fileasset", "setContent");
            this.params.add("id", id);
            this.params.add("contentResource", contentResource);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ServeFileAssetBuilder
    extends ServeRequestBuilder {
        public ServeFileAssetBuilder(long id) {
            super("fileasset", "serve");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ListFileAssetBuilder
    extends ListResponseRequestBuilder<FileAsset, FileAsset.Tokenizer, ListFileAssetBuilder> {
        public ListFileAssetBuilder(FileAssetFilter filter, FilterPager pager) {
            super(FileAsset.class, "fileasset", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetFileAssetBuilder
    extends RequestBuilder<FileAsset, FileAsset.Tokenizer, GetFileAssetBuilder> {
        public GetFileAssetBuilder(long id) {
            super(FileAsset.class, "fileasset", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class DeleteFileAssetBuilder
    extends NullRequestBuilder {
        public DeleteFileAssetBuilder(long id) {
            super("fileasset", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class AddFileAssetBuilder
    extends RequestBuilder<FileAsset, FileAsset.Tokenizer, AddFileAssetBuilder> {
        public AddFileAssetBuilder(FileAsset fileAsset) {
            super(FileAsset.class, "fileasset", "add");
            this.params.add("fileAsset", fileAsset);
        }
    }
}

