/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.types.BulkUpload;
import com.kaltura.client.types.BulkUploadCategoryUserData;
import com.kaltura.client.types.BulkUploadJobData;
import com.kaltura.client.types.CategoryUser;
import com.kaltura.client.types.CategoryUserFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class CategoryUserService {
    public static ActivateCategoryUserBuilder activate(int categoryId, String userId) {
        return new ActivateCategoryUserBuilder(categoryId, userId);
    }

    public static AddCategoryUserBuilder add(CategoryUser categoryUser) {
        return new AddCategoryUserBuilder(categoryUser);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(FileHolder fileData) {
        return CategoryUserService.addFromBulkUpload(fileData, null);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(File fileData) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData), null);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), null);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), null);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(FileHolder fileData, BulkUploadJobData bulkUploadData) {
        return CategoryUserService.addFromBulkUpload(fileData, bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(File fileData, BulkUploadJobData bulkUploadData) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData), bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(File fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryUserData bulkUploadCategoryUserData) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData), bulkUploadData, bulkUploadCategoryUserData);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData, BulkUploadCategoryUserData bulkUploadCategoryUserData) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, bulkUploadCategoryUserData);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData, BulkUploadCategoryUserData bulkUploadCategoryUserData) {
        return CategoryUserService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, bulkUploadCategoryUserData);
    }

    public static AddFromBulkUploadCategoryUserBuilder addFromBulkUpload(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryUserData bulkUploadCategoryUserData) {
        return new AddFromBulkUploadCategoryUserBuilder(fileData, bulkUploadData, bulkUploadCategoryUserData);
    }

    public static CopyFromCategoryCategoryUserBuilder copyFromCategory(int categoryId) {
        return new CopyFromCategoryCategoryUserBuilder(categoryId);
    }

    public static DeactivateCategoryUserBuilder deactivate(int categoryId, String userId) {
        return new DeactivateCategoryUserBuilder(categoryId, userId);
    }

    public static DeleteCategoryUserBuilder delete(int categoryId, String userId) {
        return new DeleteCategoryUserBuilder(categoryId, userId);
    }

    public static GetCategoryUserBuilder get(int categoryId, String userId) {
        return new GetCategoryUserBuilder(categoryId, userId);
    }

    public static IndexCategoryUserBuilder index(String userId, int categoryId) {
        return CategoryUserService.index(userId, categoryId, true);
    }

    public static IndexCategoryUserBuilder index(String userId, int categoryId, boolean shouldUpdate) {
        return new IndexCategoryUserBuilder(userId, categoryId, shouldUpdate);
    }

    public static ListCategoryUserBuilder list() {
        return CategoryUserService.list(null);
    }

    public static ListCategoryUserBuilder list(CategoryUserFilter filter) {
        return CategoryUserService.list(filter, null);
    }

    public static ListCategoryUserBuilder list(CategoryUserFilter filter, FilterPager pager) {
        return new ListCategoryUserBuilder(filter, pager);
    }

    public static UpdateCategoryUserBuilder update(int categoryId, String userId, CategoryUser categoryUser) {
        return CategoryUserService.update(categoryId, userId, categoryUser, false);
    }

    public static UpdateCategoryUserBuilder update(int categoryId, String userId, CategoryUser categoryUser, boolean override) {
        return new UpdateCategoryUserBuilder(categoryId, userId, categoryUser, override);
    }

    public static class UpdateCategoryUserBuilder
    extends RequestBuilder<CategoryUser, CategoryUser.Tokenizer, UpdateCategoryUserBuilder> {
        public UpdateCategoryUserBuilder(int categoryId, String userId, CategoryUser categoryUser, boolean override) {
            super(CategoryUser.class, "categoryuser", "update");
            this.params.add("categoryId", categoryId);
            this.params.add("userId", userId);
            this.params.add("categoryUser", categoryUser);
            this.params.add("override", override);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void override(String multirequestToken) {
            this.params.add("override", multirequestToken);
        }
    }

    public static class ListCategoryUserBuilder
    extends ListResponseRequestBuilder<CategoryUser, CategoryUser.Tokenizer, ListCategoryUserBuilder> {
        public ListCategoryUserBuilder(CategoryUserFilter filter, FilterPager pager) {
            super(CategoryUser.class, "categoryuser", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class IndexCategoryUserBuilder
    extends RequestBuilder<Integer, String, IndexCategoryUserBuilder> {
        public IndexCategoryUserBuilder(String userId, int categoryId, boolean shouldUpdate) {
            super(Integer.class, "categoryuser", "index");
            this.params.add("userId", userId);
            this.params.add("categoryId", categoryId);
            this.params.add("shouldUpdate", shouldUpdate);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }

        public void shouldUpdate(String multirequestToken) {
            this.params.add("shouldUpdate", multirequestToken);
        }
    }

    public static class GetCategoryUserBuilder
    extends RequestBuilder<CategoryUser, CategoryUser.Tokenizer, GetCategoryUserBuilder> {
        public GetCategoryUserBuilder(int categoryId, String userId) {
            super(CategoryUser.class, "categoryuser", "get");
            this.params.add("categoryId", categoryId);
            this.params.add("userId", userId);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }

    public static class DeleteCategoryUserBuilder
    extends NullRequestBuilder {
        public DeleteCategoryUserBuilder(int categoryId, String userId) {
            super("categoryuser", "delete");
            this.params.add("categoryId", categoryId);
            this.params.add("userId", userId);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }

    public static class DeactivateCategoryUserBuilder
    extends RequestBuilder<CategoryUser, CategoryUser.Tokenizer, DeactivateCategoryUserBuilder> {
        public DeactivateCategoryUserBuilder(int categoryId, String userId) {
            super(CategoryUser.class, "categoryuser", "deactivate");
            this.params.add("categoryId", categoryId);
            this.params.add("userId", userId);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }

    public static class CopyFromCategoryCategoryUserBuilder
    extends NullRequestBuilder {
        public CopyFromCategoryCategoryUserBuilder(int categoryId) {
            super("categoryuser", "copyFromCategory");
            this.params.add("categoryId", categoryId);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }
    }

    public static class AddFromBulkUploadCategoryUserBuilder
    extends RequestBuilder<BulkUpload, BulkUpload.Tokenizer, AddFromBulkUploadCategoryUserBuilder> {
        public AddFromBulkUploadCategoryUserBuilder(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryUserData bulkUploadCategoryUserData) {
            super(BulkUpload.class, "categoryuser", "addFromBulkUpload");
            this.files = new Files();
            this.files.add("fileData", fileData);
            this.params.add("bulkUploadData", bulkUploadData);
            this.params.add("bulkUploadCategoryUserData", bulkUploadCategoryUserData);
        }
    }

    public static class AddCategoryUserBuilder
    extends RequestBuilder<CategoryUser, CategoryUser.Tokenizer, AddCategoryUserBuilder> {
        public AddCategoryUserBuilder(CategoryUser categoryUser) {
            super(CategoryUser.class, "categoryuser", "add");
            this.params.add("categoryUser", categoryUser);
        }
    }

    public static class ActivateCategoryUserBuilder
    extends RequestBuilder<CategoryUser, CategoryUser.Tokenizer, ActivateCategoryUserBuilder> {
        public ActivateCategoryUserBuilder(int categoryId, String userId) {
            super(CategoryUser.class, "categoryuser", "activate");
            this.params.add("categoryId", categoryId);
            this.params.add("userId", userId);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }
    }
}

