/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.types.BulkUpload;
import com.kaltura.client.types.BulkUploadCategoryData;
import com.kaltura.client.types.BulkUploadJobData;
import com.kaltura.client.types.Category;
import com.kaltura.client.types.CategoryFilter;
import com.kaltura.client.types.CsvAdditionalFieldInfo;
import com.kaltura.client.types.ExportToCsvOptions;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

public class CategoryService {
    public static AddCategoryBuilder add(Category category) {
        return new AddCategoryBuilder(category);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(FileHolder fileData) {
        return CategoryService.addFromBulkUpload(fileData, null);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(File fileData) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData), null);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), null);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), null);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(FileHolder fileData, BulkUploadJobData bulkUploadData) {
        return CategoryService.addFromBulkUpload(fileData, bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(File fileData, BulkUploadJobData bulkUploadData) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData), bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, null);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(File fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryData bulkUploadCategoryData) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData), bulkUploadData, bulkUploadCategoryData);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(InputStream fileData, String fileDataMimeType, String fileDataName, long fileDataSize, BulkUploadJobData bulkUploadData, BulkUploadCategoryData bulkUploadCategoryData) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName, fileDataSize), bulkUploadData, bulkUploadCategoryData);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(FileInputStream fileData, String fileDataMimeType, String fileDataName, BulkUploadJobData bulkUploadData, BulkUploadCategoryData bulkUploadCategoryData) {
        return CategoryService.addFromBulkUpload(new FileHolder(fileData, fileDataMimeType, fileDataName), bulkUploadData, bulkUploadCategoryData);
    }

    public static AddFromBulkUploadCategoryBuilder addFromBulkUpload(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryData bulkUploadCategoryData) {
        return new AddFromBulkUploadCategoryBuilder(fileData, bulkUploadData, bulkUploadCategoryData);
    }

    public static CloneCategoryBuilder clone(int categoryId, int fromPartnerId) {
        return CategoryService.clone(categoryId, fromPartnerId, Integer.MIN_VALUE);
    }

    public static CloneCategoryBuilder clone(int categoryId, int fromPartnerId, int parentCategoryId) {
        return new CloneCategoryBuilder(categoryId, fromPartnerId, parentCategoryId);
    }

    public static DeleteCategoryBuilder delete(long id) {
        return CategoryService.delete(id, true);
    }

    public static DeleteCategoryBuilder delete(long id, Boolean moveEntriesToParentCategory) {
        return new DeleteCategoryBuilder(id, moveEntriesToParentCategory);
    }

    public static ExportToCsvCategoryBuilder exportToCsv() {
        return CategoryService.exportToCsv(null);
    }

    public static ExportToCsvCategoryBuilder exportToCsv(CategoryFilter filter) {
        return CategoryService.exportToCsv(filter, Integer.MIN_VALUE);
    }

    public static ExportToCsvCategoryBuilder exportToCsv(CategoryFilter filter, int metadataProfileId) {
        return CategoryService.exportToCsv(filter, metadataProfileId, null);
    }

    public static ExportToCsvCategoryBuilder exportToCsv(CategoryFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields) {
        return CategoryService.exportToCsv(filter, metadataProfileId, additionalFields, null);
    }

    public static ExportToCsvCategoryBuilder exportToCsv(CategoryFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields) {
        return CategoryService.exportToCsv(filter, metadataProfileId, additionalFields, mappedFields, null);
    }

    public static ExportToCsvCategoryBuilder exportToCsv(CategoryFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields, ExportToCsvOptions options) {
        return new ExportToCsvCategoryBuilder(filter, metadataProfileId, additionalFields, mappedFields, options);
    }

    public static GetCategoryBuilder get(long id) {
        return new GetCategoryBuilder(id);
    }

    public static IndexCategoryBuilder index(long id) {
        return CategoryService.index(id, true);
    }

    public static IndexCategoryBuilder index(long id, boolean shouldUpdate) {
        return new IndexCategoryBuilder(id, shouldUpdate);
    }

    public static ListCategoryBuilder list() {
        return CategoryService.list(null);
    }

    public static ListCategoryBuilder list(CategoryFilter filter) {
        return CategoryService.list(filter, null);
    }

    public static ListCategoryBuilder list(CategoryFilter filter, FilterPager pager) {
        return new ListCategoryBuilder(filter, pager);
    }

    public static MoveCategoryBuilder move(String categoryIds, int targetCategoryParentId) {
        return new MoveCategoryBuilder(categoryIds, targetCategoryParentId);
    }

    public static UnlockCategoriesCategoryBuilder unlockCategories() {
        return new UnlockCategoriesCategoryBuilder();
    }

    public static UpdateCategoryBuilder update(long id, Category category) {
        return new UpdateCategoryBuilder(id, category);
    }

    public static class UpdateCategoryBuilder
    extends RequestBuilder<Category, Category.Tokenizer, UpdateCategoryBuilder> {
        public UpdateCategoryBuilder(long id, Category category) {
            super(Category.class, "category", "update");
            this.params.add("id", id);
            this.params.add("category", category);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class UnlockCategoriesCategoryBuilder
    extends NullRequestBuilder {
        public UnlockCategoriesCategoryBuilder() {
            super("category", "unlockCategories");
        }
    }

    public static class MoveCategoryBuilder
    extends RequestBuilder<Boolean, String, MoveCategoryBuilder> {
        public MoveCategoryBuilder(String categoryIds, int targetCategoryParentId) {
            super(Boolean.class, "category", "move");
            this.params.add("categoryIds", categoryIds);
            this.params.add("targetCategoryParentId", targetCategoryParentId);
        }

        public void categoryIds(String multirequestToken) {
            this.params.add("categoryIds", multirequestToken);
        }

        public void targetCategoryParentId(String multirequestToken) {
            this.params.add("targetCategoryParentId", multirequestToken);
        }
    }

    public static class ListCategoryBuilder
    extends ListResponseRequestBuilder<Category, Category.Tokenizer, ListCategoryBuilder> {
        public ListCategoryBuilder(CategoryFilter filter, FilterPager pager) {
            super(Category.class, "category", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class IndexCategoryBuilder
    extends RequestBuilder<Integer, String, IndexCategoryBuilder> {
        public IndexCategoryBuilder(long id, boolean shouldUpdate) {
            super(Integer.class, "category", "index");
            this.params.add("id", id);
            this.params.add("shouldUpdate", shouldUpdate);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void shouldUpdate(String multirequestToken) {
            this.params.add("shouldUpdate", multirequestToken);
        }
    }

    public static class GetCategoryBuilder
    extends RequestBuilder<Category, Category.Tokenizer, GetCategoryBuilder> {
        public GetCategoryBuilder(long id) {
            super(Category.class, "category", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ExportToCsvCategoryBuilder
    extends RequestBuilder<String, String, ExportToCsvCategoryBuilder> {
        public ExportToCsvCategoryBuilder(CategoryFilter filter, int metadataProfileId, List<CsvAdditionalFieldInfo> additionalFields, List<KeyValue> mappedFields, ExportToCsvOptions options) {
            super(String.class, "category", "exportToCsv");
            this.params.add("filter", filter);
            this.params.add("metadataProfileId", metadataProfileId);
            this.params.add("additionalFields", additionalFields);
            this.params.add("mappedFields", mappedFields);
            this.params.add("options", options);
        }

        public void metadataProfileId(String multirequestToken) {
            this.params.add("metadataProfileId", multirequestToken);
        }
    }

    public static class DeleteCategoryBuilder
    extends NullRequestBuilder {
        public DeleteCategoryBuilder(long id, Boolean moveEntriesToParentCategory) {
            super("category", "delete");
            this.params.add("id", id);
            this.params.add("moveEntriesToParentCategory", moveEntriesToParentCategory);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void moveEntriesToParentCategory(String multirequestToken) {
            this.params.add("moveEntriesToParentCategory", multirequestToken);
        }
    }

    public static class CloneCategoryBuilder
    extends RequestBuilder<Category, Category.Tokenizer, CloneCategoryBuilder> {
        public CloneCategoryBuilder(int categoryId, int fromPartnerId, int parentCategoryId) {
            super(Category.class, "category", "clone");
            this.params.add("categoryId", categoryId);
            this.params.add("fromPartnerId", fromPartnerId);
            this.params.add("parentCategoryId", parentCategoryId);
        }

        public void categoryId(String multirequestToken) {
            this.params.add("categoryId", multirequestToken);
        }

        public void fromPartnerId(String multirequestToken) {
            this.params.add("fromPartnerId", multirequestToken);
        }

        public void parentCategoryId(String multirequestToken) {
            this.params.add("parentCategoryId", multirequestToken);
        }
    }

    public static class AddFromBulkUploadCategoryBuilder
    extends RequestBuilder<BulkUpload, BulkUpload.Tokenizer, AddFromBulkUploadCategoryBuilder> {
        public AddFromBulkUploadCategoryBuilder(FileHolder fileData, BulkUploadJobData bulkUploadData, BulkUploadCategoryData bulkUploadCategoryData) {
            super(BulkUpload.class, "category", "addFromBulkUpload");
            this.files = new Files();
            this.files.add("fileData", fileData);
            this.params.add("bulkUploadData", bulkUploadData);
            this.params.add("bulkUploadCategoryData", bulkUploadCategoryData);
        }
    }

    public static class AddCategoryBuilder
    extends RequestBuilder<Category, Category.Tokenizer, AddCategoryBuilder> {
        public AddCategoryBuilder(Category category) {
            super(Category.class, "category", "add");
            this.params.add("category", category);
        }
    }
}

