/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.enums.SessionType;
import com.kaltura.client.types.AppToken;
import com.kaltura.client.types.AppTokenFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.types.SessionInfo;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class AppTokenService {
    public static AddAppTokenBuilder add(AppToken appToken) {
        return new AddAppTokenBuilder(appToken);
    }

    public static DeleteAppTokenBuilder delete(String id) {
        return new DeleteAppTokenBuilder(id);
    }

    public static GetAppTokenBuilder get(String id) {
        return new GetAppTokenBuilder(id);
    }

    public static ListAppTokenBuilder list() {
        return AppTokenService.list(null);
    }

    public static ListAppTokenBuilder list(AppTokenFilter filter) {
        return AppTokenService.list(filter, null);
    }

    public static ListAppTokenBuilder list(AppTokenFilter filter, FilterPager pager) {
        return new ListAppTokenBuilder(filter, pager);
    }

    public static StartSessionAppTokenBuilder startSession(String id, String tokenHash) {
        return AppTokenService.startSession(id, tokenHash, null);
    }

    public static StartSessionAppTokenBuilder startSession(String id, String tokenHash, String userId) {
        return AppTokenService.startSession(id, tokenHash, userId, SessionType.get(Integer.MIN_VALUE));
    }

    public static StartSessionAppTokenBuilder startSession(String id, String tokenHash, String userId, SessionType type) {
        return AppTokenService.startSession(id, tokenHash, userId, type, Integer.MIN_VALUE);
    }

    public static StartSessionAppTokenBuilder startSession(String id, String tokenHash, String userId, SessionType type, int expiry) {
        return AppTokenService.startSession(id, tokenHash, userId, type, expiry, null);
    }

    public static StartSessionAppTokenBuilder startSession(String id, String tokenHash, String userId, SessionType type, int expiry, String sessionPrivileges) {
        return new StartSessionAppTokenBuilder(id, tokenHash, userId, type, expiry, sessionPrivileges);
    }

    public static UpdateAppTokenBuilder update(String id, AppToken appToken) {
        return new UpdateAppTokenBuilder(id, appToken);
    }

    public static class UpdateAppTokenBuilder
    extends RequestBuilder<AppToken, AppToken.Tokenizer, UpdateAppTokenBuilder> {
        public UpdateAppTokenBuilder(String id, AppToken appToken) {
            super(AppToken.class, "apptoken", "update");
            this.params.add("id", id);
            this.params.add("appToken", appToken);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class StartSessionAppTokenBuilder
    extends RequestBuilder<SessionInfo, SessionInfo.Tokenizer, StartSessionAppTokenBuilder> {
        public StartSessionAppTokenBuilder(String id, String tokenHash, String userId, SessionType type, int expiry, String sessionPrivileges) {
            super(SessionInfo.class, "apptoken", "startSession");
            this.params.add("id", id);
            this.params.add("tokenHash", tokenHash);
            this.params.add("userId", userId);
            this.params.add("type", type);
            this.params.add("expiry", expiry);
            this.params.add("sessionPrivileges", sessionPrivileges);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }

        public void tokenHash(String multirequestToken) {
            this.params.add("tokenHash", multirequestToken);
        }

        public void userId(String multirequestToken) {
            this.params.add("userId", multirequestToken);
        }

        public void type(String multirequestToken) {
            this.params.add("type", multirequestToken);
        }

        public void expiry(String multirequestToken) {
            this.params.add("expiry", multirequestToken);
        }

        public void sessionPrivileges(String multirequestToken) {
            this.params.add("sessionPrivileges", multirequestToken);
        }
    }

    public static class ListAppTokenBuilder
    extends ListResponseRequestBuilder<AppToken, AppToken.Tokenizer, ListAppTokenBuilder> {
        public ListAppTokenBuilder(AppTokenFilter filter, FilterPager pager) {
            super(AppToken.class, "apptoken", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetAppTokenBuilder
    extends RequestBuilder<AppToken, AppToken.Tokenizer, GetAppTokenBuilder> {
        public GetAppTokenBuilder(String id) {
            super(AppToken.class, "apptoken", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class DeleteAppTokenBuilder
    extends NullRequestBuilder {
        public DeleteAppTokenBuilder(String id) {
            super("apptoken", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class AddAppTokenBuilder
    extends RequestBuilder<AppToken, AppToken.Tokenizer, AddAppTokenBuilder> {
        public AddAppTokenBuilder(AppToken appToken) {
            super(AppToken.class, "apptoken", "add");
            this.params.add("appToken", appToken);
        }
    }
}

