/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.services;

import com.kaltura.client.types.AccessControl;
import com.kaltura.client.types.AccessControlFilter;
import com.kaltura.client.types.FilterPager;
import com.kaltura.client.utils.request.ListResponseRequestBuilder;
import com.kaltura.client.utils.request.NullRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;

public class AccessControlService {
    public static AddAccessControlBuilder add(AccessControl accessControl) {
        return new AddAccessControlBuilder(accessControl);
    }

    public static DeleteAccessControlBuilder delete(long id) {
        return new DeleteAccessControlBuilder(id);
    }

    public static GetAccessControlBuilder get(long id) {
        return new GetAccessControlBuilder(id);
    }

    public static ListAccessControlBuilder list() {
        return AccessControlService.list(null);
    }

    public static ListAccessControlBuilder list(AccessControlFilter filter) {
        return AccessControlService.list(filter, null);
    }

    public static ListAccessControlBuilder list(AccessControlFilter filter, FilterPager pager) {
        return new ListAccessControlBuilder(filter, pager);
    }

    public static UpdateAccessControlBuilder update(long id, AccessControl accessControl) {
        return new UpdateAccessControlBuilder(id, accessControl);
    }

    public static class UpdateAccessControlBuilder
    extends RequestBuilder<AccessControl, AccessControl.Tokenizer, UpdateAccessControlBuilder> {
        public UpdateAccessControlBuilder(long id, AccessControl accessControl) {
            super(AccessControl.class, "accesscontrol", "update");
            this.params.add("id", id);
            this.params.add("accessControl", accessControl);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class ListAccessControlBuilder
    extends ListResponseRequestBuilder<AccessControl, AccessControl.Tokenizer, ListAccessControlBuilder> {
        public ListAccessControlBuilder(AccessControlFilter filter, FilterPager pager) {
            super(AccessControl.class, "accesscontrol", "list");
            this.params.add("filter", filter);
            this.params.add("pager", pager);
        }
    }

    public static class GetAccessControlBuilder
    extends RequestBuilder<AccessControl, AccessControl.Tokenizer, GetAccessControlBuilder> {
        public GetAccessControlBuilder(long id) {
            super(AccessControl.class, "accesscontrol", "get");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class DeleteAccessControlBuilder
    extends NullRequestBuilder {
        public DeleteAccessControlBuilder(long id) {
            super("accesscontrol", "delete");
            this.params.add("id", id);
        }

        public void id(String multirequestToken) {
            this.params.add("id", multirequestToken);
        }
    }

    public static class AddAccessControlBuilder
    extends RequestBuilder<AccessControl, AccessControl.Tokenizer, AddAccessControlBuilder> {
        public AddAccessControlBuilder(AccessControl accessControl) {
            super(AccessControl.class, "accesscontrol", "add");
            this.params.add("accessControl", accessControl);
        }
    }
}

