/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client;

import com.kaltura.client.types.APIException;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectFactory {
    public static <T> T create(Element xmlElement, Class<T> fallbackClazz) throws APIException {
        NodeList objectTypeNodes = xmlElement.getElementsByTagName("objectType");
        Node objectTypeNode = objectTypeNodes.item(0);
        Class<Object> clazz = null;
        if (objectTypeNode != null) {
            String objectType = objectTypeNode.getTextContent();
            try {
                clazz = Class.forName("com.kaltura.client.types." + objectType);
            }
            catch (ClassNotFoundException e1) {
                clazz = null;
            }
        }
        if (clazz == null) {
            if (fallbackClazz != null) {
                clazz = fallbackClazz;
            } else {
                throw new APIException("Invalid object type");
            }
        }
        try {
            Constructor<T> ctor = clazz.getConstructor(Element.class);
            return ctor.newInstance(xmlElement);
        }
        catch (Exception e) {
            throw new APIException("Failed to construct object");
        }
    }
}

