/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client;

import com.kaltura.client.utils.request.ConnectionConfiguration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Configuration
implements Serializable,
ConnectionConfiguration {
    private static final long serialVersionUID = 2096581946429839651L;
    public static final String EndPoint = "endpoint";
    public static final String Proxy = null;
    public static final String ProxyPort = "0";
    public static final String ConnectTimeout = "connectTimeout";
    public static final String ReadTimeout = "readTimeout";
    public static final String WriteTimeout = "writeTimeout";
    public static final String MaxRetry = "maxRetry";
    public static final String AcceptGzipEncoding = "acceptGzipEncoding";
    public static final String ResponseTypeFormat = "responseTypeFormat";
    public static final String IgnoreSslDomainVerification = "ignoreSslDomainVerification";
    private Map<String, Object> params;

    public static ConnectionConfiguration getDefaults() {
        return new Configuration();
    }

    public Configuration() {
        this.initDefaults();
    }

    public Configuration(Map<String, Object> config) {
        this.initDefaults();
        this.params.putAll(config);
    }

    public Configuration(ConnectionConfiguration config) {
        this.params = new HashMap<String, Object>();
        this.params.put(ConnectTimeout, config.getConnectTimeout());
        this.params.put(ReadTimeout, config.getReadTimeout());
        this.params.put(WriteTimeout, config.getWriteTimeout());
        this.params.put(MaxRetry, config.getMaxRetry(2));
        this.params.put(AcceptGzipEncoding, config.getAcceptGzipEncoding());
        this.params.put(IgnoreSslDomainVerification, config.getIgnoreSslDomainVerification());
        this.params.put(EndPoint, config.getEndpoint());
    }

    private void initDefaults() {
        this.params = new HashMap<String, Object>();
        this.params.put(ConnectTimeout, 20000);
        this.params.put(ReadTimeout, 20000);
        this.params.put(WriteTimeout, 30000);
        this.params.put(MaxRetry, 3);
        this.params.put(AcceptGzipEncoding, false);
        this.params.put(IgnoreSslDomainVerification, false);
        this.params.put(EndPoint, "http://www.kaltura.com/");
    }

    @Override
    public String getEndpoint() {
        return (String)this.params.get(EndPoint);
    }

    @Override
    public String getProxy() {
        return (String)this.params.get(Proxy);
    }

    @Override
    public int getProxyPort() {
        return (Integer)this.params.get(ProxyPort);
    }

    @Override
    public boolean getIgnoreSslDomainVerification() {
        return (Boolean)this.params.get(IgnoreSslDomainVerification);
    }

    public void setEndpoint(String endpoint) {
        this.params.put(EndPoint, endpoint);
    }

    public void setProxy(String proxy) {
        this.params.put(Proxy, proxy);
        System.setProperty("http_proxy", proxy);
    }

    public void setProxyPort(int proxyPort) {
        this.params.put(ProxyPort, proxyPort);
        System.setProperty("http_proxy_port", String.valueOf(proxyPort));
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setParam(String key, Object value) {
        this.params.put(key, value);
    }

    public Object getParam(String key) {
        return this.params.get(key);
    }

    public Object getParam(String key, Object defaultValue) {
        return this.params.containsKey(key) ? this.params.get(key) : defaultValue;
    }

    @Override
    public int getConnectTimeout() {
        return (Integer)this.params.get(ConnectTimeout);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.params.put(ConnectTimeout, connectTimeout);
    }

    @Override
    public int getReadTimeout() {
        return (Integer)this.params.get(ReadTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.params.put(ReadTimeout, readTimeout);
    }

    @Override
    public int getWriteTimeout() {
        return (Integer)this.params.get(WriteTimeout);
    }

    public void setWriteTimeout(int writeTimeout) {
        this.params.put(WriteTimeout, writeTimeout);
    }

    @Override
    public boolean getAcceptGzipEncoding() {
        return (Boolean)this.params.get(AcceptGzipEncoding);
    }

    public void setAcceptGzipEncoding(boolean accept) {
        this.params.put(AcceptGzipEncoding, accept);
    }

    public void setIgnoreSslDomainVerification(boolean ignore) {
        this.params.put(IgnoreSslDomainVerification, ignore);
    }

    public void setMaxRetry(int retry) {
        this.params.put(MaxRetry, retry);
    }

    @Override
    public int getMaxRetry(int defaultVal) {
        return this.params.containsKey(MaxRetry) ? (Integer)this.params.get(MaxRetry) : defaultVal;
    }
}

