/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client;

import com.kaltura.client.ClientConfigBase;
import com.kaltura.client.ILogger;
import com.kaltura.client.Logger;
import com.kaltura.client.Params;
import com.kaltura.client.enums.SessionType;
import com.kaltura.client.utils.EncryptionUtils;
import com.kaltura.client.utils.request.ConnectionConfiguration;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class ClientBase
extends ClientConfigBase {
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String FIELD_EXPIRY = "_e";
    private static final String FIELD_USER = "_u";
    private static final String FIELD_TYPE = "_t";
    private static final int RANDOM_SIZE = 16;
    public static final int EXPIRY = 86400;
    private static ILogger logger = Logger.getLogger(ClientBase.class);

    public ClientBase(ConnectionConfiguration configuration) {
        super(configuration);
    }

    public String generateSession(String adminSecretForSigning, String userId, SessionType type, int partnerId) throws Exception {
        return this.generateSession(adminSecretForSigning, userId, type, partnerId, 86400);
    }

    public String generateSession(String adminSecretForSigning, String userId, SessionType type, int partnerId, int expiry) throws Exception {
        return this.generateSession(adminSecretForSigning, userId, type, partnerId, expiry, "");
    }

    public String generateSession(String adminSecretForSigning, String userId, SessionType type, int partnerId, int expiry, String privileges) throws Exception {
        try {
            int rand = (int)(Math.random() * 32000.0);
            expiry += (int)(System.currentTimeMillis() / 1000L);
            StringBuilder sbInfo = new StringBuilder();
            sbInfo.append(partnerId).append(";");
            sbInfo.append(partnerId).append(";");
            sbInfo.append(expiry).append(";");
            sbInfo.append(type.getValue()).append(";");
            sbInfo.append(rand).append(";");
            sbInfo.append(userId).append(";");
            sbInfo.append(privileges);
            byte[] infoSignature = EncryptionUtils.encryptSHA1(adminSecretForSigning + sbInfo.toString());
            String signature = ClientBase.convertToHex(infoSignature);
            StringBuilder sbToEncode = new StringBuilder();
            sbToEncode.append(signature.toString()).append("|").append(sbInfo.toString());
            String hashedString = new String(Base64.encodeBase64((byte[])sbToEncode.toString().getBytes()));
            String ks = hashedString.replace("\n", "");
            ks = hashedString.replace("\r", "");
            return ks;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Exception(ex);
        }
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public String generateSessionV2(String adminSecretForSigning, String userId, SessionType type, int partnerId, int expiry, String privileges) throws Exception {
        try {
            String[] privilegesArr;
            Params fields = new Params();
            for (String curPriv : privilegesArr = privileges.split(",")) {
                String[] splittedPriv;
                String privilege = curPriv.trim();
                if (privilege.length() == 0) continue;
                if (privilege.equals("*")) {
                    privilege = "all:*";
                }
                if ((splittedPriv = privilege.split(":")).length > 1) {
                    fields.add(splittedPriv[0], URLEncoder.encode(splittedPriv[1], UTF8_CHARSET));
                    continue;
                }
                fields.add(splittedPriv[0], "");
            }
            Integer expiryInt = (int)(System.currentTimeMillis() / 1000L) + expiry;
            String expStr = expiryInt.toString();
            fields.add(FIELD_EXPIRY, expStr);
            fields.add(FIELD_TYPE, Integer.toString(type.getValue()));
            fields.add(FIELD_USER, userId);
            byte[] randomBytes = this.createRandomByteArray(16);
            byte[] fieldsByteArray = fields.toQueryString().getBytes();
            int totalLength = randomBytes.length + fieldsByteArray.length;
            byte[] fieldsAndRandomBytes = new byte[totalLength];
            System.arraycopy(randomBytes, 0, fieldsAndRandomBytes, 0, randomBytes.length);
            System.arraycopy(fieldsByteArray, 0, fieldsAndRandomBytes, randomBytes.length, fieldsByteArray.length);
            byte[] infoSignature = EncryptionUtils.encryptSHA1(fieldsAndRandomBytes);
            byte[] input = new byte[infoSignature.length + fieldsAndRandomBytes.length];
            System.arraycopy(infoSignature, 0, input, 0, infoSignature.length);
            System.arraycopy(fieldsAndRandomBytes, 0, input, infoSignature.length, fieldsAndRandomBytes.length);
            byte[] encryptedFields = EncryptionUtils.encryptAES(adminSecretForSigning, input);
            String prefix = "v2|" + partnerId + "|";
            byte[] output = new byte[encryptedFields.length + prefix.length()];
            System.arraycopy(prefix.getBytes(), 0, output, 0, prefix.length());
            System.arraycopy(encryptedFields, 0, output, prefix.length(), encryptedFields.length);
            String encodedKs = new String(Base64.encodeBase64((byte[])output));
            encodedKs = encodedKs.replaceAll("\\+", "-");
            encodedKs = encodedKs.replaceAll("/", "_");
            encodedKs = encodedKs.replace("\n", "");
            encodedKs = encodedKs.replace("\r", "");
            return encodedKs;
        }
        catch (GeneralSecurityException ex) {
            logger.error("Failed to generate v2 session.");
            throw new Exception(ex);
        }
    }

    private byte[] createRandomByteArray(int size) {
        byte[] b = new byte[size];
        new Random().nextBytes(b);
        return b;
    }
}

