/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.HttpMethod;
import com.jsunsoft.http.Response;
import com.jsunsoft.http.ResponseHandler;
import com.jsunsoft.http.TypeReference;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.Args;

public interface WebTarget {
    public WebTarget path(String var1);

    public WebTarget setPath(String var1);

    public Response request(HttpMethod var1);

    public Response request(HttpMethod var1, HttpEntity var2);

    public <T> ResponseHandler<T> request(HttpMethod var1, HttpEntity var2, Class<T> var3);

    public <T> ResponseHandler<T> request(HttpMethod var1, HttpEntity var2, TypeReference<T> var3);

    public <T> ResponseHandler<T> request(HttpMethod var1, Class<T> var2);

    public <T> ResponseHandler<T> request(HttpMethod var1, TypeReference<T> var2);

    default public ResponseHandler<?> rawRequest(HttpMethod method) {
        return this.request(method, Void.class);
    }

    default public ResponseHandler<?> rawRequest(HttpMethod method, HttpEntity httpEntity) {
        return this.request(method, httpEntity, Void.class);
    }

    default public ResponseHandler<?> rawRequest(HttpMethod method, String payload) {
        return this.request(method, payload, Void.class);
    }

    public WebTarget removeHeader(Header var1);

    public WebTarget removeHeaders(String var1);

    public WebTarget updateHeader(Header var1);

    public WebTarget addHeader(Header var1);

    default public <T> ResponseHandler<T> request(HttpMethod method, String payload, Class<T> responseType) {
        ArgsCheck.notNull(method, "method");
        ArgsCheck.notNull(payload, "payload");
        ArgsCheck.notNull(payload, "responseType");
        return this.request(method, (HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8), responseType);
    }

    default public <T> ResponseHandler<T> request(HttpMethod method, String payload, TypeReference<T> responseType) {
        ArgsCheck.notNull(method, "method");
        ArgsCheck.notNull(payload, "payload");
        ArgsCheck.notNull(payload, "responseType");
        return this.request(method, (HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8), responseType);
    }

    default public Response request(HttpMethod method, String payload) {
        ArgsCheck.notNull(method, "method");
        ArgsCheck.notNull(payload, "payload");
        return this.request(method, (HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8));
    }

    default public WebTarget addHeader(String name, String value) {
        ArgsCheck.notNull(name, "name");
        this.addHeader((Header)new BasicHeader(name, value));
        return this;
    }

    default public WebTarget addHeaders(Collection<? extends Header> headers) {
        ArgsCheck.notNull(headers, "headers");
        headers.forEach(this::addHeader);
        return this;
    }

    default public WebTarget updateHeader(String name, String value) {
        ArgsCheck.notNull(name, "name");
        this.updateHeader((Header)new BasicHeader(name, value));
        return this;
    }

    default public WebTarget addContentType(ContentType contentType) {
        this.addHeader("Content-Type", contentType.toString());
        return this;
    }

    public WebTarget setRequestConfig(RequestConfig var1);

    public WebTarget addParameter(NameValuePair var1);

    public String getURIString();

    public URI getURI();

    default public WebTarget addParameters(NameValuePair ... parameters) {
        ArgsCheck.notNull(parameters, "parameters");
        Arrays.stream(parameters).forEach(this::addParameter);
        return this;
    }

    default public WebTarget addParameters(String queryString, Charset charset) {
        ArgsCheck.notNull(queryString, "queryString");
        ArgsCheck.notNull(charset, "charset");
        return this.addParameters(URLEncodedUtils.parse((String)queryString, (Charset)charset));
    }

    default public WebTarget addParameters(String queryString) {
        return this.addParameters(queryString, StandardCharsets.UTF_8);
    }

    default public WebTarget addParameters(String ... nameValues) {
        int nameValuesLength = ArgsCheck.notNull(nameValues, "nameValues").length;
        Args.check((nameValuesLength != 0 ? 1 : 0) != 0, (String)"Length of parameter can't be ZERO");
        Args.check((nameValuesLength % 2 == 0 ? 1 : 0) != 0, (String)"Length of nameValues can't be odd");
        int end = nameValuesLength - 2;
        for (int i = 0; i <= end; i += 2) {
            this.addParameter((NameValuePair)new BasicNameValuePair(nameValues[i], nameValues[i + 1]));
        }
        return this;
    }

    default public WebTarget addParameters(Collection<? extends NameValuePair> parameters) {
        ArgsCheck.notNull(parameters, "parameters");
        parameters.forEach(this::addParameter);
        return this;
    }

    default public WebTarget addParameters(Map<String, String> parameters) {
        ArgsCheck.notNull(parameters, "parameters");
        parameters.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).forEach(this::addParameter);
        return this;
    }

    default public WebTarget addParameter(String name, String value) {
        ArgsCheck.notNull(name, "name");
        return this.addParameter((NameValuePair)new BasicNameValuePair(name, value));
    }

    default public Response get() {
        return this.request(HttpMethod.GET);
    }

    default public ResponseHandler<?> rawGet() {
        return this.rawRequest(HttpMethod.GET);
    }

    default public ResponseHandler<?> rawGet(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.GET, httpEntity);
    }

    default public ResponseHandler<?> rawGet(String payload) {
        return this.rawRequest(HttpMethod.GET, payload);
    }

    default public Response get(HttpEntity httpEntity) {
        return this.request(HttpMethod.GET, httpEntity);
    }

    default public <T> ResponseHandler<T> get(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.GET, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> get(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.GET, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> get(String payload, Class<T> responseType) {
        return this.request(HttpMethod.GET, payload, responseType);
    }

    default public <T> ResponseHandler<T> get(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.GET, payload, responseType);
    }

    default public <T> ResponseHandler<T> get(Class<T> responseType) {
        return this.request(HttpMethod.GET, responseType);
    }

    default public <T> ResponseHandler<T> get(TypeReference<T> responseType) {
        return this.request(HttpMethod.GET, responseType);
    }

    default public Response get(String payload) {
        return this.request(HttpMethod.GET, payload);
    }

    default public Response put() {
        return this.request(HttpMethod.PUT);
    }

    default public ResponseHandler<?> rawPut() {
        return this.rawRequest(HttpMethod.PUT);
    }

    default public ResponseHandler<?> rawPut(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.PUT, httpEntity);
    }

    default public ResponseHandler<?> rawPut(String payload) {
        return this.rawRequest(HttpMethod.PUT, payload);
    }

    default public Response put(HttpEntity httpEntity) {
        return this.request(HttpMethod.PUT, httpEntity);
    }

    default public <T> ResponseHandler<T> put(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.PUT, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> put(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.PUT, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> put(String payload, Class<T> responseType) {
        return this.request(HttpMethod.PUT, payload, responseType);
    }

    default public <T> ResponseHandler<T> put(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.PUT, payload, responseType);
    }

    default public Response put(String payload) {
        return this.request(HttpMethod.PUT, payload);
    }

    default public <T> ResponseHandler<T> put(Class<T> responseType) {
        return this.request(HttpMethod.PUT, responseType);
    }

    default public <T> ResponseHandler<T> put(TypeReference<T> responseType) {
        return this.request(HttpMethod.PUT, responseType);
    }

    default public Response post() {
        return this.request(HttpMethod.POST);
    }

    default public ResponseHandler<?> rawPost() {
        return this.rawRequest(HttpMethod.POST);
    }

    default public ResponseHandler<?> rawPost(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.POST, httpEntity);
    }

    default public ResponseHandler<?> rawPost(String payload) {
        return this.rawRequest(HttpMethod.POST, payload);
    }

    default public Response post(HttpEntity httpEntity) {
        return this.request(HttpMethod.POST, httpEntity);
    }

    default public <T> ResponseHandler<T> post(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.POST, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> post(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.POST, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> post(String payload, Class<T> responseType) {
        return this.request(HttpMethod.POST, payload, responseType);
    }

    default public <T> ResponseHandler<T> post(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.POST, payload, responseType);
    }

    default public Response post(String payload) {
        return this.request(HttpMethod.POST, payload);
    }

    default public <T> ResponseHandler<T> post(Class<T> responseType) {
        return this.request(HttpMethod.POST, responseType);
    }

    default public <T> ResponseHandler<T> post(TypeReference<T> responseType) {
        return this.request(HttpMethod.POST, responseType);
    }

    default public Response head() {
        return this.request(HttpMethod.HEAD);
    }

    default public ResponseHandler<?> rawHead() {
        return this.rawRequest(HttpMethod.HEAD);
    }

    default public ResponseHandler<?> rawHead(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.HEAD, httpEntity);
    }

    default public ResponseHandler<?> rawHead(String payload) {
        return this.rawRequest(HttpMethod.HEAD, payload);
    }

    default public Response head(HttpEntity httpEntity) {
        return this.request(HttpMethod.HEAD, httpEntity);
    }

    default public <T> ResponseHandler<T> head(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.HEAD, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> head(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.HEAD, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> head(String payload, Class<T> responseType) {
        return this.request(HttpMethod.HEAD, payload, responseType);
    }

    default public <T> ResponseHandler<T> head(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.HEAD, payload, responseType);
    }

    default public Response head(String payload) {
        return this.request(HttpMethod.HEAD, payload);
    }

    default public <T> ResponseHandler<T> head(Class<T> responseType) {
        return this.request(HttpMethod.HEAD, responseType);
    }

    default public <T> ResponseHandler<T> head(TypeReference<T> responseType) {
        return this.request(HttpMethod.HEAD, responseType);
    }

    default public Response delete() {
        return this.request(HttpMethod.DELETE);
    }

    default public ResponseHandler<?> rawDelete() {
        return this.rawRequest(HttpMethod.DELETE);
    }

    default public ResponseHandler<?> rawDelete(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.DELETE, httpEntity);
    }

    default public ResponseHandler<?> rawDelete(String payload) {
        return this.rawRequest(HttpMethod.DELETE, payload);
    }

    default public Response delete(HttpEntity httpEntity) {
        return this.request(HttpMethod.DELETE, httpEntity);
    }

    default public <T> ResponseHandler<T> delete(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.DELETE, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> delete(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.DELETE, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> delete(String payload, Class<T> responseType) {
        return this.request(HttpMethod.DELETE, payload, responseType);
    }

    default public <T> ResponseHandler<T> delete(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.DELETE, payload, responseType);
    }

    default public Response delete(String payload) {
        return this.request(HttpMethod.DELETE, payload);
    }

    default public <T> ResponseHandler<T> delete(Class<T> responseType) {
        return this.request(HttpMethod.DELETE, responseType);
    }

    default public <T> ResponseHandler<T> delete(TypeReference<T> responseType) {
        return this.request(HttpMethod.DELETE, responseType);
    }

    default public Response options() {
        return this.request(HttpMethod.OPTIONS);
    }

    default public ResponseHandler<?> rawOptions() {
        return this.rawRequest(HttpMethod.OPTIONS);
    }

    default public ResponseHandler<?> rawOptions(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.OPTIONS, httpEntity);
    }

    default public ResponseHandler<?> rawOptions(String payload) {
        return this.rawRequest(HttpMethod.OPTIONS, payload);
    }

    default public Response options(HttpEntity httpEntity) {
        return this.request(HttpMethod.OPTIONS, httpEntity);
    }

    default public <T> ResponseHandler<T> options(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.OPTIONS, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> options(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.OPTIONS, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> options(String payload, Class<T> responseType) {
        return this.request(HttpMethod.OPTIONS, payload, responseType);
    }

    default public <T> ResponseHandler<T> options(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.OPTIONS, payload, responseType);
    }

    default public Response options(String payload) {
        return this.request(HttpMethod.OPTIONS, payload);
    }

    default public <T> ResponseHandler<T> options(Class<T> responseType) {
        return this.request(HttpMethod.OPTIONS, responseType);
    }

    default public <T> ResponseHandler<T> options(TypeReference<T> responseType) {
        return this.request(HttpMethod.OPTIONS, responseType);
    }

    default public Response patch() {
        return this.request(HttpMethod.PATCH);
    }

    default public ResponseHandler<?> rawPatch() {
        return this.rawRequest(HttpMethod.PATCH);
    }

    default public ResponseHandler<?> rawPatch(HttpEntity httpEntity) {
        return this.rawRequest(HttpMethod.PATCH, httpEntity);
    }

    default public ResponseHandler<?> rawPatch(String payload) {
        return this.rawRequest(HttpMethod.PATCH, payload);
    }

    default public Response patch(HttpEntity httpEntity) {
        return this.request(HttpMethod.PATCH, httpEntity);
    }

    default public <T> ResponseHandler<T> patch(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.PATCH, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> patch(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.PATCH, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> patch(String payload, Class<T> responseType) {
        return this.request(HttpMethod.PATCH, payload, responseType);
    }

    default public <T> ResponseHandler<T> patch(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.PATCH, payload, responseType);
    }

    default public Response patch(String payload) {
        return this.request(HttpMethod.PATCH, payload);
    }

    default public <T> ResponseHandler<T> patch(Class<T> responseType) {
        return this.request(HttpMethod.PATCH, responseType);
    }

    default public <T> ResponseHandler<T> patch(TypeReference<T> responseType) {
        return this.request(HttpMethod.PATCH, responseType);
    }

    default public Response trace() {
        return this.request(HttpMethod.TRACE);
    }

    default public ResponseHandler<?> rawTrace() {
        return this.rawRequest(HttpMethod.TRACE);
    }

    default public Response trace(HttpEntity httpEntity) {
        return this.request(HttpMethod.TRACE, httpEntity);
    }

    default public <T> ResponseHandler<T> trace(HttpEntity httpEntity, Class<T> responseType) {
        return this.request(HttpMethod.TRACE, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> trace(HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.request(HttpMethod.TRACE, httpEntity, responseType);
    }

    default public <T> ResponseHandler<T> trace(String payload, Class<T> responseType) {
        return this.request(HttpMethod.TRACE, payload, responseType);
    }

    default public <T> ResponseHandler<T> trace(String payload, TypeReference<T> responseType) {
        return this.request(HttpMethod.TRACE, payload, responseType);
    }

    default public Response trace(String payload) {
        return this.request(HttpMethod.TRACE, payload);
    }

    default public <T> ResponseHandler<T> trace(Class<T> responseType) {
        return this.request(HttpMethod.TRACE, responseType);
    }

    default public <T> ResponseHandler<T> trace(TypeReference<T> responseType) {
        return this.request(HttpMethod.TRACE, responseType);
    }
}

