/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.BasicHttpRequest;
import com.jsunsoft.http.HttpRequest;
import com.jsunsoft.http.ResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReaderConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.Args;

public class HttpRequestBuilder {
    private final CloseableHttpClient closeableHttpClient;
    private List<NameValuePair> defaultRequestParameters;
    private Collection<Header> defaultHeaders;
    private ResponseBodyReaderConfig.Builder responseBodyReaderConfigBuilder = ResponseBodyReaderConfig.create();

    private HttpRequestBuilder(CloseableHttpClient closeableHttpClient) {
        this.closeableHttpClient = ArgsCheck.notNull(closeableHttpClient, "closeableHttpClient");
    }

    public static HttpRequestBuilder create(CloseableHttpClient closeableHttpClient) {
        return new HttpRequestBuilder(closeableHttpClient);
    }

    public HttpRequestBuilder addDefaultHeader(String name, String value) {
        ArgsCheck.notNull(name, "name");
        return this.addDefaultHeader((Header)new BasicHeader(name, value));
    }

    public HttpRequestBuilder addDefaultHeader(Header header) {
        ArgsCheck.notNull(header, "header");
        if (this.defaultHeaders == null) {
            this.defaultHeaders = new ArrayList<Header>();
        }
        this.defaultHeaders.add(header);
        return this;
    }

    public HttpRequestBuilder addDefaultHeaders(Header ... headers) {
        ArgsCheck.notNull(headers, "headers");
        Arrays.stream(headers).forEach(this::addDefaultHeader);
        return this;
    }

    public HttpRequestBuilder addDefaultHeaders(Collection<? extends Header> headers) {
        ArgsCheck.notNull(headers, "headers");
        headers.forEach(this::addDefaultHeader);
        return this;
    }

    public HttpRequestBuilder addContentType(ContentType contentType) {
        return this.addDefaultHeader("Content-Type", contentType.toString());
    }

    public HttpRequestBuilder addDefaultRequestParameter(String name, String value) {
        ArgsCheck.notNull(name, "name");
        return this.addDefaultRequestParameter((NameValuePair)new BasicNameValuePair(name, value));
    }

    public HttpRequestBuilder addDefaultRequestParameter(NameValuePair ... nameValues) {
        int nameValuesLength = ArgsCheck.notNull(nameValues, "nameValues").length;
        Args.check((nameValuesLength != 0 ? 1 : 0) != 0, (String)"Length of parameter can't be ZERO");
        Arrays.stream(nameValues).forEach(this::addDefaultRequestParameter);
        return this;
    }

    public HttpRequestBuilder addDefaultRequestParameter(NameValuePair nameValuePair) {
        ArgsCheck.notNull(nameValuePair, "nameValuePair");
        if (this.defaultRequestParameters == null) {
            this.defaultRequestParameters = new ArrayList<NameValuePair>();
        }
        this.defaultRequestParameters.add(nameValuePair);
        return this;
    }

    public HttpRequestBuilder addDefaultRequestParameter(Map<String, String> defaultParameters) {
        ArgsCheck.notNull(defaultParameters, "defaultParameters");
        defaultParameters.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).forEach(this::addDefaultRequestParameter);
        return this;
    }

    public HttpRequestBuilder addDefaultRequestParameter(Collection<? extends NameValuePair> defaultRequestParameters) {
        ArgsCheck.notNull(defaultRequestParameters, "defaultRequestParameters");
        if (this.defaultRequestParameters == null) {
            this.defaultRequestParameters = new ArrayList<NameValuePair>();
        }
        defaultRequestParameters.forEach(this::addDefaultRequestParameter);
        return this;
    }

    public HttpRequestBuilder addBodyReader(ResponseBodyReader<?> responseBodyReader) {
        this.responseBodyReaderConfigBuilder.addResponseBodyReader(responseBodyReader);
        return this;
    }

    public HttpRequestBuilder setDefaultResponseBodyReader(ResponseBodyReader<?> defaultResponseBodyReader) {
        this.responseBodyReaderConfigBuilder.setDefaultResponseBodyReader(defaultResponseBodyReader);
        return this;
    }

    public HttpRequestBuilder enableDefaultBodyReader() {
        this.responseBodyReaderConfigBuilder.setUseDefaultBodyReader(true);
        return this;
    }

    public HttpRequestBuilder disableDefaultBodyReader() {
        this.responseBodyReaderConfigBuilder.setUseDefaultBodyReader(false);
        return this;
    }

    public HttpRequestBuilder basicAuth(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes());
        String authHeader = "Basic " + new String(encodedAuth);
        return this.addDefaultHeader("Authorization", authHeader);
    }

    public HttpRequest build() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = Collections.emptyList();
        }
        if (this.defaultRequestParameters == null) {
            this.defaultRequestParameters = Collections.emptyList();
        }
        return new BasicHttpRequest(this.closeableHttpClient, this.defaultHeaders, this.defaultRequestParameters, this.responseBodyReaderConfigBuilder.build());
    }
}

