/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpHost;

class HostPoolConfig {
    private int maxPoolSize = 128;
    private int defaultMaxPoolSizePerRoute = 128;
    private Map<HttpHost, Integer> httpHostToMaxRoutePoolSize = new HashMap<HttpHost, Integer>();

    private HostPoolConfig() {
    }

    public HostPoolConfig setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public HostPoolConfig setDefaultMaxPoolSizePerRoute(int defaultMaxPoolSizePerRoute) {
        this.defaultMaxPoolSizePerRoute = defaultMaxPoolSizePerRoute;
        return this;
    }

    public HostPoolConfig setMaxPoolSizePerRoute(HttpHost httpHost, int maxRoutePoolSize) {
        this.httpHostToMaxRoutePoolSize.put(httpHost, maxRoutePoolSize);
        return this;
    }

    public static HostPoolConfig create() {
        return new HostPoolConfig();
    }

    int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getDefaultMaxPoolSizePerRoute() {
        return this.defaultMaxPoolSizePerRoute;
    }

    public Map<HttpHost, Integer> getHttpHostToMaxPoolSize() {
        return this.httpHostToMaxRoutePoolSize;
    }
}

