/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.OtherwiseSupport;
import com.jsunsoft.http.ResponseHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class FilterSupport<T> {
    private final ResponseHandler<T> responseHandler;
    private final Collection<Predicate<ResponseHandler<T>>> filters = new ArrayList<Predicate<ResponseHandler<T>>>();

    private FilterSupport(ResponseHandler<T> responseHandler, Predicate<ResponseHandler<T>> predicate) {
        this.responseHandler = responseHandler;
        this.filters.add(predicate);
    }

    public FilterSupport<T> filter(Predicate<ResponseHandler<T>> predicate) {
        this.filters.add(predicate);
        return this;
    }

    public OtherwiseSupport<T> ifPassed(Consumer<ResponseHandler<T>> consumer) {
        if (this.filters.stream().allMatch(predicate -> predicate.test(this.responseHandler))) {
            consumer.accept(this.responseHandler);
            return OtherwiseSupport.createIgnored(this.responseHandler);
        }
        return OtherwiseSupport.createNotIgnored(this.responseHandler);
    }

    public OtherwiseSupport<T> ifNotPassed(Consumer<ResponseHandler<T>> consumer) {
        if (this.filters.stream().anyMatch(predicate -> predicate.negate().test(this.responseHandler))) {
            consumer.accept(this.responseHandler);
            return OtherwiseSupport.createNotIgnored(this.responseHandler);
        }
        return OtherwiseSupport.createIgnored(this.responseHandler);
    }

    static <T> FilterSupport<T> create(ResponseHandler<T> responseHandler, Predicate<ResponseHandler<T>> predicate) {
        return new FilterSupport<T>(responseHandler, predicate);
    }
}

