/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.BasicConnectionFailureType;
import com.jsunsoft.http.BasicResponse;
import com.jsunsoft.http.BasicResponseBodyReaderContext;
import com.jsunsoft.http.BasicResponseHandler;
import com.jsunsoft.http.CustomArgsCheck;
import com.jsunsoft.http.HttpMethod;
import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.HttpUriRequestBuilder;
import com.jsunsoft.http.RequestException;
import com.jsunsoft.http.Response;
import com.jsunsoft.http.ResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReaderConfig;
import com.jsunsoft.http.ResponseBodyReaderException;
import com.jsunsoft.http.ResponseException;
import com.jsunsoft.http.ResponseHandler;
import com.jsunsoft.http.TypeReference;
import com.jsunsoft.http.WebTarget;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicWebTarget
implements WebTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicWebTarget.class);
    private final CloseableHttpClient closeableHttpClient;
    private final URIBuilder uriBuilder;
    private final HttpUriRequestBuilder httpUriRequestBuilder;
    private final ResponseBodyReaderConfig responseBodyReaderConfig;

    BasicWebTarget(CloseableHttpClient closeableHttpClient, URI uri, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, ResponseBodyReaderConfig responseBodyReaderConfig) {
        this(closeableHttpClient, new URIBuilder(uri), defaultHeaders, defaultRequestParameters, responseBodyReaderConfig);
    }

    BasicWebTarget(CloseableHttpClient closeableHttpClient, String uri, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, ResponseBodyReaderConfig responseBodyReaderConfig) throws URISyntaxException {
        this(closeableHttpClient, new URIBuilder(uri), defaultHeaders, defaultRequestParameters, responseBodyReaderConfig);
    }

    private BasicWebTarget(CloseableHttpClient closeableHttpClient, URIBuilder uriBuilder, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, ResponseBodyReaderConfig responseBodyReaderConfig) {
        this.closeableHttpClient = closeableHttpClient;
        this.uriBuilder = uriBuilder;
        this.responseBodyReaderConfig = responseBodyReaderConfig;
        this.httpUriRequestBuilder = new HttpUriRequestBuilder();
        defaultHeaders.forEach(this.httpUriRequestBuilder::addHeader);
        defaultRequestParameters.forEach(this.httpUriRequestBuilder::addParameter);
    }

    BasicWebTarget(CloseableHttpClient closeableHttpClient, URIBuilder uriBuilder, HttpUriRequestBuilder httpUriRequestBuilder, ResponseBodyReaderConfig responseBodyReaderConfig) {
        this.closeableHttpClient = closeableHttpClient;
        this.uriBuilder = uriBuilder;
        this.httpUriRequestBuilder = httpUriRequestBuilder;
        this.responseBodyReaderConfig = responseBodyReaderConfig;
    }

    BasicWebTarget(BasicWebTarget source) {
        this.closeableHttpClient = source.getCloseableHttpClient();
        this.uriBuilder = source.getUriBuilder();
        this.responseBodyReaderConfig = source.getResponseBodyReaderConfig();
        this.httpUriRequestBuilder = source.getHttpUriRequestBuilder();
    }

    @Override
    public WebTarget path(String path) {
        ArgsCheck.notNull(path, "path");
        HttpRequestUtils.appendPath(this.uriBuilder, path);
        return this;
    }

    @Override
    public WebTarget setPath(String path) {
        ArgsCheck.notNull(path, "path");
        this.uriBuilder.setPath(path);
        return this;
    }

    @Override
    public Response request(HttpMethod method, HttpEntity httpEntity) {
        ArgsCheck.notNull(method, "method");
        this.httpUriRequestBuilder.setEntity(httpEntity);
        return this.request(method);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, HttpEntity httpEntity, Class<T> responseType) {
        this.httpUriRequestBuilder.setEntity(httpEntity);
        return this.request(method, responseType);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, HttpEntity httpEntity, TypeReference<T> responseType) {
        ArgsCheck.notNull(method, "method");
        ArgsCheck.notNull(responseType, "responseType");
        this.httpUriRequestBuilder.setEntity(httpEntity);
        return this.request(method, responseType);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, Class<T> responseType) {
        ArgsCheck.notNull(method, "method");
        ArgsCheck.notNull(responseType, "responseType");
        return this.request(method, new TypeReference(responseType));
    }

    @Override
    public Response request(HttpMethod method) {
        ArgsCheck.notNull(method, "method");
        HttpUriRequest request = this.resolveRequest(method);
        try {
            return new BasicResponse(this.closeableHttpClient.execute(request), this.responseBodyReaderConfig, request.getURI());
        }
        catch (ConnectionPoolTimeoutException e) {
            throw new ResponseException(503, "Connection pool is empty for request on uri: [" + request.getURI() + "]. Status code: " + 503, request.getURI(), BasicConnectionFailureType.CONNECTION_POOL_IS_EMPTY, e);
        }
        catch (SocketTimeoutException | NoHttpResponseException e) {
            throw new ResponseException(503, "Server on uri: [" + request.getURI() + "] is high loaded. Status code: " + 503, request.getURI(), BasicConnectionFailureType.REMOTE_SERVER_HIGH_LOADED, e);
        }
        catch (ConnectTimeoutException e) {
            throw new ResponseException(503, "HttpRequest is unable to establish a connection with the: [" + request.getURI() + "] within the given period of time. Status code: " + 503, request.getURI(), BasicConnectionFailureType.CONNECT_TIMEOUT_EXPIRED, e);
        }
        catch (HttpHostConnectException e) {
            throw new ResponseException(503, "Server on uri: [" + request.getURI() + "] is down. Status code: " + 503, request.getURI(), BasicConnectionFailureType.REMOTE_SERVER_IS_DOWN, e);
        }
        catch (ClientProtocolException e) {
            throw new RequestException("Error in the HTTP protocol. URI: [" + request.getURI() + "]", e);
        }
        catch (IOException e) {
            throw new ResponseException(503, "Connection was aborted for request on uri: [" + request.getURI() + "]. Status code: " + 503, request.getURI(), BasicConnectionFailureType.IO, e);
        }
    }

    private HttpUriRequest resolveRequest(HttpMethod method) {
        return this.httpUriRequestBuilder.setMethod(method.name()).setUri(this.getURI()).build();
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, TypeReference<T> typeReference) {
        BasicResponseHandler<Object> result;
        CustomArgsCheck.checkIsCorrectTypeForDeserialization(typeReference.getRawType());
        long startTime = System.currentTimeMillis();
        try (Response response = this.request(method);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                throw new IllegalStateException("StatusLine is null.");
            }
            int responseCode = statusLine.getStatusCode();
            HttpEntity httpEntity = response.getEntity();
            LOGGER.info("Response code from uri: [{}] is {}", (Object)response.getURI(), (Object)responseCode);
            boolean hasBody = HttpRequestUtils.hasBody(responseCode);
            Object content = null;
            String failedMessage = null;
            if (hasBody && httpEntity == null) {
                failedMessage = "Response entity is null";
                LOGGER.debug("{} .Uri: [{}]. Status code: {}", new Object[]{failedMessage, response.getURI(), responseCode});
                responseCode = 502;
            } else {
                try {
                    if (!HttpRequestUtils.isVoidType(typeReference.getRawType()) && hasBody && HttpRequestUtils.isSuccess(responseCode)) {
                        content = response.readEntityChecked(typeReference);
                        LOGGER.trace("Result of Uri: [{}] is {}", (Object)response.getURI(), content);
                    } else if (HttpRequestUtils.isNonSuccess(responseCode)) {
                        failedMessage = ResponseBodyReader.stringReader().read(new BasicResponseBodyReaderContext<String>((HttpResponse)response, String.class, (Type)((Object)String.class)));
                        String logMsg = "Unexpected Response. Url: [" + response.getURI() + "] Status code: " + responseCode + ", Error message: " + failedMessage;
                        if (responseCode == 400) {
                            LOGGER.warn(logMsg);
                        } else {
                            LOGGER.debug(logMsg);
                        }
                    }
                }
                catch (ResponseBodyReaderException e) {
                    failedMessage = "Response deserialization failed. Cannot deserialize response to: [" + typeReference + "]." + e;
                    LOGGER.debug(failedMessage + ". Uri: [" + response.getURI() + "]. Status code: " + responseCode, (Throwable)e);
                    responseCode = 502;
                }
                catch (IOException e) {
                    failedMessage = "Get content from response failed: " + e;
                    LOGGER.debug("Stream could not be created. Uri: [" + response.getURI() + "]. Status code: " + responseCode, (Throwable)e);
                    responseCode = 503;
                }
            }
            ContentType responseContentType = ContentType.get((HttpEntity)httpEntity);
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
            result = new BasicResponseHandler<Object>(content, responseCode, failedMessage, typeReference.getType(), responseContentType, response.getURI(), statusLine);
        }
        catch (ResponseException e) {
            result = new BasicResponseHandler<Object>(null, e.getStatusCode(), e.getMessage(), typeReference.getType(), null, e.getURI(), e.getConnectionFailureType());
            LOGGER.debug("Request failed.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn("Resources close failed.", (Throwable)e);
            result = new BasicResponseHandler<Object>(null, 500, "Resources close failed. " + e, typeReference.getType(), null, this.getURI(), BasicConnectionFailureType.IO);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing of uri: [{}] completed. Time: {}", (Object)result.getURI(), (Object)HttpRequestUtils.humanTime(startTime));
        }
        LOGGER.trace("Executed result: {}", result);
        return result;
    }

    @Override
    public URI getURI() {
        URI uri;
        try {
            uri = this.uriBuilder.build().normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI syntax is incorrect. URI: [" + this.getURIString() + "].", e);
        }
        return uri;
    }

    @Override
    public String getURIString() {
        return this.uriBuilder.toString();
    }

    @Override
    public WebTarget removeHeader(Header header) {
        ArgsCheck.notNull(header, "method");
        this.httpUriRequestBuilder.removeHeader(header);
        return this;
    }

    @Override
    public WebTarget removeHeaders(String name) {
        ArgsCheck.notNull(name, "name");
        this.httpUriRequestBuilder.removeHeaders(name);
        return this;
    }

    @Override
    public WebTarget updateHeader(Header header) {
        ArgsCheck.notNull(header, "header");
        this.httpUriRequestBuilder.setHeader(header);
        return this;
    }

    @Override
    public WebTarget addHeader(Header header) {
        ArgsCheck.notNull(header, "header");
        this.httpUriRequestBuilder.addHeader(header);
        return this;
    }

    @Override
    public WebTarget setRequestConfig(RequestConfig requestConfig) {
        this.httpUriRequestBuilder.setConfig(requestConfig);
        return this;
    }

    @Override
    public WebTarget addParameter(NameValuePair nameValuePair) {
        ArgsCheck.notNull(nameValuePair, "nameValuePair");
        this.httpUriRequestBuilder.addParameter(nameValuePair);
        return this;
    }

    CloseableHttpClient getCloseableHttpClient() {
        return this.closeableHttpClient;
    }

    URIBuilder getUriBuilder() {
        return new URIBuilder(this.getURI());
    }

    HttpUriRequestBuilder getHttpUriRequestBuilder() {
        return this.httpUriRequestBuilder.copyBuilder();
    }

    ResponseBodyReaderConfig getResponseBodyReaderConfig() {
        return this.responseBodyReaderConfig;
    }
}

