/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.BasicWebTarget;
import com.jsunsoft.http.HttpRequest;
import com.jsunsoft.http.ImmutableWebTarget;
import com.jsunsoft.http.ResponseBodyReaderConfig;
import com.jsunsoft.http.RetryContext;
import com.jsunsoft.http.RetryableWebTarget;
import com.jsunsoft.http.WebTarget;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.CloseableHttpClient;

class BasicHttpRequest
implements HttpRequest {
    private final CloseableHttpClient closeableHttpClient;
    private final Collection<Header> defaultHeaders;
    private final Collection<NameValuePair> defaultRequestParameters;
    private final ResponseBodyReaderConfig responseBodyReaderConfig;

    BasicHttpRequest(CloseableHttpClient closeableHttpClient, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, ResponseBodyReaderConfig responseBodyReaderConfig) {
        this.closeableHttpClient = ArgsCheck.notNull(closeableHttpClient, "closeableHttpClient");
        this.defaultHeaders = Collections.unmodifiableList(new ArrayList<Header>(ArgsCheck.notNull(defaultHeaders, "defaultHeaders")));
        this.defaultRequestParameters = Collections.unmodifiableList(new ArrayList<NameValuePair>(ArgsCheck.notNull(defaultRequestParameters, "defaultRequestParameters")));
        this.responseBodyReaderConfig = ArgsCheck.notNull(responseBodyReaderConfig, "responseBodyReaderConfig");
    }

    @Override
    public WebTarget target(URI uri) {
        ArgsCheck.notNull(uri, "uri");
        return new BasicWebTarget(this.closeableHttpClient, uri, this.defaultHeaders, this.defaultRequestParameters, this.responseBodyReaderConfig);
    }

    @Override
    public WebTarget target(String uri) {
        ArgsCheck.notNull(uri, "uri");
        try {
            return new BasicWebTarget(this.closeableHttpClient, uri, this.defaultHeaders, this.defaultRequestParameters, this.responseBodyReaderConfig);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public WebTarget retryableTarget(URI uri, RetryContext retryContext) {
        ArgsCheck.notNull(uri, "uri");
        ArgsCheck.notNull(retryContext, "retryContext");
        return new RetryableWebTarget(this.closeableHttpClient, uri, this.defaultHeaders, this.defaultRequestParameters, retryContext, this.responseBodyReaderConfig);
    }

    @Override
    public WebTarget retryableTarget(String uri, RetryContext retryContext) {
        ArgsCheck.notNull(uri, "uri");
        ArgsCheck.notNull(retryContext, "retryContext");
        try {
            return new RetryableWebTarget(this.closeableHttpClient, uri, this.defaultHeaders, this.defaultRequestParameters, retryContext, this.responseBodyReaderConfig);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public WebTarget immutableTarget(URI uri) {
        ArgsCheck.notNull(uri, "uri");
        return new ImmutableWebTarget(this.closeableHttpClient, uri, this.defaultHeaders, this.defaultRequestParameters, this.responseBodyReaderConfig);
    }

    @Override
    public WebTarget immutableTarget(String uri) {
        ArgsCheck.notNull(uri, "uri");
        try {
            return new ImmutableWebTarget(this.closeableHttpClient, uri, this.defaultHeaders, this.defaultRequestParameters, this.responseBodyReaderConfig);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

