/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bytedeco.javacpp.Loader;
import org.tensorflow.TensorFlow;
import org.tensorflow.internal.c_api.global.tensorflow;

final class NativeLibrary {
    private static final boolean DEBUG = System.getProperty("org.tensorflow.NativeLibrary.DEBUG") != null;
    private static final String JNI_LIBNAME = "tensorflow_jni";

    public static void load() {
        Loader.load(tensorflow.class);
        if (NativeLibrary.isLoaded() || NativeLibrary.tryLoadLibrary()) {
            return;
        }
        String string = System.mapLibraryName(JNI_LIBNAME);
        String string2 = NativeLibrary.makeResourceName(string);
        NativeLibrary.log("jniResourceName: " + string2);
        InputStream inputStream = NativeLibrary.class.getClassLoader().getResourceAsStream(string2);
        String string3 = NativeLibrary.getVersionedLibraryName(System.mapLibraryName("tensorflow_framework"));
        if (string3.equals("libtensorflow_framework.dylib")) {
            string3 = "libtensorflow_framework.2.dylib";
        }
        if (string3.equals("libtensorflow_framework.so")) {
            string3 = "libtensorflow_framework.so.2";
        }
        String string4 = NativeLibrary.makeResourceName(string3);
        NativeLibrary.log("frameworkResourceName: " + string4);
        InputStream inputStream2 = NativeLibrary.class.getClassLoader().getResourceAsStream(string4);
        if (inputStream == null) {
            throw new UnsatisfiedLinkError(String.format("Cannot find TensorFlow native library for OS: %s, architecture: %s. See https://github.com/tensorflow/tensorflow/tree/master/tensorflow/java/README.md for possible solutions (such as building the library from source). Additional information on attempts to find the native library can be obtained by adding org.tensorflow.NativeLibrary.DEBUG=1 to the system properties of the JVM.", NativeLibrary.os(), NativeLibrary.architecture()));
        }
        try {
            File file = NativeLibrary.createTemporaryDirectory();
            file.deleteOnExit();
            String string5 = file.getCanonicalPath();
            if (inputStream2 != null) {
                NativeLibrary.extractResource(inputStream2, string3, string5);
            } else {
                NativeLibrary.log(string4 + " not found. This is fine assuming " + string2 + " is not built to depend on it.");
            }
            System.load(NativeLibrary.extractResource(inputStream, string, string5));
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(String.format("Unable to extract native library into a temporary file (%s)", iOException.toString()));
        }
    }

    private static boolean tryLoadLibrary() {
        try {
            System.loadLibrary(JNI_LIBNAME);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            NativeLibrary.log("tryLoadLibraryFailed: " + unsatisfiedLinkError.getMessage());
            return false;
        }
    }

    private static boolean isLoaded() {
        try {
            TensorFlow.version();
            NativeLibrary.log("isLoaded: true");
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    private static boolean resourceExists(String string) {
        return NativeLibrary.class.getClassLoader().getResource(NativeLibrary.makeResourceName(string)) != null;
    }

    private static String getVersionedLibraryName(String string) {
        if (NativeLibrary.resourceExists(string)) {
            return string;
        }
        String string2 = NativeLibrary.getMajorVersionNumber();
        if (string.endsWith(".dylib")) {
            String string3 = string.substring(0, string.length() - ".dylib".length());
            if (string2 != null) {
                String string4 = string3 + "." + string2 + ".dylib";
                if (NativeLibrary.resourceExists(string4)) {
                    return string4;
                }
            } else {
                String string5 = string3 + ".so";
                if (NativeLibrary.resourceExists(string5)) {
                    return string5;
                }
            }
        } else if (string.endsWith(".so")) {
            String string6 = string + "." + string2;
            if (string2 != null && NativeLibrary.resourceExists(string6)) {
                return string6;
            }
        }
        return string;
    }

    private static String getMajorVersionNumber() {
        int n;
        String string = NativeLibrary.class.getPackage().getImplementationVersion();
        if (string == null || (n = string.indexOf(46)) == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        try {
            Integer.parseInt(string2);
            return string2;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String extractResource(InputStream inputStream, String string, String string2) throws IOException {
        File file = new File(string2, string);
        file.deleteOnExit();
        String string3 = file.toString();
        NativeLibrary.log("extracting native library to: " + string3);
        long l = NativeLibrary.copy(inputStream, file);
        NativeLibrary.log(String.format("copied %d bytes to %s", l, string3));
        return string3;
    }

    private static String os() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("linux")) {
            return "linux";
        }
        if (string.contains("os x") || string.contains("darwin")) {
            return "darwin";
        }
        if (string.contains("windows")) {
            return "windows";
        }
        return string.replaceAll("\\s", "");
    }

    private static String architecture() {
        String string = System.getProperty("os.arch").toLowerCase();
        return string.equals("amd64") ? "x86_64" : string;
    }

    private static void log(String string) {
        if (DEBUG) {
            System.err.println("org.tensorflow.NativeLibrary: " + string);
        }
    }

    private static String makeResourceName(String string) {
        return "org/tensorflow/native/" + String.format("%s-%s/", NativeLibrary.os(), NativeLibrary.architecture()) + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            byte[] byArray = new byte[0x100000];
            long l = 0L;
            int n = 0;
            while ((n = inputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
                l += (long)n;
            }
            long l2 = l;
            return l2;
        }
        finally {
            fileOutputStream.close();
            inputStream.close();
        }
    }

    private static File createTemporaryDirectory() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        String string = "tensorflow_native_libraries-" + System.currentTimeMillis() + "-";
        for (int i = 0; i < 1000; ++i) {
            File file2 = new File(file, string + i);
            if (!file2.mkdir()) continue;
            return file2;
        }
        throw new IllegalStateException("Could not create a temporary directory (tried to make " + string + "*) to extract TensorFlow native libraries.");
    }

    private NativeLibrary() {
    }
}

