/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import org.apache.commons.io.FileUtils;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class FileHelper$ {
    public static FileHelper$ MODULE$;

    static {
        new FileHelper$();
    }

    public void writeLines(String file, Seq<String> lines, String encoding) {
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(file, new String[0]), Charset.forName(encoding), new OpenOption[0]);){
            try {
                IntRef cnt = IntRef.create((int)0);
                lines.foreach((Function1 & Serializable & scala.Serializable)line -> {
                    FileHelper$.$anonfun$writeLines$1(writer, cnt, line);
                    return BoxedUnit.UNIT;
                });
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String writeLines$default$3() {
        return "UTF-8";
    }

    public void delete(String file, boolean throwOnError) {
        block4: {
            File f = new File(file);
            if (!f.exists()) break block4;
            try {
                if (f.isDirectory()) {
                    FileUtils.deleteDirectory((File)f);
                    break block4;
                }
                FileUtils.deleteQuietly((File)f);
            }
            catch (Exception e) {
                if (throwOnError) {
                    throw e;
                }
                FileUtils.forceDeleteOnExit((File)f);
            }
        }
    }

    public boolean delete$default$2() {
        return false;
    }

    public String generateChecksum(String path) {
        byte[] arr = Files.readAllBytes(Paths.get(path, new String[0]));
        byte[] checksum = MessageDigest.getInstance("MD5").digest(arr);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(checksum)).map((Function1 & Serializable & scala.Serializable)x$1 -> FileHelper$.$anonfun$generateChecksum$1(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
    }

    public String getHumanReadableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = (String[])((Object[])new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"});
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new StringBuilder(1).append(new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups))).append(" ").append(units[digitGroups]).toString();
    }

    public static final /* synthetic */ void $anonfun$writeLines$1(BufferedWriter writer$1, IntRef cnt$1, String line) {
        writer$1.write(line);
        if (cnt$1.elem > 0) {
            writer$1.write(System.lineSeparator());
        }
        ++cnt$1.elem;
    }

    public static final /* synthetic */ String $anonfun$generateChecksum$1(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    private FileHelper$() {
        MODULE$ = this;
    }
}

