/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.storage;

import com.johnsnowlabs.storage.RocksDBConnection;
import com.johnsnowlabs.storage.RocksDBConnection$;
import com.johnsnowlabs.storage.StorageLocator;
import com.johnsnowlabs.storage.StorageLocator$;
import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StorageHelper$ {
    public static StorageHelper$ MODULE$;

    static {
        new StorageHelper$();
    }

    public String resolveStorageName(String database, String storageRef) {
        return new Path(new StringBuilder(1).append(database).append("_").append(storageRef).toString()).toString();
    }

    public RocksDBConnection load(String storageSourcePath, SparkSession spark, String database, String storageRef, boolean withinStorage) {
        String dbFolder = this.resolveStorageName(database, storageRef);
        Path src = StorageLocator$.MODULE$.getStorageSerializedPath(new StringOps(Predef$.MODULE$.augmentString(storageSourcePath)).replaceAllLiterally("\\", "/"), dbFolder, withinStorage);
        StorageLocator locator = new StorageLocator(database, storageRef, spark);
        this.sendToCluster(src, locator.clusterFilePath(), locator.clusterFileName(), locator.destinationScheme(), spark.sparkContext());
        return RocksDBConnection$.MODULE$.getOrCreate(locator.clusterFileName());
    }

    public void save(String path, RocksDBConnection connection, SparkSession spark, boolean withinStorage) {
        String indexUri = new StringBuilder(7).append("file://").append(new URI(new StringOps(Predef$.MODULE$.augmentString(connection.findLocalIndex())).replaceAllLiterally("\\", "/")).getPath()).toString();
        Path index = new Path(indexUri);
        URI uri = new URI(new StringOps(Predef$.MODULE$.augmentString(path)).replaceAllLiterally("\\", "/"));
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)spark.sparkContext().hadoopConfiguration());
        Path dst = new Path(new StringBuilder(0).append(path).append((Object)(withinStorage ? "/storage/" : "")).toString());
        this.save(fs, index, dst);
    }

    private void save(FileSystem fs, Path index, Path dst) {
        Object object = !fs.exists(dst) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(dst)) : BoxedUnit.UNIT;
        fs.copyFromLocalFile(false, true, index, dst);
    }

    public void sendToCluster(Path source, Path clusterFilePath, String clusterFileName, String destinationScheme, SparkContext sparkContext) {
        String string = destinationScheme;
        if ("file".equals(string)) {
            this.copyIndexToLocal(source, new Path(RocksDBConnection$.MODULE$.getLocalPath(clusterFileName)), sparkContext);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.copyIndexToCluster(source, clusterFilePath, sparkContext);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private String copyIndexToCluster(Path sourcePath, Path dst, SparkContext spark) {
        block2: {
            Object object;
            if (new File(SparkFiles$.MODULE$.get(dst.getName())).exists()) break block2;
            FileSystem srcFS = sourcePath.getFileSystem(spark.hadoopConfiguration());
            FileSystem dstFS = dst.getFileSystem(spark.hadoopConfiguration());
            String string = srcFS.getScheme();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Path src = sourcePath;
                dstFS.copyFromLocalFile(false, true, src, dst);
                object = BoxedUnit.UNIT;
            } else {
                object = BoxesRunTime.boxToBoolean((boolean)FileUtil.copy((FileSystem)srcFS, (Path)sourcePath, (FileSystem)dstFS, (Path)dst, (boolean)false, (boolean)true, (Configuration)spark.hadoopConfiguration()));
            }
            spark.addFile(dst.toString(), true);
        }
        return dst.toString();
    }

    private void copyIndexToLocal(Path source, Path destination, SparkContext context) {
        block0: {
            FileSystem fs = source.getFileSystem(context.hadoopConfiguration());
            if (fs.exists(destination)) break block0;
            fs.copyFromLocalFile(false, true, source, destination);
        }
    }

    private StorageHelper$() {
        MODULE$ = this;
    }
}

