/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.util.io;

import com.johnsnowlabs.client.aws.AWSGateway;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFiles$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class OutputHelper$ {
    public static OutputHelper$ MODULE$;
    private FileSystem fileSystem;
    private boolean isDBFS;
    private Path targetPath;
    private String[] historyLog;
    private volatile byte bitmap$0;

    static {
        new OutputHelper$();
    }

    private FileSystem fileSystem$lzycompute() {
        OutputHelper$ outputHelper$ = this;
        synchronized (outputHelper$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fileSystem = ConfigHelper$.MODULE$.getFileSystem();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.fileSystem;
    }

    private FileSystem fileSystem() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.fileSystem$lzycompute() : this.fileSystem;
    }

    private String logsFolder() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.annotatorLogFolder());
    }

    private boolean isDBFS$lzycompute() {
        OutputHelper$ outputHelper$ = this;
        synchronized (outputHelper$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isDBFS = this.fileSystem().getScheme().equals("dbfs");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isDBFS;
    }

    private boolean isDBFS() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.isDBFS$lzycompute() : this.isDBFS;
    }

    private Path targetPath() {
        return this.targetPath;
    }

    private void targetPath_$eq(Path x$1) {
        this.targetPath = x$1;
    }

    public String[] historyLog() {
        return this.historyLog;
    }

    public void historyLog_$eq(String[] x$1) {
        this.historyLog = x$1;
    }

    public void writeAppend(String uuid, String content, String outputLogsPath) {
        String targetFolder = this.getTargetFolder(outputLogsPath);
        this.targetPath_$eq(new Path(targetFolder, new StringBuilder(4).append(uuid).append(".log").toString()));
        if (this.isDBFS()) {
            this.historyLog_$eq((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.historyLog())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{content})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        } else {
            Object object = !this.fileSystem().exists(new Path(targetFolder)) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().mkdirs(new Path(targetFolder))) : BoxedUnit.UNIT;
            if (this.fileSystem().getScheme().equals("file")) {
                File fo = new File(this.targetPath().toUri().getRawPath());
                FileWriter writer = new FileWriter(fo, true);
                writer.append(new StringBuilder(0).append(content).append(System.lineSeparator()).toString());
                writer.close();
            } else {
                this.fileSystem().createNewFile(this.targetPath());
                FSDataOutputStream fo = this.fileSystem().append(this.targetPath());
                PrintWriter writer = new PrintWriter((OutputStream)fo, true);
                writer.append(new StringBuilder(0).append(content).append(System.lineSeparator()).toString());
                writer.close();
                fo.close();
            }
        }
    }

    private String getTargetFolder(String outputLogsPath) {
        return outputLogsPath.isEmpty() ? (this.logsFolder().startsWith("s3") ? new StringBuilder(9).append(SparkFiles$.MODULE$.getRootDirectory()).append("/tmp/logs").toString() : this.logsFolder()) : outputLogsPath;
    }

    public void exportLogFileToS3() {
        try {
            if (this.isDBFS()) {
                Charset charset = StandardCharsets.ISO_8859_1;
                FSDataOutputStream outputStream = this.fileSystem().create(this.targetPath());
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.historyLog())).foreach((Function1 & Serializable & scala.Serializable)log -> {
                    outputStream.write(log.getBytes(charset));
                    return BoxedUnit.UNIT;
                });
                outputStream.close();
                this.historyLog_$eq((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
            }
            if (this.logsFolder().startsWith("s3")) {
                AWSGateway awsGateway = new AWSGateway(ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalAccessKeyId()), ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalSecretAccessKey()), ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalSessionToken()), ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalProfileName()), ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalRegion()), "proprietary");
                String bucket = ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalS3BucketKey());
                String sourceFilePath = this.targetPath().toString();
                String s3FilePath = new StringBuilder(1).append(ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.annotatorLogFolder()).substring("s3://".length())).append("/").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFilePath.split("/"))).last()).toString();
                awsGateway.copyInputStreamToS3(bucket, s3FilePath, sourceFilePath);
            }
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(60).append("Warning couldn't export log on DBFS or S3 because of error: ").append(e.getMessage()).toString());
        }
    }

    private OutputHelper$() {
        MODULE$ = this;
        this.historyLog = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }
}

