/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.training;

import com.johnsnowlabs.nlp.annotators.common.IndexedTaggedWord;
import com.johnsnowlabs.nlp.annotators.common.IndexedTaggedWord$;
import com.johnsnowlabs.nlp.annotators.common.TaggedSentence;
import com.johnsnowlabs.nlp.annotators.common.TaggedSentence$;
import com.johnsnowlabs.nlp.training.CoNLLHelper;
import com.johnsnowlabs.nlp.training.CoNLLUCols$;
import com.johnsnowlabs.nlp.training.CoNLLUDocument;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CoNLLHelper$ {
    public static CoNLLHelper$ MODULE$;

    static {
        new CoNLLHelper$();
    }

    public Seq<CoNLLUDocument> readLines(String[] lines, boolean explodeSentences) {
        StringBuilder doc = new StringBuilder();
        ArrayBuffer lastSentence = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer sentences = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Tuple2[] docs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).flatMap((Function1 & Serializable & scala.Serializable)line -> {
            String[] items = line.trim().split("\\t");
            String id = items[CoNLLUCols$.MODULE$.ID().id()].isEmpty() ? "" : new StringOps(Predef$.MODULE$.augmentString(items[CoNLLUCols$.MODULE$.ID().id()])).head().toString();
            String string = id;
            Option option = "#".equals(string) ? CoNLLHelper$.processComment$1(items, doc, sentences) : ("".equals(string) ? this.processNewLine$1(explodeSentences, doc, lastSentence, sentences) : this.processCoNLLRow$1(items, doc, lastSentence));
            Option coNLLRow = option;
            return Option$.MODULE$.option2Iterable(coNLLRow);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        this.addSentence$1(lastSentence, sentences);
        Seq last = doc.nonEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)doc.toString(), (Object)sentences.toList())})) : (Seq)Seq$.MODULE$.empty();
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])docs)).$plus$plus((GenTraversableOnce)last, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String text = (String)tuple2._1();
            List textSentence = (List)tuple2._2();
            List uPos = (List)textSentence.map((Function1 & Serializable & scala.Serializable)t -> t.uPos(), List$.MODULE$.canBuildFrom());
            List xPos = (List)textSentence.map((Function1 & Serializable & scala.Serializable)t -> t.xPos(), List$.MODULE$.canBuildFrom());
            List lemma = (List)textSentence.map((Function1 & Serializable & scala.Serializable)t -> t.lemma(), List$.MODULE$.canBuildFrom());
            CoNLLUDocument coNLLUDocument = new CoNLLUDocument(text, (Seq<TaggedSentence>)uPos, (Seq<TaggedSentence>)xPos, (Seq<TaggedSentence>)lemma);
            return coNLLUDocument;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private IndexedTaggedWord[] clearTokens(IndexedTaggedWord[] tokens) {
        return (IndexedTaggedWord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)CoNLLHelper$.$anonfun$clearTokens$1(t)));
    }

    private CoNLLHelper.CoNLLTokenCols getIndexedTaggedCoNLL(String[] items, StringBuilder doc, int sentenceIndex) {
        int begin = doc.length();
        doc.append(items[CoNLLUCols$.MODULE$.FORM().id()]);
        int end = doc.length() - 1;
        String word = items[CoNLLUCols$.MODULE$.FORM().id()];
        String uPosTag = items[CoNLLUCols$.MODULE$.UPOS().id()];
        String xPosTag = items[CoNLLUCols$.MODULE$.XPOS().id()];
        String lemmaValue = items[CoNLLUCols$.MODULE$.LEMMA().id()];
        IndexedTaggedWord uPos = new IndexedTaggedWord(word, uPosTag, begin, end, IndexedTaggedWord$.MODULE$.apply$default$5(), IndexedTaggedWord$.MODULE$.apply$default$6());
        IndexedTaggedWord xPos = new IndexedTaggedWord(word, xPosTag, begin, end, IndexedTaggedWord$.MODULE$.apply$default$5(), IndexedTaggedWord$.MODULE$.apply$default$6());
        IndexedTaggedWord lemma = new IndexedTaggedWord(lemmaValue, "", begin, end, IndexedTaggedWord$.MODULE$.apply$default$5(), IndexedTaggedWord$.MODULE$.apply$default$6());
        return new CoNLLHelper.CoNLLTokenCols(uPos, xPos, lemma, sentenceIndex);
    }

    private int getIndexedTaggedCoNLL$default$3() {
        return 0;
    }

    private final void addSentence$1(ArrayBuffer lastSentence$1, ArrayBuffer sentences$1) {
        IndexedTaggedWord[] uPosTokens = this.clearTokens((IndexedTaggedWord[])((TraversableOnce)lastSentence$1.map((Function1 & Serializable & scala.Serializable)t -> t.uPosTokens(), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(IndexedTaggedWord.class)));
        IndexedTaggedWord[] xPosTokens = this.clearTokens((IndexedTaggedWord[])((TraversableOnce)lastSentence$1.map((Function1 & Serializable & scala.Serializable)t -> t.xPosTokens(), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(IndexedTaggedWord.class)));
        IndexedTaggedWord[] lemmaTokens = this.clearTokens((IndexedTaggedWord[])((TraversableOnce)lastSentence$1.map((Function1 & Serializable & scala.Serializable)t -> t.lemma(), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(IndexedTaggedWord.class)));
        TaggedSentence uPos = TaggedSentence$.MODULE$.apply(uPosTokens);
        TaggedSentence xPos = TaggedSentence$.MODULE$.apply(xPosTokens);
        TaggedSentence lemma = TaggedSentence$.MODULE$.apply(lemmaTokens);
        CoNLLHelper.CoNLLSentenceCols taggedCoNLLSentence = new CoNLLHelper.CoNLLSentenceCols(uPos, xPos, lemma);
        sentences$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoNLLHelper.CoNLLSentenceCols[]{taggedCoNLLSentence}));
        lastSentence$1.clear();
    }

    private static final Option closeDocument$1(StringBuilder doc$1, ArrayBuffer sentences$1) {
        Tuple2 result = new Tuple2((Object)doc$1.toString(), (Object)sentences$1.toList());
        doc$1.clear();
        sentences$1.clear();
        return new StringOps(Predef$.MODULE$.augmentString((String)result._1())).nonEmpty() ? new Some((Object)new Tuple2(result._1(), result._2())) : None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private final Option processCoNLLRow$1(String[] items, StringBuilder doc$1, ArrayBuffer lastSentence$1) {
        if (!doc$1.nonEmpty() || doc$1.endsWith((GenSeq)Predef$.MODULE$.wrapString(System.lineSeparator()))) ** GOTO lbl-1000
        v0 = items[3];
        var4_4 = "PUNCT";
        if (v0 == null ? var4_4 != null : v0.equals(var4_4) == false) {
            v1 = doc$1.append(" ");
        } else lbl-1000:
        // 2 sources

        {
            v1 = BoxedUnit.UNIT;
        }
        indexedTaggedCoNLL = this.getIndexedTaggedCoNLL(items, doc$1, this.getIndexedTaggedCoNLL$default$3());
        lastSentence$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoNLLHelper.CoNLLTokenCols[]{indexedTaggedCoNLL}));
        return None$.MODULE$;
    }

    private final Option processNewLine$1(boolean explodeSentences$1, StringBuilder doc$1, ArrayBuffer lastSentence$1, ArrayBuffer sentences$1) {
        Object object = !explodeSentences$1 && doc$1.nonEmpty() && !doc$1.endsWith((GenSeq)Predef$.MODULE$.wrapString(System.lineSeparator())) && lastSentence$1.nonEmpty() ? doc$1.append(new StringOps(Predef$.MODULE$.augmentString(System.lineSeparator())).$times(2)) : BoxedUnit.UNIT;
        this.addSentence$1(lastSentence$1, sentences$1);
        return explodeSentences$1 ? CoNLLHelper$.closeDocument$1(doc$1, sentences$1) : None$.MODULE$;
    }

    private static final Option processComment$1(String[] items, StringBuilder doc$1, ArrayBuffer sentences$1) {
        return items[CoNLLUCols$.MODULE$.ID().id()].contains("newdoc") ? CoNLLHelper$.closeDocument$1(doc$1, sentences$1) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$clearTokens$1(IndexedTaggedWord t) {
        return new StringOps(Predef$.MODULE$.augmentString(t.word().trim())).nonEmpty();
    }

    private CoNLLHelper$() {
        MODULE$ = this;
    }
}

