/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.johnsnowlabs.client.aws.AWSGateway;
import com.johnsnowlabs.nlp.pretrained.RepositoryMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata$;
import com.johnsnowlabs.nlp.pretrained.ResourceRequest;
import com.johnsnowlabs.nlp.pretrained.S3ResourceDownloader$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import com.johnsnowlabs.util.FileHelper$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001\u0002\r\u001a\u0001\tB\u0001\"\f\u0001\u0003\u0002\u0013\u0006IA\f\u0005\ty\u0001\u0011\t\u0011*A\u0005]!AQ\b\u0001B\u0001J\u0003%a\u0006\u0003\u0005?\u0001\t\u0005I\u0015!\u0003/\u0011!y\u0004A!A!\u0002\u0013\t\u0004\"\u0002!\u0001\t\u0003\t\u0005b\u0002%\u0001\u0005\u0004%\t!\u0013\u0005\u0007+\u0002\u0001\u000b\u0011\u0002&\t\u000fY\u0003!\u0019!C\u0001/\"1A\r\u0001Q\u0001\naC\u0001\"\u001a\u0001\t\u0006\u0004%\tA\u001a\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003s\u0001A\u0011IA\u001e\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fB\u0011\"a\u0019\u0001#\u0003%I!!\u001a\b\u0013\u0005m\u0014$!A\t\u0002\u0005ud\u0001\u0003\r\u001a\u0003\u0003E\t!a \t\r\u0001+B\u0011AAA\u0011%\t\u0019)FI\u0001\n\u0003\t)I\u0001\u000bTgI+7o\\;sG\u0016$un\u001e8m_\u0006$WM\u001d\u0006\u00035m\t!\u0002\u001d:fiJ\f\u0017N\\3e\u0015\taR$A\u0002oYBT!AH\u0010\u0002\u0019)|\u0007N\\:o_^d\u0017MY:\u000b\u0003\u0001\n1aY8n\u0007\u0001\u00192\u0001A\u0012*!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fMB\u0011!fK\u0007\u00023%\u0011A&\u0007\u0002\u0013%\u0016\u001cx.\u001e:dK\u0012{wO\u001c7pC\u0012,'/\u0001\u0004ck\u000e\\W\r\u001e\t\u0004I=\n\u0014B\u0001\u0019&\u0005!a$-\u001f8b[\u0016t\u0004C\u0001\u001a:\u001d\t\u0019t\u0007\u0005\u00025K5\tQG\u0003\u00027C\u00051AH]8pizJ!\u0001O\u0013\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q\u0015\naa]\u001aQCRD\u0017aC2bG\",gi\u001c7eKJ\fqb\u0019:fI\u0016tG/[1mgRK\b/Z\u0001\u0007e\u0016<\u0017n\u001c8\u0002\rqJg.\u001b;?)\u0019\u00115\tR#G\u000fB\u0011!\u0006\u0001\u0005\u0007[\u0019!\t\u0019\u0001\u0018\t\rq2A\u00111\u0001/\u0011\u0019id\u0001\"a\u0001]!1aH\u0002CA\u00029Bqa\u0010\u0004\u0011\u0002\u0003\u0007\u0011'A\nsKB|gi\u001c7eKJ\u0014T*\u001a;bI\u0006$\u0018-F\u0001K!\u0011Y\u0005+\r*\u000e\u00031S!!\u0014(\u0002\u000f5,H/\u00192mK*\u0011q*J\u0001\u000bG>dG.Z2uS>t\u0017BA)M\u0005\ri\u0015\r\u001d\t\u0003UMK!\u0001V\r\u0003%I+\u0007o\\:ji>\u0014\u00180T3uC\u0012\fG/Y\u0001\u0015e\u0016\u0004xNR8mI\u0016\u0014('T3uC\u0012\fG/\u0019\u0011\u0002\u0013\r\f7\r[3QCRDW#\u0001-\u0011\u0005e\u0013W\"\u0001.\u000b\u0005mc\u0016A\u00014t\u0015\tif,\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003?\u0002\fa!\u00199bG\",'\"A1\u0002\u0007=\u0014x-\u0003\u0002d5\n!\u0001+\u0019;i\u0003)\u0019\u0017m\u00195f!\u0006$\b\u000eI\u0001\u000bC^\u001cx)\u0019;fo\u0006LX#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017aA1xg*\u0011A.H\u0001\u0007G2LWM\u001c;\n\u00059L'AC!X'\u001e\u000bG/Z<bs\u00061Bm\\<oY>\fG-T3uC\u0012\fG/Y%g\u001d\u0016,G\r\u0006\u0002r{B\u0019!o\u001e>\u000f\u0005M,hB\u0001\u001bu\u0013\u00051\u0013B\u0001<&\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001_=\u0003\t1K7\u000f\u001e\u0006\u0003m\u0016\u0002\"AK>\n\u0005qL\"\u0001\u0005*fg>,(oY3NKR\fG-\u0019;b\u0011\u0015qH\u00021\u00012\u0003\u00191w\u000e\u001c3fe\u0006Y!/Z:pYZ,G*\u001b8l)\u0011\t\u0019!!\u0003\u0011\t\u0011\n)A_\u0005\u0004\u0003\u000f)#AB(qi&|g\u000eC\u0004\u0002\f5\u0001\r!!\u0004\u0002\u000fI,\u0017/^3tiB\u0019!&a\u0004\n\u0007\u0005E\u0011DA\bSKN|WO]2f%\u0016\fX/Z:u\u0003!!wn\u001e8m_\u0006$G\u0003BA\f\u00033\u0001B\u0001JA\u0003c!9\u00111\u0002\bA\u0002\u00055\u0011\u0001\u00063po:dw.\u00193B]\u0012,fN_5q\r&dW\r\u0006\u0005\u0002\u0018\u0005}\u00111EA\u0014\u0011\u0019\t\tc\u0004a\u00011\u0006yA-Z:uS:\fG/[8o\r&dW\r\u0003\u0004\u0002&=\u0001\rA_\u0001\te\u0016\u001cx.\u001e:dK\"1\u0011\u0011F\bA\u0002E\n!b]\u001aGS2,\u0007+\u0019;i\u0003=9W\r\u001e#po:dw.\u00193TSj,G\u0003BA\u0018\u0003o\u0001R\u0001JA\u0003\u0003c\u00012\u0001JA\u001a\u0013\r\t)$\n\u0002\u0005\u0019>tw\rC\u0004\u0002\fA\u0001\r!!\u0004\u0002\u0015\rdW-\u0019:DC\u000eDW\r\u0006\u0003\u0002>\u0005\r\u0003c\u0001\u0013\u0002@%\u0019\u0011\u0011I\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0017\t\u0002\u0019AA\u0007\u000319W\r\u001e+j[\u0016\u001cH/Y7q)\u0011\tI%!\u0017\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005\u00191/\u001d7\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0016\u0002N\tIA+[7fgR\fW\u000e\u001d\u0005\n\u00037\u0012\u0002\u0013!a\u0001\u0003;\n!\"\u00193e\u001b&tW\u000f^3t!\r!\u0013qL\u0005\u0004\u0003C*#aA%oi\u00061r-\u001a;US6,7\u000f^1na\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002h)\"\u0011QLA5W\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA;K\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0014q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F*4%\u0016\u001cx.\u001e:dK\u0012{wO\u001c7pC\u0012,'\u000f\u0005\u0002++M\u0011Qc\t\u000b\u0003\u0003{\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAADU\r\t\u0014\u0011\u000e")
public class S3ResourceDownloader
implements ResourceDownloader {
    private AWSGateway awsGateway;
    private final Function0<String> bucket;
    private final Function0<String> s3Path;
    private final Function0<String> credentialsType;
    private final String region;
    private final Map<String, RepositoryMetadata> repoFolder2Metadata;
    private final Path cachePath;
    private final FileSystem fileSystem;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$5() {
        return S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public void com$johnsnowlabs$nlp$pretrained$ResourceDownloader$_setter_$fileSystem_$eq(FileSystem x$1) {
        this.fileSystem = x$1;
    }

    public Map<String, RepositoryMetadata> repoFolder2Metadata() {
        return this.repoFolder2Metadata;
    }

    public Path cachePath() {
        return this.cachePath;
    }

    private AWSGateway awsGateway$lzycompute() {
        S3ResourceDownloader s3ResourceDownloader = this;
        synchronized (s3ResourceDownloader) {
            if (!this.bitmap$0) {
                this.awsGateway = new AWSGateway(ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.accessKeyId()), ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.secretAccessKey()), ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.sessionToken()), ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsProfileName()), this.region, (String)this.credentialsType.apply());
                this.bitmap$0 = true;
            }
        }
        this.credentialsType = null;
        this.region = null;
        return this.awsGateway;
    }

    public AWSGateway awsGateway() {
        return !this.bitmap$0 ? this.awsGateway$lzycompute() : this.awsGateway;
    }

    @Override
    public List<ResourceMetadata> downloadMetadataIfNeed(String folder) {
        Option lastState = this.repoFolder2Metadata().get((Object)folder);
        Timestamp fiveMinsBefore = this.getTimestamp(-5);
        boolean needToRefresh = lastState.isEmpty() || ((RepositoryMetadata)lastState.get()).lastMetadataDownloaded().before(fiveMinsBefore);
        return !needToRefresh ? ((RepositoryMetadata)lastState.get()).metadata() : this.awsGateway().getMetadata((String)this.s3Path.apply(), folder, (String)this.bucket.apply());
    }

    public Option<ResourceMetadata> resolveLink(ResourceRequest request) {
        List<ResourceMetadata> metadata = this.downloadMetadataIfNeed(request.folder());
        return ResourceMetadata$.MODULE$.resolveResource(metadata, request);
    }

    @Override
    public Option<String> download(ResourceRequest request) {
        Option<ResourceMetadata> link = this.resolveLink(request);
        return link.flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            String s3FilePath = this.awsGateway().getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)$this.s3Path.apply(), request.folder(), resource.fileName()}));
            Path destinationFile = new Path(this.cachePath().toString(), resource.fileName());
            return !this.awsGateway().doesS3ObjectExist((String)$this.bucket.apply(), s3FilePath) ? None$.MODULE$ : this.downloadAndUnzipFile(destinationFile, (ResourceMetadata)resource, s3FilePath);
        });
    }

    public Option<String> downloadAndUnzipFile(Path destinationFile, ResourceMetadata resource, String s3FilePath) {
        Some some;
        String splitPath = destinationFile.toString().substring(0, destinationFile.toString().length() - 4);
        if (!this.fileSystem().exists(destinationFile) && !this.fileSystem().exists(new Path(splitPath))) {
            String tmpFileName = ((Object)Files.createTempFile(resource.fileName(), "", new FileAttribute[0])).toString();
            File tmpFile = new File(tmpFileName);
            this.awsGateway().getS3Object((String)this.bucket.apply(), s3FilePath, tmpFile);
            if (!resource.checksum().equals("")) {
                Predef$.MODULE$.require(FileHelper$.MODULE$.generateChecksum(tmpFileName).equals(resource.checksum()), (Function0 & Serializable & scala.Serializable)() -> "Checksum validation failed!");
            }
            this.fileSystem().moveFromLocalFile(new Path(tmpFile.toString()), destinationFile);
        }
        if (resource.isZipped()) {
            Object object;
            if (!this.fileSystem().exists(new Path(splitPath))) {
                ZipInputStream zis = new ZipInputStream((InputStream)this.fileSystem().open(destinationFile));
                byte[] buf = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
                ZipEntry entry = zis.getNextEntry();
                String string = destinationFile.toString().substring(destinationFile.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Not a zip file.");
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        Path entryName = new Path(splitPath, entry.getName());
                        FSDataOutputStream outputStream = this.fileSystem().create(entryName);
                        int bytesRead = zis.read(buf, 0, 1024);
                        while (bytesRead > -1) {
                            outputStream.write(buf, 0, bytesRead);
                            bytesRead = zis.read(buf, 0, 1024);
                        }
                        outputStream.close();
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
                zis.close();
                object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(destinationFile, true));
            } else {
                object = BoxedUnit.UNIT;
            }
            some = new Some((Object)splitPath);
        } else {
            some = new Some((Object)destinationFile.getName());
        }
        return some;
    }

    @Override
    public Option<Object> getDownloadSize(ResourceRequest request) {
        Option<ResourceMetadata> link = this.resolveLink(request);
        return link.flatMap((Function1 & Serializable & scala.Serializable)resource -> this.awsGateway().getS3DownloadSize((String)$this.s3Path.apply(), request.folder(), resource.fileName(), (String)$this.bucket.apply()));
    }

    @Override
    public void clearCache(ResourceRequest request) {
        List<ResourceMetadata> metadata = this.downloadMetadataIfNeed(request.folder());
        Option<ResourceMetadata> resources = ResourceMetadata$.MODULE$.resolveResource(metadata, request);
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            Object object;
            Path fileName = new Path(this.cachePath().toString(), resource.fileName());
            Object object2 = this.fileSystem().exists(fileName) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(fileName, true)) : BoxedUnit.UNIT;
            if (resource.isZipped()) {
                String string = fileName.toString().substring(fileName.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
                String unzipped = fileName.toString().substring(0, fileName.toString().length() - 4);
                Path unzippedFile = new Path(unzipped);
                object = this.fileSystem().exists(unzippedFile) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(unzippedFile, true)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Timestamp getTimestamp(int addMinutes) {
        void var3_3;
        Calendar cal = Calendar.getInstance();
        cal.add(12, addMinutes);
        Timestamp timestamp = new Timestamp(cal.getTime().getTime());
        cal.clear();
        return var3_3;
    }

    private int getTimestamp$default$1() {
        return 0;
    }

    public S3ResourceDownloader(Function0<String> bucket, Function0<String> s3Path, Function0<String> cacheFolder, Function0<String> credentialsType, String region) {
        this.bucket = bucket;
        this.s3Path = s3Path;
        this.credentialsType = credentialsType;
        this.region = region;
        ResourceDownloader.$init$(this);
        this.repoFolder2Metadata = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.cachePath = new Path((String)cacheFolder.apply());
        Object object = !this.fileSystem().exists(this.cachePath()) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().mkdirs(this.cachePath())) : BoxedUnit.UNIT;
    }
}

