/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.johnsnowlabs.nlp.pretrained.ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceRequest;
import com.johnsnowlabs.nlp.pretrained.ResourceRequest$;
import com.johnsnowlabs.nlp.pretrained.ResourceType$;
import com.johnsnowlabs.nlp.pretrained.S3ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.S3ResourceDownloader$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.Build$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import com.johnsnowlabs.util.FileHelper$;
import com.johnsnowlabs.util.Version;
import com.johnsnowlabs.util.Version$;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineModel$;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.util.DefaultParamsReadable;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ResourceDownloader$ {
    public static ResourceDownloader$ MODULE$;
    private Version sparkVersion;
    private Version libVersion;
    private final FileSystem fileSystem;
    private final String publicLoc;
    private final Map<ResourceRequest, PipelineStage> cache;
    private ResourceDownloader defaultDownloader;
    private ResourceDownloader publicDownloader;
    private ResourceDownloader communityDownloader;
    private volatile byte bitmap$0;

    static {
        new ResourceDownloader$();
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public String s3Bucket() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.pretrainedS3BucketKey());
    }

    public String s3BucketCommunity() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.pretrainedCommunityS3BucketKey());
    }

    public String s3Path() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.pretrainedS3PathKey());
    }

    public String cacheFolder() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.pretrainedCacheFolder());
    }

    public String publicLoc() {
        return this.publicLoc;
    }

    private Map<ResourceRequest, PipelineStage> cache() {
        return this.cache;
    }

    private Version sparkVersion$lzycompute() {
        ResourceDownloader$ resourceDownloader$ = this;
        synchronized (resourceDownloader$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String spark_version = ResourceHelper$.MODULE$.spark().version().startsWith("2.3") ? "2.4.4" : ResourceHelper$.MODULE$.spark().version();
                this.sparkVersion = Version$.MODULE$.parse(spark_version);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkVersion;
    }

    public Version sparkVersion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkVersion$lzycompute() : this.sparkVersion;
    }

    private Version libVersion$lzycompute() {
        ResourceDownloader$ resourceDownloader$ = this;
        synchronized (resourceDownloader$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.libVersion = Version$.MODULE$.parse(Build$.MODULE$.version());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.libVersion;
    }

    public Version libVersion() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.libVersion$lzycompute() : this.libVersion;
    }

    public ResourceDownloader defaultDownloader() {
        return this.defaultDownloader;
    }

    public void defaultDownloader_$eq(ResourceDownloader x$1) {
        this.defaultDownloader = x$1;
    }

    public ResourceDownloader publicDownloader() {
        return this.publicDownloader;
    }

    public void publicDownloader_$eq(ResourceDownloader x$1) {
        this.publicDownloader = x$1;
    }

    public ResourceDownloader communityDownloader() {
        return this.communityDownloader;
    }

    public void communityDownloader_$eq(ResourceDownloader x$1) {
        this.communityDownloader = x$1;
    }

    public void resetResourceDownloader() {
        this.cache().empty();
        this.defaultDownloader_$eq(new S3ResourceDownloader((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Bucket(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Path(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.cacheFolder(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "default", S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5()));
    }

    public List<String> listPublicModels() {
        return this.listPretrainedResources(this.publicLoc(), ResourceType$.MODULE$.MODEL(), this.listPretrainedResources$default$3(), this.listPretrainedResources$default$4(), this.listPretrainedResources$default$5());
    }

    public void showPublicModels(Option<String> annotator, Option<String> lang, Option<String> version) {
        Predef$.MODULE$.println((Object)this.publicResourceString(annotator, lang, version, ResourceType$.MODULE$.MODEL()));
    }

    public void showPublicModels(String annotator) {
        this.showPublicModels((Option<String>)new Some((Object)annotator), this.showPublicModels$default$2(), this.showPublicModels$default$3());
    }

    public void showPublicModels(String annotator, String lang) {
        this.showPublicModels((Option<String>)new Some((Object)annotator), (Option<String>)new Some((Object)lang), this.showPublicModels$default$3());
    }

    public void showPublicModels(String annotator, String lang, String version) {
        this.showPublicModels((Option<String>)new Some((Object)annotator), (Option<String>)new Some((Object)lang), (Option<String>)new Some((Object)version));
    }

    public Option<String> showPublicModels$default$1() {
        return None$.MODULE$;
    }

    public Option<String> showPublicModels$default$2() {
        return None$.MODULE$;
    }

    public Option<String> showPublicModels$default$3() {
        return new Some((Object)Build$.MODULE$.version());
    }

    public List<String> listPublicPipelines() {
        return this.listPretrainedResources(this.publicLoc(), ResourceType$.MODULE$.PIPELINE(), this.listPretrainedResources$default$3(), this.listPretrainedResources$default$4(), this.listPretrainedResources$default$5());
    }

    public void showPublicPipelines(Option<String> lang, Option<String> version) {
        Predef$.MODULE$.println((Object)this.publicResourceString((Option<String>)None$.MODULE$, lang, version, ResourceType$.MODULE$.PIPELINE()));
    }

    public void showPublicPipelines(String lang) {
        this.showPublicPipelines((Option<String>)new Some((Object)lang), this.showPublicPipelines$default$2());
    }

    public void showPublicPipelines(String lang, String version) {
        this.showPublicPipelines((Option<String>)new Some((Object)lang), (Option<String>)new Some((Object)version));
    }

    public Option<String> showPublicPipelines$default$1() {
        return None$.MODULE$;
    }

    public Option<String> showPublicPipelines$default$2() {
        return new Some((Object)Build$.MODULE$.version());
    }

    public List<String> listUnCategorizedResources() {
        return this.listPretrainedResources(this.publicLoc(), ResourceType$.MODULE$.NOT_DEFINED(), this.listPretrainedResources$default$3(), this.listPretrainedResources$default$4(), this.listPretrainedResources$default$5());
    }

    public void showUnCategorizedResources(String lang) {
        Predef$.MODULE$.println((Object)this.publicResourceString((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)lang), (Option<String>)None$.MODULE$, ResourceType$.MODULE$.NOT_DEFINED()));
    }

    public void showUnCategorizedResources(String lang, String version) {
        Predef$.MODULE$.println((Object)this.publicResourceString((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)lang), (Option<String>)new Some((Object)version), ResourceType$.MODULE$.NOT_DEFINED()));
    }

    public String showString(List<String> list, Enumeration.Value resourceType) {
        StringBuilder sb = new StringBuilder();
        IntRef max_length = IntRef.create((int)14);
        IntRef max_length_version = IntRef.create((int)7);
        list.foreach((Function1 & Serializable & scala.Serializable)data -> {
            ResourceDownloader$.$anonfun$showString$1(max_length, max_length_version, data);
            return BoxedUnit.UNIT;
        });
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length.elem + 2));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length_version.elem + 2));
        sb.append("+\n");
        StringBuilder stringBuilder = resourceType.equals((Object)ResourceType$.MODULE$.PIPELINE()) ? sb.append(new java.lang.StringBuilder(30).append("| Pipeline").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length.elem - 8)).append(" | ").append("lang").append(" | ").append("version").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length_version.elem - 7)).append(" |\n").toString()) : (resourceType.equals((Object)ResourceType$.MODULE$.MODEL()) ? sb.append(new java.lang.StringBuilder(27).append("| Model").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length.elem - 5)).append(" | ").append("lang").append(" | ").append("version").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length_version.elem - 7)).append(" |\n").toString()) : sb.append(new java.lang.StringBuilder(36).append("| Pipeline/Model").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length.elem - 14)).append(" | ").append("lang").append(" | ").append("version").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length_version.elem - 7)).append(" |\n").toString()));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length.elem + 2));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length_version.elem + 2));
        sb.append("+\n");
        list.foreach((Function1 & Serializable & scala.Serializable)data -> {
            String[] temp = data.split(":");
            return sb.append(new java.lang.StringBuilder(13).append("| ").append(temp[0]).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length$1.elem - temp[0].length())).append(" |  ").append(temp[1]).append("  | ").append(temp[2]).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length_version$1.elem - temp[2].length())).append(" |\n").toString());
        });
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length.elem + 2));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length_version.elem + 2));
        sb.append("+\n");
        return sb.toString();
    }

    public String publicResourceString(Option<String> annotator, Option<String> lang, Option<String> version, Enumeration.Value resourceType) {
        None$ none$;
        String string = this.publicLoc();
        Option<String> option = version;
        if (option instanceof Some) {
            Some some = (Some)option;
            String ver = (String)some.value();
            none$ = new Some((Object)Version$.MODULE$.parse(ver));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return this.showString(this.listPretrainedResources(string, resourceType, annotator, lang, (Option<Version>)none$), resourceType);
    }

    public Option<String> publicResourceString$default$1() {
        return None$.MODULE$;
    }

    public Option<String> publicResourceString$default$2() {
        return None$.MODULE$;
    }

    public Option<String> publicResourceString$default$3() {
        return new Some((Object)Build$.MODULE$.version());
    }

    public List<String> listPretrainedResources(String folder, Enumeration.Value resourceType, Option<String> annotator, Option<String> lang, Option<Version> version) {
        ListBuffer resourceList = new ListBuffer();
        List<ResourceMetadata> resourceMetaData = this.defaultDownloader().downloadMetadataIfNeed(folder);
        resourceMetaData.foreach((Function1 & Serializable & scala.Serializable)meta -> {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean isSameResourceType = meta.category().getOrElse((Function0 & Serializable & scala.Serializable)() -> ResourceType$.MODULE$.NOT_DEFINED()).toString().equals(resourceType.toString());
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                Version ver = (Version)some.value();
                bl3 = Version$.MODULE$.isCompatible(ver, meta.libVersion());
            } else if (None$.MODULE$.equals(option)) {
                bl3 = true;
            } else {
                throw new MatchError((Object)option);
            }
            boolean isCompatibleWithVersion = bl3;
            Option option2 = annotator;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String cls = (String)some.value();
                bl2 = ((String)meta.annotator().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).equalsIgnoreCase(cls);
            } else if (None$.MODULE$.equals(option2)) {
                bl2 = true;
            } else {
                throw new MatchError((Object)option2);
            }
            boolean isSameAnnotator = bl2;
            Option option3 = lang;
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                String l = (String)some.value();
                bl = ((String)meta.language().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).equalsIgnoreCase(l);
            } else if (None$.MODULE$.equals(option3)) {
                bl = true;
            } else {
                throw new MatchError((Object)option3);
            }
            boolean isSameLanguage = bl;
            return isSameResourceType & isCompatibleWithVersion & isSameAnnotator & isSameLanguage ? resourceList.$plus$eq((Object)new java.lang.StringBuilder(2).append(meta.name()).append(":").append(meta.language().getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).append(":").append(meta.libVersion().getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).toString()) : BoxedUnit.UNIT;
        });
        return resourceList.result();
    }

    public List<String> listPretrainedResources(String folder, Enumeration.Value resourceType, String lang) {
        String x$1 = folder;
        Enumeration.Value x$2 = resourceType;
        Some x$3 = new Some((Object)lang);
        Option<String> x$4 = this.listPretrainedResources$default$3();
        Option<Version> x$5 = this.listPretrainedResources$default$5();
        return this.listPretrainedResources(x$1, x$2, x$4, (Option<String>)x$3, x$5);
    }

    public List<String> listPretrainedResources(String folder, Enumeration.Value resourceType, Version version) {
        String x$1 = folder;
        Enumeration.Value x$2 = resourceType;
        Some x$3 = new Some((Object)version);
        Option<String> x$4 = this.listPretrainedResources$default$3();
        Option<String> x$5 = this.listPretrainedResources$default$4();
        return this.listPretrainedResources(x$1, x$2, x$4, x$5, (Option<Version>)x$3);
    }

    public List<String> listPretrainedResources(String folder, Enumeration.Value resourceType, String lang, Version version) {
        String x$1 = folder;
        Enumeration.Value x$2 = resourceType;
        Some x$3 = new Some((Object)lang);
        Some x$4 = new Some((Object)version);
        Option<String> x$5 = this.listPretrainedResources$default$3();
        return this.listPretrainedResources(x$1, x$2, x$5, (Option<String>)x$3, (Option<Version>)x$4);
    }

    public Option<String> listPretrainedResources$default$3() {
        return None$.MODULE$;
    }

    public Option<String> listPretrainedResources$default$4() {
        return None$.MODULE$;
    }

    public Option<Version> listPretrainedResources$default$5() {
        return None$.MODULE$;
    }

    public List<String> listAvailableAnnotators(String folder) {
        List<ResourceMetadata> resourceMetaData = this.defaultDownloader().downloadMetadataIfNeed(folder);
        return (List)((TraversableOnce)((TraversableOnce)resourceMetaData.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.annotator().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), List$.MODULE$.canBuildFrom())).toSet().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)ResourceDownloader$.$anonfun$listAvailableAnnotators$3(a)))).toList().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public String listAvailableAnnotators$default$1() {
        return this.publicLoc();
    }

    public void showAvailableAnnotators(String folder) {
        Predef$.MODULE$.println((Object)this.listAvailableAnnotators(folder).mkString("\n"));
    }

    public String showAvailableAnnotators$default$1() {
        return this.publicLoc();
    }

    public String downloadResource(String name, Option<String> language, String folder) {
        return this.downloadResource(new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
    }

    public String downloadResource(ResourceRequest request) {
        Future f = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> option;
            if (request.folder().equals(MODULE$.publicLoc())) {
                option = MODULE$.publicDownloader().download(request);
            } else if (request.folder().startsWith("@")) {
                String actualLoc = request.folder().replace("@", "");
                ResourceRequest updatedRequest = new ResourceRequest(request.name(), request.language(), actualLoc, request.libVersion(), request.sparkVersion());
                option = MODULE$.communityDownloader().download(updatedRequest);
            } else {
                option = MODULE$.defaultDownloader().download(request);
            }
            return option;
        }, ExecutionContext.Implicits$.MODULE$.global());
        BooleanRef download_finished = BooleanRef.create((boolean)false);
        ObjectRef path = ObjectRef.create((Object)None$.MODULE$);
        String file_size = this.getDownloadSize(request.name(), request.language(), request.folder());
        Predef$.MODULE$.require(!file_size.equals("-1"), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(86).append("Can not find ").append(request.name()).append(" inside ").append(request.folder()).append(" to download. Please make sure the name and location are correct!").toString());
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(42).append(request.name()).append(" download started this may take some time.").toString());
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(29).append("Approximate size to download ").append(file_size).toString());
        int nextc = 0;
        while (!download_finished.elem) {
            ++nextc;
            f.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ResourceDownloader$.$anonfun$downloadResource$3(download_finished, path, x0$1);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
            Thread.sleep(1000L);
        }
        Predef$.MODULE$.require(((Option)path.elem).isDefined(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(78).append("Was not found appropriate resource to download for request: ").append(request).append(" with downloader: ").append(MODULE$.defaultDownloader()).toString());
        Predef$.MODULE$.println((Object)"Download done! Loading the resource.");
        return (String)((Option)path.elem).get();
    }

    public Option<String> downloadResource$default$2() {
        return None$.MODULE$;
    }

    public String downloadResource$default$3() {
        return this.publicLoc();
    }

    public <TModel extends PipelineStage> TModel downloadModel(DefaultParamsReadable<TModel> reader, String name, Option<String> language, String folder) {
        return this.downloadModel(reader, new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
    }

    public <TModel extends PipelineStage> TModel downloadModel(DefaultParamsReadable<TModel> reader, ResourceRequest request) {
        PipelineStage pipelineStage;
        if (!this.cache().contains((Object)request)) {
            String path = this.downloadResource(request);
            PipelineStage model = (PipelineStage)reader.read().load(path);
            this.cache().update((Object)request, (Object)model);
            pipelineStage = model;
        } else {
            pipelineStage = (PipelineStage)this.cache().apply((Object)request);
        }
        return (TModel)pipelineStage;
    }

    public <TModel extends PipelineStage> Option<String> downloadModel$default$3() {
        return None$.MODULE$;
    }

    public <TModel extends PipelineStage> String downloadModel$default$4() {
        return this.publicLoc();
    }

    public PipelineModel downloadPipeline(String name, Option<String> language, String folder) {
        return this.downloadPipeline(new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
    }

    /*
     * WARNING - void declaration
     */
    public PipelineModel downloadPipeline(ResourceRequest request) {
        PipelineModel pipelineModel;
        if (!this.cache().contains((Object)request)) {
            void var3_3;
            String path = this.downloadResource(request);
            PipelineModel model = (PipelineModel)PipelineModel$.MODULE$.read().load(path);
            this.cache().update((Object)request, (Object)model);
            pipelineModel = var3_3;
        } else {
            pipelineModel = (PipelineModel)this.cache().apply((Object)request);
        }
        return pipelineModel;
    }

    public Option<String> downloadPipeline$default$2() {
        return None$.MODULE$;
    }

    public String downloadPipeline$default$3() {
        return this.publicLoc();
    }

    public void clearCache(String name, Option<String> language, String folder) {
        this.clearCache(new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
    }

    public void clearCache(ResourceRequest request) {
        this.defaultDownloader().clearCache(request);
        this.publicDownloader().clearCache(request);
        this.communityDownloader().clearCache(request);
        this.cache().remove((Object)request);
    }

    public Option<String> clearCache$default$2() {
        return None$.MODULE$;
    }

    public String clearCache$default$3() {
        return this.publicLoc();
    }

    public String getDownloadSize(String name, Option<String> language, String folder) {
        String string;
        Option<Object> size = None$.MODULE$;
        if (folder.equals(this.publicLoc())) {
            size = this.publicDownloader().getDownloadSize(new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
        } else if (folder.startsWith("@")) {
            String actualLoc = folder.replace("@", "");
            size = this.communityDownloader().getDownloadSize(new ResourceRequest(name, language, actualLoc, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
        } else {
            size = this.defaultDownloader().getDownloadSize(new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
        }
        Option<Object> option = size;
        if (option instanceof Some) {
            Some some = (Some)option;
            long downloadBytes = BoxesRunTime.unboxToLong((Object)some.value());
            string = FileHelper$.MODULE$.getHumanReadableFileSize(downloadBytes);
        } else if (None$.MODULE$.equals(option)) {
            string = "-1";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public Option<String> getDownloadSize$default$2() {
        return None$.MODULE$;
    }

    public String getDownloadSize$default$3() {
        return this.publicLoc();
    }

    public static final /* synthetic */ void $anonfun$showString$1(IntRef max_length$1, IntRef max_length_version$1, String data) {
        String[] temp = data.split(":");
        max_length$1.elem = package$.MODULE$.max(temp[0].length(), max_length$1.elem);
        max_length_version$1.elem = package$.MODULE$.max(temp[2].length(), max_length_version$1.elem);
    }

    public static final /* synthetic */ boolean $anonfun$listAvailableAnnotators$3(String a) {
        return !a.equals("");
    }

    public static final /* synthetic */ void $anonfun$downloadResource$3(BooleanRef download_finished$1, ObjectRef path$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Option value = (Option)success.value();
            download_finished$1.elem = true;
            path$1.elem = value;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            download_finished$1.elem = true;
            path$1.elem = None$.MODULE$;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private ResourceDownloader$() {
        MODULE$ = this;
        this.fileSystem = ConfigHelper$.MODULE$.getFileSystem();
        this.publicLoc = "public/models";
        this.cache = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.defaultDownloader = new S3ResourceDownloader((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Bucket(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Path(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.cacheFolder(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "default", S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5());
        this.publicDownloader = new S3ResourceDownloader((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Bucket(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Path(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.cacheFolder(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "public", S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5());
        this.communityDownloader = new S3ResourceDownloader((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3BucketCommunity(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Path(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.cacheFolder(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "community", S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5());
    }
}

