/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.embeddings;

import com.johnsnowlabs.nlp.embeddings.WordEmbeddingsWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class WordEmbeddingsBinaryIndexer$ {
    public static WordEmbeddingsBinaryIndexer$ MODULE$;
    private final Logger logger;

    static {
        new WordEmbeddingsBinaryIndexer$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void index(DataInputStream source, WordEmbeddingsWriter writer) {
        try {
            int numWords = Integer.parseInt(this.readString(source));
            int vecSize = Integer.parseInt(this.readString(source));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numWords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                String word = MODULE$.readString(source);
                float[] vector = MODULE$.readFloatVector(source, vecSize, writer);
                writer.add(word, vector);
            });
            this.logger().info(new StringBuilder(27).append("Loaded ").append(numWords).append(" words, vector size ").append(vecSize).toString());
        }
        finally {
            writer.close();
        }
    }

    public void index(String source, WordEmbeddingsWriter writer) {
        try (DataInputStream ds = new DataInputStream(new BufferedInputStream(new FileInputStream(source), 32768));){
            this.index(ds, writer);
        }
    }

    private String readString(DataInputStream ds) {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        boolean isEnd = false;
        while (!isEnd) {
            byte byteValue = ds.readByte();
            if (byteValue != 32 && byteValue != 10) {
                byteBuffer.write(byteValue);
                continue;
            }
            if (byteBuffer.size() <= 0) continue;
            isEnd = true;
        }
        String word = byteBuffer.toString();
        byteBuffer.close();
        return word;
    }

    private float[] readFloatVector(DataInputStream ds, int vectorSize, WordEmbeddingsWriter indexer) {
        byte[] vectorBuffer = (byte[])Array$.MODULE$.fill(4 * vectorSize, (Function0)(JFunction0.mcB.sp & java.io.Serializable & Serializable)() -> 0, ClassTag$.MODULE$.Byte());
        ds.read(vectorBuffer);
        return indexer.fromBytes(vectorBuffer);
    }

    private WordEmbeddingsBinaryIndexer$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"WordEmbeddings");
    }
}

