/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep.util;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;

public class Dictionary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TObjectIntHashMap map;
    private int numEntries;
    private boolean growthStopped = false;
    private String mapAsString;

    public TObjectIntHashMap getMap() {
        return this.map;
    }

    public void setMap(TObjectIntHashMap tObjectIntHashMap) {
        this.map = tObjectIntHashMap;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public boolean isGrowthStopped() {
        return this.growthStopped;
    }

    public void setNumEntries(int n) {
        this.numEntries = n;
    }

    public void setGrowthStopped(boolean bl) {
        this.growthStopped = bl;
    }

    public void setMapAsString(String string) {
        this.mapAsString = string;
    }

    public String getMapAsString() {
        return this.mapAsString;
    }

    private Dictionary(int n) {
        this.map = new TObjectIntHashMap(n);
        this.numEntries = 0;
    }

    Dictionary() {
        this(10000);
    }

    public int lookupIndex(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an Alphabet.");
        }
        int n = this.map.get(object);
        if (n <= 0 && !this.growthStopped) {
            ++this.numEntries;
            n = this.numEntries;
            this.map.put(object, n);
        }
        return n;
    }

    public Object[] toArray() {
        return this.map.keys();
    }

    public int dictionarySize() {
        return this.numEntries;
    }

    void stopGrowth() {
        this.growthStopped = true;
    }
}

