/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep;

import com.johnsnowlabs.nlp.annotators.parser.typdep.DependencyInstance;
import com.johnsnowlabs.nlp.annotators.parser.typdep.DependencyPipe;
import com.johnsnowlabs.nlp.annotators.parser.typdep.LocalFeatureData;
import com.johnsnowlabs.nlp.annotators.parser.typdep.Options;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.FeatureVector;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.Utils;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LoggerFactory.getLogger((String)"TypedDependencyParser");
    private float regularization;
    private float gammaLabel;
    private int rankFirstOrderTensor;
    private int rankSecondOrderTensor;
    private int numberWordFeatures;
    private int T;
    private int DL;
    private float[] paramsL;
    private transient float[] totalL;
    private float[][] U;
    private float[][] V;
    private float[][] WL;
    private float[][] U2;
    private float[][] V2;
    private float[][] W2;
    private float[][] X2L;
    private float[][] Y2L;
    private transient float[][] totalU;
    private transient float[][] totalV;
    private transient float[][] totalWL;
    private transient float[][] totalU2;
    private transient float[][] totalV2;
    private transient float[][] totalW2;
    private transient float[][] totalX2L;
    private transient float[][] totalY2L;
    private transient FeatureVector[] dU;
    private transient FeatureVector[] dV;
    private transient FeatureVector[] dWL;
    private transient FeatureVector[] dU2;
    private transient FeatureVector[] dV2;
    private transient FeatureVector[] dW2;
    private transient FeatureVector[] dX2L;
    private transient FeatureVector[] dY2L;

    public void setGammaLabel(float f) {
        this.gammaLabel = f;
    }

    public void setRankFirstOrderTensor(int n) {
        this.rankFirstOrderTensor = n;
    }

    public void setRankSecondOrderTensor(int n) {
        this.rankSecondOrderTensor = n;
    }

    public int getT() {
        return this.T;
    }

    public int getNumberWordFeatures() {
        return this.numberWordFeatures;
    }

    public int getDL() {
        return this.DL;
    }

    public float[] getParamsL() {
        return this.paramsL;
    }

    public float[][] getU() {
        return this.U;
    }

    public float[][] getV() {
        return this.V;
    }

    public float[][] getWL() {
        return this.WL;
    }

    public float[][] getU2() {
        return this.U2;
    }

    public float[][] getV2() {
        return this.V2;
    }

    public float[][] getW2() {
        return this.W2;
    }

    public float[][] getX2L() {
        return this.X2L;
    }

    public float[][] getY2L() {
        return this.Y2L;
    }

    public Parameters(DependencyPipe dependencyPipe, Options options) {
        this.numberWordFeatures = dependencyPipe.getSynFactory().getNumberWordFeatures();
        this.T = dependencyPipe.getTypes().length;
        this.DL = this.T * 3;
        this.regularization = options.regularization;
        this.gammaLabel = options.gammaLabel;
        this.rankFirstOrderTensor = options.rankFirstOrderTensor;
        this.rankSecondOrderTensor = options.rankSecondOrderTensor;
        int n = dependencyPipe.getSynFactory().getNumberLabeledArcFeatures() + 1;
        this.paramsL = new float[n];
        this.totalL = new float[n];
        this.U = new float[this.numberWordFeatures][this.rankFirstOrderTensor];
        this.V = new float[this.numberWordFeatures][this.rankFirstOrderTensor];
        this.WL = new float[this.DL][this.rankFirstOrderTensor];
        this.totalU = new float[this.numberWordFeatures][this.rankFirstOrderTensor];
        this.totalV = new float[this.numberWordFeatures][this.rankFirstOrderTensor];
        this.totalWL = new float[this.DL][this.rankFirstOrderTensor];
        this.dU = new FeatureVector[this.rankFirstOrderTensor];
        this.dV = new FeatureVector[this.rankFirstOrderTensor];
        this.dWL = new FeatureVector[this.rankFirstOrderTensor];
        this.U2 = new float[this.numberWordFeatures][this.rankSecondOrderTensor];
        this.V2 = new float[this.numberWordFeatures][this.rankSecondOrderTensor];
        this.W2 = new float[this.numberWordFeatures][this.rankSecondOrderTensor];
        this.X2L = new float[this.DL][this.rankSecondOrderTensor];
        this.Y2L = new float[this.DL][this.rankSecondOrderTensor];
        this.totalU2 = new float[this.numberWordFeatures][this.rankSecondOrderTensor];
        this.totalV2 = new float[this.numberWordFeatures][this.rankSecondOrderTensor];
        this.totalW2 = new float[this.numberWordFeatures][this.rankSecondOrderTensor];
        this.totalX2L = new float[this.DL][this.rankSecondOrderTensor];
        this.totalY2L = new float[this.DL][this.rankSecondOrderTensor];
        this.dU2 = new FeatureVector[this.rankSecondOrderTensor];
        this.dV2 = new FeatureVector[this.rankSecondOrderTensor];
        this.dW2 = new FeatureVector[this.rankSecondOrderTensor];
        this.dX2L = new FeatureVector[this.rankSecondOrderTensor];
        this.dY2L = new FeatureVector[this.rankSecondOrderTensor];
    }

    private void copyValue(float[][] fArray, float[][] fArray2) {
        int n = fArray2.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float[])fArray2[i].clone();
        }
    }

    public void assignTotal() {
        this.copyValue(this.totalU, this.U);
        this.copyValue(this.totalV, this.V);
        this.copyValue(this.totalWL, this.WL);
        this.copyValue(this.totalU2, this.U2);
        this.copyValue(this.totalV2, this.V2);
        this.copyValue(this.totalW2, this.W2);
        this.copyValue(this.totalX2L, this.X2L);
        this.copyValue(this.totalY2L, this.Y2L);
    }

    private void assignColumn(float[][] fArray, int n, float[] fArray2) {
        for (float fArray[var4_4][n] : fArray2) {
        }
    }

    public void randomlyInit() {
        int n;
        for (n = 0; n < this.rankFirstOrderTensor; ++n) {
            this.assignColumn(this.U, n, Utils.getRandomUnitVector(this.numberWordFeatures));
            this.assignColumn(this.V, n, Utils.getRandomUnitVector(this.numberWordFeatures));
            this.assignColumn(this.WL, n, Utils.getRandomUnitVector(this.DL));
        }
        for (n = 0; n < this.rankSecondOrderTensor; ++n) {
            this.assignColumn(this.U2, n, Utils.getRandomUnitVector(this.numberWordFeatures));
            this.assignColumn(this.V2, n, Utils.getRandomUnitVector(this.numberWordFeatures));
            this.assignColumn(this.W2, n, Utils.getRandomUnitVector(this.numberWordFeatures));
            this.assignColumn(this.X2L, n, Utils.getRandomUnitVector(this.DL));
            this.assignColumn(this.Y2L, n, Utils.getRandomUnitVector(this.DL));
        }
        this.assignTotal();
    }

    private void averageTheta(float[] fArray, float[] fArray2, int n, float f) {
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = i;
            fArray[n3] = fArray[n3] + f * fArray2[i] / (float)n;
        }
    }

    private void averageTensor(float[][] fArray, float[][] fArray2, int n, float f) {
        int n2 = fArray.length;
        if (n2 == 0) {
            return;
        }
        int n3 = fArray[0].length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                float[] fArray3 = fArray[i];
                int n4 = j;
                fArray3[n4] = fArray3[n4] + f * fArray2[i][j] / (float)n;
            }
        }
    }

    public void averageParameters(int n, float f) {
        this.averageTheta(this.paramsL, this.totalL, n, f);
        this.averageTensor(this.U, this.totalU, n, f);
        this.averageTensor(this.V, this.totalV, n, f);
        this.averageTensor(this.WL, this.totalWL, n, f);
        this.averageTensor(this.U2, this.totalU2, n, f);
        this.averageTensor(this.V2, this.totalV2, n, f);
        this.averageTensor(this.W2, this.totalW2, n, f);
        this.averageTensor(this.X2L, this.totalX2L, n, f);
        this.averageTensor(this.Y2L, this.totalY2L, n, f);
    }

    private void printStat(float[][] fArray, String string) {
        if (this.logger.isDebugEnabled()) {
            float f = 0.0f;
            float f2 = Float.POSITIVE_INFINITY;
            float f3 = Float.NEGATIVE_INFINITY;
            for (float[] fArray2 : fArray) {
                f += Utils.squaredSum(fArray2);
                f2 = Math.min(f2, Utils.min(fArray2));
                f3 = Math.max(f3, Utils.max(fArray2));
            }
            this.logger.debug(String.format(" |%s|^2: %f min: %f\tmax: %f%n", string, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3)));
        }
    }

    public void printStat() {
        if (this.logger.isDebugEnabled()) {
            this.printStat(this.U, "U");
            this.printStat(this.V, "V");
            this.printStat(this.WL, "WL");
            this.printStat(this.U2, "U2");
            this.printStat(this.V2, "V2");
            this.printStat(this.W2, "W2");
            this.printStat(this.X2L, "X2L");
            this.printStat(this.Y2L, "Y2L");
        }
    }

    private void projectMat(float[][] fArray, FeatureVector featureVector, float[] fArray2) {
        int n = fArray2.length;
        int n2 = featureVector.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = featureVector.x(i);
            float f = featureVector.value(i);
            for (int j = 0; j < n; ++j) {
                int n4 = j;
                fArray2[n4] = fArray2[n4] + fArray[n3][j] * f;
            }
        }
    }

    public void projectU(FeatureVector featureVector, float[] fArray) {
        this.projectMat(this.U, featureVector, fArray);
    }

    public void projectV(FeatureVector featureVector, float[] fArray) {
        this.projectMat(this.V, featureVector, fArray);
    }

    public void projectU2(FeatureVector featureVector, float[] fArray) {
        this.projectMat(this.U2, featureVector, fArray);
    }

    public void projectV2(FeatureVector featureVector, float[] fArray) {
        this.projectMat(this.V2, featureVector, fArray);
    }

    public void projectW2(FeatureVector featureVector, float[] fArray) {
        this.projectMat(this.W2, featureVector, fArray);
    }

    public float dotProductL(float[] fArray, float[] fArray2, int n, int n2) {
        float f = 0.0f;
        for (int i = 0; i < this.rankFirstOrderTensor; ++i) {
            f += fArray[i] * fArray2[i] * (this.WL[n][i] + this.WL[n2 * this.T + n][i]);
        }
        return f;
    }

    public float dotProduct2L(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2, int n3, int n4) {
        float f = 0.0f;
        for (int i = 0; i < this.rankSecondOrderTensor; ++i) {
            f += fArray[i] * fArray2[i] * fArray3[i] * (this.X2L[n][i] + this.X2L[n3 * this.T + n][i]) * (this.Y2L[n2][i] + this.Y2L[n4 * this.T + n2][i]);
        }
        return f;
    }

    private void addTheta(float[] fArray, float[] fArray2, FeatureVector featureVector, float f, float f2) {
        if (featureVector == null) {
            return;
        }
        int n = featureVector.size();
        for (int i = 0; i < n; ++i) {
            int n2 = featureVector.x(i);
            float f3 = featureVector.value(i);
            int n3 = n2;
            fArray[n3] = fArray[n3] + f * f3;
            int n4 = n2;
            fArray2[n4] = fArray2[n4] + f2 * f3;
        }
    }

    private void addTensor(float[][] fArray, float[][] fArray2, FeatureVector[] featureVectorArray, float f, float f2) {
        int n = featureVectorArray.length;
        for (int i = 0; i < n; ++i) {
            FeatureVector featureVector = featureVectorArray[i];
            if (featureVector == null) continue;
            int n2 = featureVector.size();
            for (int j = 0; j < n2; ++j) {
                int n3 = featureVector.x(j);
                float f3 = featureVector.value(j);
                float[] fArray3 = fArray[n3];
                int n4 = i;
                fArray3[n4] = fArray3[n4] + f * f3;
                float[] fArray4 = fArray2[n3];
                int n5 = i;
                fArray4[n5] = fArray4[n5] + f2 * f3;
            }
        }
    }

    public float updateLabel(DependencyInstance dependencyInstance, int[] nArray, int[] nArray2, LocalFeatureData localFeatureData, int n) {
        int n2;
        int n3;
        FeatureVector featureVector;
        int n4;
        int[] nArray3 = dependencyInstance.getHeads();
        int[] nArray4 = dependencyInstance.getDependencyLabelIds();
        float f = this.getLabelDistance(nArray4, nArray2);
        FeatureVector featureVector2 = localFeatureData.getLabeledFeatureDifference(dependencyInstance, nArray, nArray2);
        float f2 = -featureVector2.dotProduct(this.paramsL) * this.gammaLabel + f;
        float f3 = featureVector2.squaredL2NormUnsafe() * this.gammaLabel * this.gammaLabel;
        for (n4 = 0; n4 < this.rankFirstOrderTensor; ++n4) {
            featureVector = this.getdUL(n4, localFeatureData, nArray3, nArray4, nArray, nArray2);
            f3 += featureVector.squaredL2NormUnsafe() * (1.0f - this.gammaLabel) * (1.0f - this.gammaLabel);
            n3 = featureVector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                f2 -= this.U[featureVector.x(n2)][n4] * featureVector.value(n2) * (1.0f - this.gammaLabel);
            }
            this.dU[n4] = featureVector;
        }
        for (n4 = 0; n4 < this.rankFirstOrderTensor; ++n4) {
            featureVector = this.getdVL(n4, localFeatureData, nArray3, nArray4, nArray, nArray2);
            f3 += featureVector.squaredL2NormUnsafe() * (1.0f - this.gammaLabel) * (1.0f - this.gammaLabel);
            this.dV[n4] = featureVector;
        }
        for (n4 = 0; n4 < this.rankFirstOrderTensor; ++n4) {
            featureVector = this.getdWL(n4, localFeatureData, nArray3, nArray4, nArray, nArray2);
            f3 += featureVector.squaredL2NormUnsafe() * (1.0f - this.gammaLabel) * (1.0f - this.gammaLabel);
            this.dWL[n4] = featureVector;
        }
        for (n4 = 0; n4 < this.rankSecondOrderTensor; ++n4) {
            featureVector = this.getdU2L(n4, localFeatureData, nArray3, nArray4, nArray2);
            f3 += featureVector.squaredL2NormUnsafe() * (1.0f - this.gammaLabel) * (1.0f - this.gammaLabel);
            n3 = featureVector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                f2 -= this.U2[featureVector.x(n2)][n4] * featureVector.value(n2) * (1.0f - this.gammaLabel);
            }
            this.dU2[n4] = featureVector;
        }
        for (n4 = 0; n4 < this.rankSecondOrderTensor; ++n4) {
            featureVector = this.getdV2L(n4, localFeatureData, nArray3, nArray4, nArray2);
            f3 += featureVector.squaredL2NormUnsafe() * (1.0f - this.gammaLabel) * (1.0f - this.gammaLabel);
            this.dV2[n4] = featureVector;
        }
        for (n4 = 0; n4 < this.rankSecondOrderTensor; ++n4) {
            featureVector = this.getdW2L(n4, localFeatureData, nArray3, nArray4, nArray2);
            f3 += featureVector.squaredL2NormUnsafe() * (1.0f - this.gammaLabel) * (1.0f - this.gammaLabel);
            this.dW2[n4] = featureVector;
        }
        for (n4 = 0; n4 < this.rankSecondOrderTensor; ++n4) {
            featureVector = this.getdX2L(n4, localFeatureData, nArray3, nArray4, nArray2);
            f3 += featureVector.squaredL2NormUnsafe() * (1.0f - this.gammaLabel) * (1.0f - this.gammaLabel);
            this.dX2L[n4] = featureVector;
        }
        for (n4 = 0; n4 < this.rankSecondOrderTensor; ++n4) {
            featureVector = this.getdY2L(n4, localFeatureData, nArray3, nArray4, nArray2);
            f3 += featureVector.squaredL2NormUnsafe() * (1.0f - this.gammaLabel) * (1.0f - this.gammaLabel);
            this.dY2L[n4] = featureVector;
        }
        float f4 = f2 / f3;
        if ((f4 = Math.min(this.regularization, f4)) > 0.0f) {
            float f5 = f4 * this.gammaLabel;
            float f6 = f5 * (float)(1 - n);
            this.addTheta(this.paramsL, this.totalL, featureVector2, f5, f6);
            f5 = f4 * (1.0f - this.gammaLabel);
            f6 = f5 * (float)(1 - n);
            this.addTensor(this.U, this.totalU, this.dU, f5, f6);
            this.addTensor(this.V, this.totalV, this.dV, f5, f6);
            this.addTensor(this.WL, this.totalWL, this.dWL, f5, f6);
            this.addTensor(this.U2, this.totalU2, this.dU2, f5, f6);
            this.addTensor(this.V2, this.totalV2, this.dV2, f5, f6);
            this.addTensor(this.W2, this.totalW2, this.dW2, f5, f6);
            this.addTensor(this.X2L, this.totalX2L, this.dX2L, f5, f6);
            this.addTensor(this.Y2L, this.totalY2L, this.dY2L, f5, f6);
        }
        return f2;
    }

    private float getLabelDistance(int[] nArray, int[] nArray2) {
        float f = 0.0f;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            f += 1.0f;
        }
        return f;
    }

    private FeatureVector getdUL(int n, LocalFeatureData localFeatureData, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        float[][] fArray = localFeatureData.wpV;
        FeatureVector[] featureVectorArray = localFeatureData.wordFvs;
        int n2 = featureVectorArray.length;
        FeatureVector featureVector = new FeatureVector();
        for (int i = 1; i < n2; ++i) {
            assert (nArray[i] == nArray3[i]);
            int n3 = nArray[i];
            int n4 = n3 > i ? 1 : 2;
            int n5 = nArray2[i];
            int n6 = nArray4[i];
            if (n5 == n6) continue;
            float f = fArray[i][n];
            featureVector.addEntries(featureVectorArray[n3], f * (this.WL[n5][n] + this.WL[n4 * this.T + n5][n]) - f * (this.WL[n6][n] + this.WL[n4 * this.T + n6][n]));
        }
        return featureVector;
    }

    private FeatureVector getdVL(int n, LocalFeatureData localFeatureData, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        float[][] fArray = localFeatureData.wpU;
        FeatureVector[] featureVectorArray = localFeatureData.wordFvs;
        int n2 = featureVectorArray.length;
        FeatureVector featureVector = new FeatureVector();
        for (int i = 1; i < n2; ++i) {
            assert (nArray[i] == nArray3[i]);
            int n3 = nArray[i];
            int n4 = n3 > i ? 1 : 2;
            int n5 = nArray2[i];
            int n6 = nArray4[i];
            if (n5 == n6) continue;
            float f = fArray[n3][n];
            featureVector.addEntries(featureVectorArray[i], f * (this.WL[n5][n] + this.WL[n4 * this.T + n5][n]) - f * (this.WL[n6][n] + this.WL[n4 * this.T + n6][n]));
        }
        return featureVector;
    }

    private FeatureVector getdWL(int n, LocalFeatureData localFeatureData, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2;
        float[][] fArray = localFeatureData.wpU;
        float[][] fArray2 = localFeatureData.wpV;
        FeatureVector[] featureVectorArray = localFeatureData.wordFvs;
        int n3 = featureVectorArray.length;
        float[] fArray3 = new float[this.DL];
        for (int i = 1; i < n3; ++i) {
            assert (nArray[i] == nArray3[i]);
            n2 = nArray[i];
            int n4 = n2 > i ? 1 : 2;
            int n5 = nArray2[i];
            int n6 = nArray4[i];
            if (n5 == n6) continue;
            float f = fArray[n2][n];
            float f2 = fArray2[i][n];
            int n7 = n5;
            fArray3[n7] = fArray3[n7] + f * f2;
            int n8 = n4 * this.T + n5;
            fArray3[n8] = fArray3[n8] + f * f2;
            int n9 = n6;
            fArray3[n9] = fArray3[n9] - f * f2;
            int n10 = n4 * this.T + n6;
            fArray3[n10] = fArray3[n10] - f * f2;
        }
        FeatureVector featureVector = new FeatureVector();
        for (n2 = 0; n2 < this.DL; ++n2) {
            featureVector.addEntry(n2, fArray3[n2]);
        }
        return featureVector;
    }

    private FeatureVector getdU2L(int n, LocalFeatureData localFeatureData, int[] nArray, int[] nArray2, int[] nArray3) {
        float[][] fArray = localFeatureData.wpV2;
        float[][] fArray2 = localFeatureData.wpW2;
        FeatureVector[] featureVectorArray = localFeatureData.wordFvs;
        int n2 = featureVectorArray.length;
        FeatureVector featureVector = new FeatureVector();
        for (int i = 1; i < n2; ++i) {
            int n3 = nArray[i];
            int n4 = nArray[n3];
            if (n4 == -1) continue;
            int n5 = n3 > i ? 1 : 2;
            int n6 = n4 > n3 ? 1 : 2;
            int n7 = nArray2[i];
            int n8 = nArray3[i];
            int n9 = nArray2[n3];
            int n10 = nArray3[n3];
            if (n7 == n8 && n9 == n10) continue;
            float f = fArray[n3][n];
            float f2 = fArray2[i][n];
            featureVector.addEntries(featureVectorArray[n4], f * f2 * (this.X2L[n9][n] + this.X2L[n6 * this.T + n9][n]) * (this.Y2L[n7][n] + this.Y2L[n5 * this.T + n7][n]) - f * f2 * (this.X2L[n10][n] + this.X2L[n6 * this.T + n10][n]) * (this.Y2L[n8][n] + this.Y2L[n5 * this.T + n8][n]));
        }
        return featureVector;
    }

    private FeatureVector getdV2L(int n, LocalFeatureData localFeatureData, int[] nArray, int[] nArray2, int[] nArray3) {
        float[][] fArray = localFeatureData.wpU2;
        float[][] fArray2 = localFeatureData.wpW2;
        FeatureVector[] featureVectorArray = localFeatureData.wordFvs;
        int n2 = featureVectorArray.length;
        FeatureVector featureVector = new FeatureVector();
        for (int i = 1; i < n2; ++i) {
            int n3 = nArray[i];
            int n4 = nArray[n3];
            if (n4 == -1) continue;
            int n5 = n3 > i ? 1 : 2;
            int n6 = n4 > n3 ? 1 : 2;
            int n7 = nArray2[i];
            int n8 = nArray3[i];
            int n9 = nArray2[n3];
            int n10 = nArray3[n3];
            if (n7 == n8 && n9 == n10) continue;
            float f = fArray[n4][n];
            float f2 = fArray2[i][n];
            featureVector.addEntries(featureVectorArray[n3], f * f2 * (this.X2L[n9][n] + this.X2L[n6 * this.T + n9][n]) * (this.Y2L[n7][n] + this.Y2L[n5 * this.T + n7][n]) - f * f2 * (this.X2L[n10][n] + this.X2L[n6 * this.T + n10][n]) * (this.Y2L[n8][n] + this.Y2L[n5 * this.T + n8][n]));
        }
        return featureVector;
    }

    private FeatureVector getdW2L(int n, LocalFeatureData localFeatureData, int[] nArray, int[] nArray2, int[] nArray3) {
        float[][] fArray = localFeatureData.wpU2;
        float[][] fArray2 = localFeatureData.wpV2;
        FeatureVector[] featureVectorArray = localFeatureData.wordFvs;
        int n2 = featureVectorArray.length;
        FeatureVector featureVector = new FeatureVector();
        for (int i = 1; i < n2; ++i) {
            int n3 = nArray[i];
            int n4 = nArray[n3];
            if (n4 == -1) continue;
            int n5 = n3 > i ? 1 : 2;
            int n6 = n4 > n3 ? 1 : 2;
            int n7 = nArray2[i];
            int n8 = nArray3[i];
            int n9 = nArray2[n3];
            int n10 = nArray3[n3];
            if (n7 == n8 && n9 == n10) continue;
            float f = fArray[n4][n];
            float f2 = fArray2[n3][n];
            featureVector.addEntries(featureVectorArray[i], f * f2 * (this.X2L[n9][n] + this.X2L[n6 * this.T + n9][n]) * (this.Y2L[n7][n] + this.Y2L[n5 * this.T + n7][n]) - f * f2 * (this.X2L[n10][n] + this.X2L[n6 * this.T + n10][n]) * (this.Y2L[n8][n] + this.Y2L[n5 * this.T + n8][n]));
        }
        return featureVector;
    }

    private FeatureVector getdX2L(int n, LocalFeatureData localFeatureData, int[] nArray, int[] nArray2, int[] nArray3) {
        int n2;
        float[][] fArray = localFeatureData.wpU2;
        float[][] fArray2 = localFeatureData.wpV2;
        float[][] fArray3 = localFeatureData.wpW2;
        FeatureVector[] featureVectorArray = localFeatureData.wordFvs;
        int n3 = featureVectorArray.length;
        float[] fArray4 = new float[this.DL];
        for (int i = 1; i < n3; ++i) {
            n2 = nArray[i];
            int n4 = nArray[n2];
            if (n4 == -1) continue;
            int n5 = n2 > i ? 1 : 2;
            int n6 = n4 > n2 ? 1 : 2;
            int n7 = nArray2[i];
            int n8 = nArray3[i];
            int n9 = nArray2[n2];
            int n10 = nArray3[n2];
            if (n7 == n8 && n9 == n10) continue;
            float f = fArray[n4][n];
            float f2 = fArray2[n2][n];
            float f3 = fArray3[i][n];
            float f4 = f * f2 * f3 * (this.Y2L[n7][n] + this.Y2L[n5 * this.T + n7][n]);
            float f5 = f * f2 * f3 * (this.Y2L[n8][n] + this.Y2L[n5 * this.T + n8][n]);
            int n11 = n9;
            fArray4[n11] = fArray4[n11] + f4;
            int n12 = n6 * this.T + n9;
            fArray4[n12] = fArray4[n12] + f4;
            int n13 = n10;
            fArray4[n13] = fArray4[n13] - f5;
            int n14 = n6 * this.T + n10;
            fArray4[n14] = fArray4[n14] - f5;
        }
        FeatureVector featureVector = new FeatureVector();
        for (n2 = 0; n2 < this.DL; ++n2) {
            featureVector.addEntry(n2, fArray4[n2]);
        }
        return featureVector;
    }

    private FeatureVector getdY2L(int n, LocalFeatureData localFeatureData, int[] nArray, int[] nArray2, int[] nArray3) {
        int n2;
        float[][] fArray = localFeatureData.wpU2;
        float[][] fArray2 = localFeatureData.wpV2;
        float[][] fArray3 = localFeatureData.wpW2;
        FeatureVector[] featureVectorArray = localFeatureData.wordFvs;
        int n3 = featureVectorArray.length;
        float[] fArray4 = new float[this.DL];
        for (int i = 1; i < n3; ++i) {
            n2 = nArray[i];
            int n4 = nArray[n2];
            if (n4 == -1) continue;
            int n5 = n2 > i ? 1 : 2;
            int n6 = n4 > n2 ? 1 : 2;
            int n7 = nArray2[i];
            int n8 = nArray3[i];
            int n9 = nArray2[n2];
            int n10 = nArray3[n2];
            if (n7 == n8 && n9 == n10) continue;
            float f = fArray[n4][n];
            float f2 = fArray2[n2][n];
            float f3 = fArray3[i][n];
            float f4 = f * f2 * f3 * (this.X2L[n9][n] + this.X2L[n6 * this.T + n9][n]);
            float f5 = f * f2 * f3 * (this.X2L[n10][n] + this.X2L[n6 * this.T + n10][n]);
            int n11 = n7;
            fArray4[n11] = fArray4[n11] + f4;
            int n12 = n5 * this.T + n7;
            fArray4[n12] = fArray4[n12] + f4;
            int n13 = n8;
            fArray4[n13] = fArray4[n13] - f5;
            int n14 = n5 * this.T + n8;
            fArray4[n14] = fArray4[n14] - f5;
        }
        FeatureVector featureVector = new FeatureVector();
        for (n2 = 0; n2 < this.DL; ++n2) {
            featureVector.addEntry(n2, fArray4[n2]);
        }
        return featureVector;
    }
}

