/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.tensorflow.sentencepiece;

import com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceException;
import com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceJNI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SentencePieceProcessor
implements AutoCloseable {
    private final long rawPtr = SentencePieceJNI.sppCtor();

    @Override
    public void close() {
        SentencePieceJNI.sppDtor(this.rawPtr);
    }

    public void load(String string) throws SentencePieceException {
        SentencePieceJNI.sppLoad(this.rawPtr, string);
    }

    public void loadOrDie(String string) {
        SentencePieceJNI.sppLoadOrDie(this.rawPtr, string);
    }

    public void loadFromSerializedProto(byte[] byArray) throws SentencePieceException {
        SentencePieceJNI.sppLoadFromSerializedProto(this.rawPtr, byArray);
    }

    public void setEncodeExtraOptions(String string) throws SentencePieceException {
        SentencePieceJNI.sppSetEncodeExtraOptions(this.rawPtr, string);
    }

    public void setDecodeExtraOptions(String string) throws SentencePieceException {
        SentencePieceJNI.sppSetDecodeExtraOptions(this.rawPtr, string);
    }

    public void setVocabulary(List<String> list) throws SentencePieceException {
        String[] stringArray = list.toArray(new String[0]);
        SentencePieceJNI.sppSetVocabulary(this.rawPtr, stringArray);
    }

    public void resetVocabulary() throws SentencePieceException {
        SentencePieceJNI.sppResetVocabulary(this.rawPtr);
    }

    public void loadVocabulary(String string, int n) throws SentencePieceException {
        SentencePieceJNI.sppLoadVocabulary(this.rawPtr, string, n);
    }

    public List<String> encodeAsPieces(String string) throws SentencePieceException {
        String[] stringArray = SentencePieceJNI.sppEncodeAsPieces(this.rawPtr, string);
        return Arrays.asList(stringArray);
    }

    public int[] encodeAsIds(String string) throws SentencePieceException {
        return SentencePieceJNI.sppEncodeAsIds(this.rawPtr, string);
    }

    public String decodePieces(List<String> list) throws SentencePieceException {
        String[] stringArray = list.toArray(new String[0]);
        return SentencePieceJNI.sppDecodePieces(this.rawPtr, stringArray);
    }

    public String decodeIds(int ... nArray) throws SentencePieceException {
        return SentencePieceJNI.sppDecodeIds(this.rawPtr, nArray);
    }

    public List<List<String>> nbestEncodeAsPieces(String string, int n) throws SentencePieceException {
        String[][] stringArray = SentencePieceJNI.sppNBestEncodeAsPieces(this.rawPtr, string, n);
        return Arrays.stream(stringArray).map(Arrays::asList).collect(Collectors.toList());
    }

    public int[][] nbestEncodeAsIds(String string, int n) throws SentencePieceException {
        return SentencePieceJNI.sppNBestEncodeAsIds(this.rawPtr, string, n);
    }

    public List<String> sampleEncodeAsPieces(String string, int n, float f) throws SentencePieceException {
        String[] stringArray = SentencePieceJNI.sppSampleEncodeAsPieces(this.rawPtr, string, n, f);
        return Arrays.asList(stringArray);
    }

    public int[] sampleEncodeAsIds(String string, int n, float f) throws SentencePieceException {
        return SentencePieceJNI.sppSampleEncodeAsIds(this.rawPtr, string, n, f);
    }

    public byte[] encodeAsSerializedProto(String string) {
        return SentencePieceJNI.sppEncodeAsSerializedProto(this.rawPtr, string);
    }

    public byte[] sampleEncodeAsSerializedProto(String string, int n, float f) {
        return SentencePieceJNI.sppSampleEncodeAsSerializedProto(this.rawPtr, string, n, f);
    }

    public byte[] nbestEncodeAsSerializedProto(String string, int n) {
        return SentencePieceJNI.sppNBestEncodeAsSerializedProto(this.rawPtr, string, n);
    }

    public byte[] decodePiecesAsSerializedProto(List<String> list) {
        String[] stringArray = list.toArray(new String[0]);
        return SentencePieceJNI.sppDecodePiecesAsSerializedProto(this.rawPtr, stringArray);
    }

    public byte[] decodeIdsAsSerializedProto(int ... nArray) {
        return SentencePieceJNI.sppDecodeIdsAsSerializedProto(this.rawPtr, nArray);
    }

    public int getPieceSize() {
        return SentencePieceJNI.sppGetPieceSize(this.rawPtr);
    }

    public int pieceToId(String string) {
        return SentencePieceJNI.sppPieceToId(this.rawPtr, string);
    }

    public String idToPiece(int n) {
        return SentencePieceJNI.sppIdToPiece(this.rawPtr, n);
    }

    public float getScore(int n) {
        return SentencePieceJNI.sppGetScore(this.rawPtr, n);
    }

    public boolean isUnknown(int n) {
        return SentencePieceJNI.sppIsUnknown(this.rawPtr, n);
    }

    public boolean isControl(int n) {
        return SentencePieceJNI.sppIsControl(this.rawPtr, n);
    }

    public boolean isUnused(int n) {
        return SentencePieceJNI.sppIsUnused(this.rawPtr, n);
    }

    public int unkId() {
        return SentencePieceJNI.sppUnkId(this.rawPtr);
    }

    public int bosId() {
        return SentencePieceJNI.sppBosId(this.rawPtr);
    }

    public int eosId() {
        return SentencePieceJNI.sppEosId(this.rawPtr);
    }

    public int padId() {
        return SentencePieceJNI.sppPadId(this.rawPtr);
    }
}

