/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.tensorflow.sentencepiece;

import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.lang.SystemUtils;
import org.apache.spark.SparkFiles$;
import org.apache.spark.sql.SparkSession;
import org.tensorflow.TensorFlow;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;

public final class LoadSentencepiece$ {
    public static LoadSentencepiece$ MODULE$;
    private String lib;
    private Option<String> sentencepiecePaths;
    private transient boolean loadedToCluster;
    private transient boolean loadedToTensorflow;
    private volatile byte bitmap$0;

    static {
        new LoadSentencepiece$();
    }

    public boolean loadedToCluster() {
        return this.loadedToCluster;
    }

    public void loadedToCluster_$eq(boolean x$1) {
        this.loadedToCluster = x$1;
    }

    public boolean loadedToTensorflow() {
        return this.loadedToTensorflow;
    }

    public void loadedToTensorflow_$eq(boolean x$1) {
        this.loadedToTensorflow = x$1;
    }

    private String lib$lzycompute() {
        LoadSentencepiece$ loadSentencepiece$ = this;
        synchronized (loadSentencepiece$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.lib = "_sentencepiece_tokenizer";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.lib;
    }

    private String lib() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.lib$lzycompute() : this.lib;
    }

    private String resourcePath(String os, String lib) {
        return new StringBuilder(12).append("sp-process/").append(os).append("/").append(lib).toString();
    }

    private Option<String> sentencepiecePaths$lzycompute() {
        LoadSentencepiece$ loadSentencepiece$ = this;
        synchronized (loadSentencepiece$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Some some;
                if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
                    String libWithExtension = new StringBuilder(6).append(this.lib()).append(".dylib").toString();
                    some = new Some((Object)this.resourcePath("mac", libWithExtension));
                } else if (SystemUtils.IS_OS_WINDOWS) {
                    String libWithExtension = new StringBuilder(3).append(this.lib()).append(".so").toString();
                    some = new Some((Object)this.resourcePath("win", libWithExtension));
                } else {
                    String libWithExtension = new StringBuilder(3).append(this.lib()).append(".so").toString();
                    some = new Some((Object)this.resourcePath("linux", libWithExtension));
                }
                this.sentencepiecePaths = some;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sentencepiecePaths;
    }

    public Option<String> sentencepiecePaths() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sentencepiecePaths$lzycompute() : this.sentencepiecePaths;
    }

    private String getFileName(String path) {
        return new StringBuilder(15).append("sparknlp_sp_lib").append(new StringOps(Predef$.MODULE$.augmentString(new File(path).getName())).take(5)).toString();
    }

    private File copyResourceToTmp(String path) {
        InputStream stream = ResourceHelper$.MODULE$.getResourceStream(path);
        String tmpFolder = System.getProperty("java.io.tmpdir");
        File tmp = Paths.get(tmpFolder, this.getFileName(path)).toFile();
        BufferedOutputStream target = new BufferedOutputStream(new FileOutputStream(tmp));
        byte[] buffer = new byte[8192];
        int read = stream.read(buffer);
        while (read > 0) {
            target.write(buffer, 0, read);
            read = stream.read(buffer);
        }
        stream.close();
        target.close();
        return tmp;
    }

    public void loadSPToCluster(SparkSession spark) {
        block0: {
            Predef$.MODULE$.require(!SystemUtils.IS_OS_WINDOWS, (Function0 & Serializable & scala.Serializable)() -> "UniversalSentenceEncoder multi-lingual models are not supported on Windows.");
            if (this.loadedToCluster() || !this.sentencepiecePaths().isDefined()) break block0;
            this.loadedToCluster_$eq(true);
            spark.sparkContext().addFile(this.copyResourceToTmp((String)this.sentencepiecePaths().get()).getPath());
        }
    }

    public void loadSPToTensorflow() {
        block1: {
            Predef$.MODULE$.require(!SystemUtils.IS_OS_WINDOWS, (Function0 & Serializable & scala.Serializable)() -> "UniversalSentenceEncoder multi-lingual models are not supported on Windows.");
            if (this.loadedToTensorflow() || !this.sentencepiecePaths().isDefined()) break block1;
            this.loadedToTensorflow_$eq(true);
            String fp = SparkFiles$.MODULE$.get(this.getFileName((String)this.sentencepiecePaths().get()));
            if (new File(fp).exists()) {
                TensorFlow.loadLibrary((String)fp);
            }
        }
    }

    public void loadSPToTensorflowLocally() {
        block1: {
            Predef$.MODULE$.require(!SystemUtils.IS_OS_WINDOWS, (Function0 & Serializable & scala.Serializable)() -> "UniversalSentenceEncoder multi-lingual models are not supported on Windows.");
            if (this.loadedToTensorflow() || !this.sentencepiecePaths().isDefined()) break block1;
            this.loadedToTensorflow_$eq(true);
            String path = (String)this.sentencepiecePaths().get();
            URI uri = new URI(new StringOps(Predef$.MODULE$.augmentString(path)).replaceAllLiterally("\\", "/"));
            InputStream inputStream = ResourceHelper$.MODULE$.getResourceStream(uri.toString());
            String tmpFolder = ((Object)Files.createTempDirectory(new StringBuilder(14).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append("_sentencepiece").toString(), new FileAttribute[0]).toAbsolutePath()).toString();
            File spProcFile = new File(tmpFolder, this.getFileName((String)this.sentencepiecePaths().get()));
            Files.copy(inputStream, spProcFile.toPath(), new CopyOption[0]);
            String fp = spProcFile.toString();
            if (new File(fp).exists()) {
                TensorFlow.loadLibrary((String)fp);
            }
        }
    }

    private LoadSentencepiece$() {
        MODULE$ = this;
        this.loadedToCluster = false;
        this.loadedToTensorflow = false;
    }
}

