/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.tensorflow;

import com.johnsnowlabs.ml.tensorflow.TensorResources;
import com.johnsnowlabs.ml.tensorflow.TensorResources$;
import com.johnsnowlabs.ml.tensorflow.TensorflowRoBertaClassification$;
import com.johnsnowlabs.ml.tensorflow.TensorflowWrapper;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureConstants$AttentionMask$;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureConstants$InputIds$;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureConstants$LogitsOutput$;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureManager$;
import com.johnsnowlabs.nlp.Annotation;
import com.johnsnowlabs.nlp.Annotation$;
import com.johnsnowlabs.nlp.AnnotatorType$;
import com.johnsnowlabs.nlp.annotators.common.IndexedToken;
import com.johnsnowlabs.nlp.annotators.common.TokenPiece;
import com.johnsnowlabs.nlp.annotators.common.TokenizedSentence;
import com.johnsnowlabs.nlp.annotators.common.WordpieceTokenizedSentence;
import java.io.Serializable;
import org.tensorflow.Session;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\f\u0018\u0001\u0001B\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005Y!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!A!\u0002\u0013\u0011\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011\u0005\u0003!\u0011!Q\u0001\n\tC\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006'\u0002!\t\u0001\u0016\u0005\b;\u0002\u0011\r\u0011\"\u0001_\u0011\u0019y\u0006\u0001)A\u0005%\")\u0001\r\u0001C\u0001C\")a\u0010\u0001C\u0001\u007f\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\r\u0001\u0011\u0005\u00111D\u0004\n\u0003\u007f9\u0012\u0011!E\u0001\u0003\u00032\u0001BF\f\u0002\u0002#\u0005\u00111\t\u0005\u0007'F!\t!!\u0012\t\u0013\u0005\u001d\u0013#%A\u0005\u0002\u0005%\u0003\"CA0#E\u0005I\u0011AA1\u0011%\t)'EA\u0001\n\u0013\t9GA\u0010UK:\u001cxN\u001d4m_^\u0014vNQ3si\u0006\u001cE.Y:tS\u001aL7-\u0019;j_:T!\u0001G\r\u0002\u0015Q,gn]8sM2|wO\u0003\u0002\u001b7\u0005\u0011Q\u000e\u001c\u0006\u00039u\tAB[8i]Ntwn\u001e7bENT\u0011AH\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002#Q%\u0011\u0011f\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0012i\u0016t7o\u001c:gY><xK]1qa\u0016\u0014X#\u0001\u0017\u0011\u00055rS\"A\f\n\u0005=:\"!\u0005+f]N|'O\u001a7po^\u0013\u0018\r\u001d9fe\u0006\u0011B/\u001a8t_J4Gn\\<Xe\u0006\u0004\b/\u001a:!\u0003Q\u0019XM\u001c;f]\u000e,7\u000b^1siR{7.\u001a8JIB\u0011!eM\u0005\u0003i\r\u00121!\u00138u\u0003I\u0019XM\u001c;f]\u000e,WI\u001c3U_.,g.\u00133\u0002\u0015A\fG\rV8lK:LE-\u0001\td_:4\u0017n\u001a)s_R|')\u001f;fgB\u0019!%O\u001e\n\u0005i\u001a#AB(qi&|g\u000eE\u0002#yyJ!!P\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\tz\u0014B\u0001!$\u0005\u0011\u0011\u0015\u0010^3\u0002\tQ\fwm\u001d\t\u0005\u0007*k%G\u0004\u0002E\u0011B\u0011QiI\u0007\u0002\r*\u0011qiH\u0001\u0007yI|w\u000e\u001e \n\u0005%\u001b\u0013A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n\u0019Q*\u00199\u000b\u0005%\u001b\u0003CA\"O\u0013\tyEJ\u0001\u0004TiJLgnZ\u0001\u000bg&<g.\u0019;ve\u0016\u001c\bc\u0001\u0012:%B!1IS'N\u0003\u0019a\u0014N\\5u}QAQKV,Y3j[F\f\u0005\u0002.\u0001!)!&\u0003a\u0001Y!)\u0011'\u0003a\u0001e!)Q'\u0003a\u0001e!)a'\u0003a\u0001e!9q'\u0003I\u0001\u0002\u0004A\u0004\"B!\n\u0001\u0004\u0011\u0005b\u0002)\n!\u0003\u0005\r!U\u0001\u0015?R4'k\u001c\"feR\f7+[4oCR,(/Z:\u0016\u0003I\u000bQc\u0018;g%>\u0014UM\u001d;b'&<g.\u0019;ve\u0016\u001c\b%\u0001\u0004f]\u000e|G-\u001a\u000b\u0004E2d\bcA2iW:\u0011AM\u001a\b\u0003\u000b\u0016L\u0011\u0001J\u0005\u0003O\u000e\nq\u0001]1dW\u0006<W-\u0003\u0002jU\n\u00191+Z9\u000b\u0005\u001d\u001c\u0003c\u0001\u0012=e!)Q\u000e\u0004a\u0001]\u0006I1/\u001a8uK:\u001cWm\u001d\t\u0004G\"|\u0007\u0003\u0002\u0012qeJJ!!]\u0012\u0003\rQ+\b\u000f\\33!\t\u0019(0D\u0001u\u0015\t)h/\u0001\u0004d_6lwN\u001c\u0006\u0003ob\f!\"\u00198o_R\fGo\u001c:t\u0015\tI8$A\u0002oYBL!a\u001f;\u00035]{'\u000f\u001a9jK\u000e,Gk\\6f]&TX\rZ*f]R,gnY3\t\u000bud\u0001\u0019\u0001\u001a\u0002#5\f\u0007pU3rk\u0016t7-\u001a'f]\u001e$\b.\u0001\tdC2\u001cG.^1uKN{g\r^7bqR!\u0011\u0011AA\u0005!\u0011\u0011C(a\u0001\u0011\u0007\t\n)!C\u0002\u0002\b\r\u0012QA\u00127pCRDq!a\u0003\u000e\u0001\u0004\t\t!\u0001\u0004tG>\u0014Xm]\u0001\u0004i\u0006<G\u0003BA\t\u0003+\u0001Ba\u00195\u0002\u0014A!!\u0005PA\u0001\u0011\u0019\t9B\u0004a\u0001E\u0006)!-\u0019;dQ\u00069\u0001O]3eS\u000e$HCCA\u000f\u0003O\tY#a\u000e\u0002<A!1\r[A\u0010!\u0011\t\t#a\t\u000e\u0003aL1!!\ny\u0005)\teN\\8uCRLwN\u001c\u0005\u0007[>\u0001\r!!\u000b\u0011\u0007\rD'\u000fC\u0004\u0002.=\u0001\r!a\f\u0002-=\u0014\u0018nZ5oC2$vn[3o'\u0016tG/\u001a8dKN\u0004Ba\u00195\u00022A\u00191/a\r\n\u0007\u0005UBOA\tU_.,g.\u001b>fIN+g\u000e^3oG\u0016Da!!\u000f\u0010\u0001\u0004\u0011\u0014!\u00032bi\u000eD7+\u001b>f\u0011\u0019\tid\u0004a\u0001e\u0005\tR.\u0019=TK:$XM\\2f\u0019\u0016tw\r\u001e5\u0002?Q+gn]8sM2|wOU8CKJ$\u0018m\u00117bgNLg-[2bi&|g\u000e\u0005\u0002.#M\u0019\u0011#I\u0014\u0015\u0005\u0005\u0005\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002L)\u001a\u0001(!\u0014,\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0017$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\n\u0019FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TCAA2U\r\t\u0016QJ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001\u00027b]\u001eT!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0004PE*,7\r\u001e")
public class TensorflowRoBertaClassification
implements scala.Serializable {
    private final TensorflowWrapper tensorflowWrapper;
    private final int sentenceStartTokenId;
    private final int sentenceEndTokenId;
    private final int padTokenId;
    private final Option<byte[]> configProtoBytes;
    private final scala.collection.immutable.Map<String, Object> tags;
    private final scala.collection.immutable.Map<String, String> _tfRoBertaSignatures;

    public static Option<scala.collection.immutable.Map<String, String>> $lessinit$greater$default$7() {
        return TensorflowRoBertaClassification$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<byte[]> $lessinit$greater$default$5() {
        return TensorflowRoBertaClassification$.MODULE$.$lessinit$greater$default$5();
    }

    public TensorflowWrapper tensorflowWrapper() {
        return this.tensorflowWrapper;
    }

    public scala.collection.immutable.Map<String, String> _tfRoBertaSignatures() {
        return this._tfRoBertaSignatures;
    }

    public Seq<int[]> encode(Seq<Tuple2<WordpieceTokenizedSentence, Object>> sentences, int maxSequenceLength) {
        int maxSentenceLength = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{maxSequenceLength - 2, BoxesRunTime.unboxToInt((Object)((TraversableOnce)sentences.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)TensorflowRoBertaClassification.$anonfun$encode$1(x0$1)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$))})).min((Ordering)Ordering.Int$.MODULE$));
        return (Seq)sentences.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            WordpieceTokenizedSentence wpTokSentence = (WordpieceTokenizedSentence)tuple2._1();
            int[] tokenPieceIds = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])wpTokSentence.tokens())).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)t.pieceId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            int[] padding = (int[])Array$.MODULE$.fill(maxSentenceLength - tokenPieceIds.length, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.padTokenId, ClassTag$.MODULE$.Int());
            int[] nArray = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{$this.sentenceStartTokenId})).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(tokenPieceIds)).take(maxSentenceLength))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{$this.sentenceEndTokenId})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(padding)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            return nArray;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public float[] calcluateSoftmax(float[] scores) {
        double[] exp = (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scores)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp((double)x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(exp)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x / BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(exp)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$1 -> (float)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
    }

    public Seq<float[][]> tag(Seq<int[]> batch) {
        TensorResources tensors = new TensorResources();
        int maxSentenceLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)encodedSentence -> BoxesRunTime.boxToInteger((int)TensorflowRoBertaClassification.$anonfun$tag$1(encodedSentence)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int batchLength = batch.length();
        IntDataBuffer tokenBuffers = tensors.createIntBuffer(batchLength * maxSentenceLength);
        IntDataBuffer maskBuffers = tensors.createIntBuffer(batchLength * maxSentenceLength);
        long[] shape = new long[]{batch.length(), maxSentenceLength};
        ((IterableLike)batch.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int[] sentence = (int[])tuple2._1();
            int idx = tuple2._2$mcI$sp();
            int offset = idx * maxSentenceLength;
            tokenBuffers.offset((long)offset).write(sentence);
            IntDataBuffer intDataBuffer = maskBuffers.offset((long)offset).write((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sentence)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x == $this.padTokenId ? 0 : 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            return intDataBuffer;
        });
        Session.Runner runner = this.tensorflowWrapper().getTFHubSession(this.configProtoBytes, false, this.tensorflowWrapper().getTFHubSession$default$3(), this.tensorflowWrapper().getTFHubSession$default$4()).runner();
        Tensor tokenTensors = tensors.createIntBufferTensor(shape, tokenBuffers);
        Tensor maskTensors = tensors.createIntBufferTensor(shape, maskBuffers);
        runner.feed((String)this._tfRoBertaSignatures().getOrElse((Object)ModelSignatureConstants$InputIds$.MODULE$.key(), (Function0 & Serializable & scala.Serializable)() -> "missing_input_id_key"), tokenTensors).feed((String)this._tfRoBertaSignatures().getOrElse((Object)ModelSignatureConstants$AttentionMask$.MODULE$.key(), (Function0 & Serializable & scala.Serializable)() -> "missing_input_mask_key"), maskTensors).fetch((String)this._tfRoBertaSignatures().getOrElse((Object)ModelSignatureConstants$LogitsOutput$.MODULE$.key(), (Function0 & Serializable & scala.Serializable)() -> "missing_logits_key"));
        Buffer outs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(runner.run()).asScala();
        float[] rawScores = TensorResources$.MODULE$.extractFloats((Tensor)outs.head(), TensorResources$.MODULE$.extractFloats$default$2());
        outs.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        tensors.clearSession((Buffer<Tensor>)outs);
        tensors.clearTensors();
        int dim = rawScores.length / (batchLength * maxSentenceLength);
        float[][][] batchScores = (float[][][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(rawScores)).grouped(dim).map((Function1 & Serializable & scala.Serializable)scores -> this.calcluateSoftmax((float[])scores)).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))))).grouped(maxSentenceLength).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))));
        return Predef$.MODULE$.wrapRefArray((Object[])batchScores);
    }

    public Seq<Annotation> predict(Seq<WordpieceTokenizedSentence> sentences, Seq<TokenizedSentence> originalTokenSentences, int batchSize, int maxSentenceLength) {
        return ((IterableLike)sentences.zipWithIndex(Seq$.MODULE$.canBuildFrom())).grouped(batchSize).flatMap((Function1 & Serializable & scala.Serializable)batch -> {
            Seq<int[]> encoded = this.encode((Seq<Tuple2<WordpieceTokenizedSentence, Object>>)batch, maxSentenceLength);
            Seq<float[][]> logits = this.tag(encoded);
            return (Seq)((TraversableLike)batch.zip(logits, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 sentence = (Tuple2)tuple2._1();
                float[][] tokenVectors = (float[][])tuple2._2();
                int tokenLength = ((WordpieceTokenizedSentence)sentence._1()).tokens().length;
                float[][] tokenLogits = (float[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokenVectors)).slice(1, tokenLength + 1);
                Annotation[] labelsWithScores = (Annotation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((WordpieceTokenizedSentence)sentence._1()).tokens())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tokenLogits), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TokenPiece token2 = (TokenPiece)tuple2._1();
                    float[] scores = (float[])tuple2._2();
                    Iterable iterable = Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TokenizedSentence)originalTokenSentences.apply(sentence._2$mcI$sp())).indexedTokens())).find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TensorflowRoBertaClassification.$anonfun$predict$4(token2, p))).map((Function1 & Serializable & scala.Serializable)token -> {
                        String label = (String)$this.tags.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TensorflowRoBertaClassification.$anonfun$predict$6(scores, x$3))).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NA");
                        Tuple2[] meta = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scores)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.tags.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TensorflowRoBertaClassification.$anonfun$predict$11(x, x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._1()).toString()), (Object)x._1().toString())})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                        return new Annotation(AnnotatorType$.MODULE$.NAMED_ENTITY(), token.begin(), token.end(), label, (Map<String, String>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sentence"), (Object)((Object)BoxesRunTime.boxToInteger((int)sentence._2$mcI$sp())).toString())}))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])meta))), Annotation$.MODULE$.apply$default$6());
                    }));
                    return iterable;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Annotation.class)));
                Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labelsWithScores)).toSeq();
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
        }).toSeq();
    }

    public static final /* synthetic */ int $anonfun$encode$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        WordpieceTokenizedSentence wpTokSentence = (WordpieceTokenizedSentence)tuple2._1();
        int n = wpTokSentence.tokens().length;
        return n;
    }

    public static final /* synthetic */ int $anonfun$tag$1(int[] encodedSentence) {
        return encodedSentence.length;
    }

    public static final /* synthetic */ boolean $anonfun$predict$4(TokenPiece token$1, IndexedToken p) {
        return p.begin() == token$1.begin();
    }

    public static final /* synthetic */ float $anonfun$predict$7(Tuple2 x$4) {
        return BoxesRunTime.unboxToFloat((Object)x$4._1());
    }

    public static final /* synthetic */ boolean $anonfun$predict$6(float[] scores$1, Tuple2 x$3) {
        return x$3._2$mcI$sp() == ((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scores$1)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).maxBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToFloat((float)TensorflowRoBertaClassification.$anonfun$predict$7(x$4)), (Ordering)Ordering.Float$.MODULE$))._2$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$predict$11(Tuple2 x$8, Tuple2 x$6) {
        return x$6._2$mcI$sp() == x$8._2$mcI$sp();
    }

    public TensorflowRoBertaClassification(TensorflowWrapper tensorflowWrapper, int sentenceStartTokenId, int sentenceEndTokenId, int padTokenId, Option<byte[]> configProtoBytes, scala.collection.immutable.Map<String, Object> tags, Option<scala.collection.immutable.Map<String, String>> signatures) {
        this.tensorflowWrapper = tensorflowWrapper;
        this.sentenceStartTokenId = sentenceStartTokenId;
        this.sentenceEndTokenId = sentenceEndTokenId;
        this.padTokenId = padTokenId;
        this.configProtoBytes = configProtoBytes;
        this.tags = tags;
        this._tfRoBertaSignatures = (scala.collection.immutable.Map)signatures.getOrElse((Function0 & Serializable & scala.Serializable)() -> ModelSignatureManager$.MODULE$.apply(ModelSignatureManager$.MODULE$.apply$default$1(), ModelSignatureManager$.MODULE$.apply$default$2(), ModelSignatureManager$.MODULE$.apply$default$3(), ModelSignatureManager$.MODULE$.apply$default$4(), ModelSignatureManager$.MODULE$.apply$default$5(), ModelSignatureManager$.MODULE$.apply$default$6()));
    }
}

