/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.tensorflow;

import com.johnsnowlabs.ml.tensorflow.TensorResources;
import com.johnsnowlabs.ml.tensorflow.TensorResources$;
import com.johnsnowlabs.ml.tensorflow.TensorflowBertClassification$;
import com.johnsnowlabs.ml.tensorflow.TensorflowWrapper;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureConstants$AttentionMask$;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureConstants$InputIds$;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureConstants$LogitsOutput$;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureConstants$TokenTypeIds$;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureManager$;
import com.johnsnowlabs.nlp.Annotation;
import com.johnsnowlabs.nlp.Annotation$;
import com.johnsnowlabs.nlp.AnnotatorType$;
import com.johnsnowlabs.nlp.annotators.common.IndexedToken;
import com.johnsnowlabs.nlp.annotators.common.TokenPiece;
import com.johnsnowlabs.nlp.annotators.common.TokenizedSentence;
import com.johnsnowlabs.nlp.annotators.common.WordpieceTokenizedSentence;
import java.io.Serializable;
import org.tensorflow.Session;
import org.tensorflow.Tensor;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u000b\u0017\u0001}A\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005W!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00032\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u00119\u0003!\u0011!Q\u0001\n=CQ!\u0015\u0001\u0005\u0002ICqA\u0017\u0001C\u0002\u0013\u00051\f\u0003\u0004]\u0001\u0001\u0006I\u0001\u0015\u0005\u0006;\u0002!\tA\u0018\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+9\u0011\"!\u000f\u0017\u0003\u0003E\t!a\u000f\u0007\u0011U1\u0012\u0011!E\u0001\u0003{Aa!\u0015\t\u0005\u0002\u0005}\u0002\"CA!!E\u0005I\u0011AA\"\u0011%\tI\u0006EI\u0001\n\u0003\tY\u0006C\u0005\u0002`A\t\t\u0011\"\u0003\u0002b\taB+\u001a8t_J4Gn\\<CKJ$8\t\\1tg&4\u0017nY1uS>t'BA\f\u0019\u0003)!XM\\:pe\u001adwn\u001e\u0006\u00033i\t!!\u001c7\u000b\u0005ma\u0012\u0001\u00046pQ:\u001chn\\<mC\n\u001c(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003C\u001dJ!\u0001\u000b\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\u0002#Q,gn]8sM2|wo\u0016:baB,'/F\u0001,!\taS&D\u0001\u0017\u0013\tqcCA\tUK:\u001cxN\u001d4m_^<&/\u00199qKJ\f!\u0003^3og>\u0014h\r\\8x/J\f\u0007\u000f]3sA\u0005!2/\u001a8uK:\u001cWm\u0015;beR$vn[3o\u0013\u0012\u0004\"!\t\u001a\n\u0005M\u0012#aA%oi\u0006\u00112/\u001a8uK:\u001cW-\u00128e)>\\WM\\%e\u0003A\u0019wN\u001c4jOB\u0013x\u000e^8CsR,7\u000fE\u0002\"oeJ!\u0001\u000f\u0012\u0003\r=\u0003H/[8o!\r\t#\bP\u0005\u0003w\t\u0012Q!\u0011:sCf\u0004\"!I\u001f\n\u0005y\u0012#\u0001\u0002\"zi\u0016\fA\u0001^1hgB!\u0011\tS&2\u001d\t\u0011e\t\u0005\u0002DE5\tAI\u0003\u0002F=\u00051AH]8pizJ!a\u0012\u0012\u0002\rA\u0013X\rZ3g\u0013\tI%JA\u0002NCBT!a\u0012\u0012\u0011\u0005\u0005c\u0015BA'K\u0005\u0019\u0019FO]5oO\u0006Q1/[4oCR,(/Z:\u0011\u0007\u0005:\u0004\u000b\u0005\u0003B\u0011.[\u0015A\u0002\u001fj]&$h\bF\u0004T)V3v\u000bW-\u0011\u00051\u0002\u0001\"B\u0015\t\u0001\u0004Y\u0003\"\u0002\u0019\t\u0001\u0004\t\u0004\"\u0002\u001b\t\u0001\u0004\t\u0004bB\u001b\t!\u0003\u0005\rA\u000e\u0005\u0006\u007f!\u0001\r\u0001\u0011\u0005\b\u001d\"\u0001\n\u00111\u0001P\u0003EyFO\u001a\"feR\u001c\u0016n\u001a8biV\u0014Xm]\u000b\u0002!\u0006\u0011r\f\u001e4CKJ$8+[4oCR,(/Z:!\u0003\u0019)gnY8eKR\u0019q,[=\u0011\u0007\u0001,\u0007N\u0004\u0002bG:\u00111IY\u0005\u0002G%\u0011AMI\u0001\ba\u0006\u001c7.Y4f\u0013\t1wMA\u0002TKFT!\u0001\u001a\u0012\u0011\u0007\u0005R\u0014\u0007C\u0003k\u0017\u0001\u00071.A\u0005tK:$XM\\2fgB\u0019\u0001-\u001a7\u0011\t\u0005jw.M\u0005\u0003]\n\u0012a\u0001V;qY\u0016\u0014\u0004C\u00019x\u001b\u0005\t(B\u0001:t\u0003\u0019\u0019w.\\7p]*\u0011A/^\u0001\u000bC:tw\u000e^1u_J\u001c(B\u0001<\u001b\u0003\rqG\u000e]\u0005\u0003qF\u0014!dV8sIBLWmY3U_.,g.\u001b>fIN+g\u000e^3oG\u0016DQA_\u0006A\u0002E\n\u0011#\\1y'\u0016\fX/\u001a8dK2+gn\u001a;i\u0003A\u0019\u0017\r\\2mk\u0006$XmU8gi6\f\u0007\u0010F\u0002~\u0003\u0007\u00012!\t\u001e\u007f!\t\ts0C\u0002\u0002\u0002\t\u0012QA\u00127pCRDa!!\u0002\r\u0001\u0004i\u0018AB:d_J,7/A\u0002uC\u001e$B!a\u0003\u0002\u0010A!\u0001-ZA\u0007!\r\t#( \u0005\u0007\u0003#i\u0001\u0019A0\u0002\u000b\t\fGo\u00195\u0002\u000fA\u0014X\rZ5diRQ\u0011qCA\u0011\u0003K\t\t$!\u000e\u0011\t\u0001,\u0017\u0011\u0004\t\u0005\u00037\ti\"D\u0001v\u0013\r\ty\"\u001e\u0002\u000b\u0003:tw\u000e^1uS>t\u0007B\u00026\u000f\u0001\u0004\t\u0019\u0003E\u0002aK>Dq!a\n\u000f\u0001\u0004\tI#\u0001\fpe&<\u0017N\\1m)>\\WM\\*f]R,gnY3t!\u0011\u0001W-a\u000b\u0011\u0007A\fi#C\u0002\u00020E\u0014\u0011\u0003V8lK:L'0\u001a3TK:$XM\\2f\u0011\u0019\t\u0019D\u0004a\u0001c\u0005I!-\u0019;dQNK'0\u001a\u0005\u0007\u0003oq\u0001\u0019A\u0019\u0002#5\f\u0007pU3oi\u0016t7-\u001a'f]\u001e$\b.\u0001\u000fUK:\u001cxN\u001d4m_^\u0014UM\u001d;DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u0011\u00051\u00022c\u0001\t!MQ\u0011\u00111H\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0015#f\u0001\u001c\u0002H-\u0012\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003%)hn\u00195fG.,GMC\u0002\u0002T\t\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9&!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003;R3aTA$\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\u0004\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0005Y\u0006twM\u0003\u0002\u0002n\u0005!!.\u0019<b\u0013\u0011\t\t(a\u001a\u0003\r=\u0013'.Z2u\u0001")
public class TensorflowBertClassification
implements scala.Serializable {
    private final TensorflowWrapper tensorflowWrapper;
    private final int sentenceStartTokenId;
    private final int sentenceEndTokenId;
    private final Option<byte[]> configProtoBytes;
    private final scala.collection.immutable.Map<String, Object> tags;
    private final Option<scala.collection.immutable.Map<String, String>> signatures;
    private final scala.collection.immutable.Map<String, String> _tfBertSignatures;

    public static Option<scala.collection.immutable.Map<String, String>> $lessinit$greater$default$6() {
        return TensorflowBertClassification$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<byte[]> $lessinit$greater$default$4() {
        return TensorflowBertClassification$.MODULE$.$lessinit$greater$default$4();
    }

    public TensorflowWrapper tensorflowWrapper() {
        return this.tensorflowWrapper;
    }

    public scala.collection.immutable.Map<String, String> _tfBertSignatures() {
        return this._tfBertSignatures;
    }

    public Seq<int[]> encode(Seq<Tuple2<WordpieceTokenizedSentence, Object>> sentences, int maxSequenceLength) {
        int maxSentenceLength = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{maxSequenceLength - 2, BoxesRunTime.unboxToInt((Object)((TraversableOnce)sentences.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)TensorflowBertClassification.$anonfun$encode$1(x0$1)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$))})).min((Ordering)Ordering.Int$.MODULE$));
        return (Seq)sentences.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            WordpieceTokenizedSentence wpTokSentence = (WordpieceTokenizedSentence)tuple2._1();
            int[] tokenPieceIds = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])wpTokSentence.tokens())).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)t.pieceId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            int[] padding = (int[])Array$.MODULE$.fill(maxSentenceLength - tokenPieceIds.length, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
            int[] nArray = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{$this.sentenceStartTokenId})).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(tokenPieceIds)).take(maxSentenceLength))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{$this.sentenceEndTokenId})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(padding)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            return nArray;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public float[] calcluateSoftmax(float[] scores) {
        double[] exp = (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scores)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x -> package$.MODULE$.exp((double)x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(exp)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x / BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(exp)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$1 -> (float)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
    }

    public Seq<float[][]> tag(Seq<int[]> batch) {
        TensorResources tensors = new TensorResources();
        int maxSentenceLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)encodedSentence -> BoxesRunTime.boxToInteger((int)TensorflowBertClassification.$anonfun$tag$1(encodedSentence)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int batchLength = batch.length();
        IntDataBuffer tokenBuffers = tensors.createIntBuffer(batchLength * maxSentenceLength);
        IntDataBuffer maskBuffers = tensors.createIntBuffer(batchLength * maxSentenceLength);
        IntDataBuffer segmentBuffers = tensors.createIntBuffer(batchLength * maxSentenceLength);
        long[] shape = new long[]{batch.length(), maxSentenceLength};
        ((IterableLike)batch.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int[] sentence = (int[])tuple2._1();
            int idx = tuple2._2$mcI$sp();
            int offset = idx * maxSentenceLength;
            tokenBuffers.offset((long)offset).write(sentence);
            maskBuffers.offset((long)offset).write((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sentence)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> x == 0 ? 0 : 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            IntDataBuffer intDataBuffer = segmentBuffers.offset((long)offset).write((int[])Array$.MODULE$.fill(maxSentenceLength, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int()));
            return intDataBuffer;
        });
        Option<byte[]> x$1 = this.configProtoBytes;
        Option<scala.collection.immutable.Map<String, String>> x$22 = this.signatures;
        boolean x$3 = false;
        boolean x$4 = this.tensorflowWrapper().getTFHubSession$default$3();
        Session session = this.tensorflowWrapper().getTFHubSession(x$1, x$3, x$4, x$22);
        Session.Runner runner = session.runner();
        Tensor tokenTensors = tensors.createIntBufferTensor(shape, tokenBuffers);
        Tensor maskTensors = tensors.createIntBufferTensor(shape, maskBuffers);
        Tensor segmentTensors = tensors.createIntBufferTensor(shape, segmentBuffers);
        runner.feed((String)this._tfBertSignatures().getOrElse((Object)ModelSignatureConstants$InputIds$.MODULE$.key(), (Function0 & Serializable & scala.Serializable)() -> "missing_input_id_key"), tokenTensors).feed((String)this._tfBertSignatures().getOrElse((Object)ModelSignatureConstants$AttentionMask$.MODULE$.key(), (Function0 & Serializable & scala.Serializable)() -> "missing_input_mask_key"), maskTensors).feed((String)this._tfBertSignatures().getOrElse((Object)ModelSignatureConstants$TokenTypeIds$.MODULE$.key(), (Function0 & Serializable & scala.Serializable)() -> "missing_segment_ids_key"), segmentTensors).fetch((String)this._tfBertSignatures().getOrElse((Object)ModelSignatureConstants$LogitsOutput$.MODULE$.key(), (Function0 & Serializable & scala.Serializable)() -> "missing_logits_key"));
        Buffer outs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(runner.run()).asScala();
        float[] rawScores = TensorResources$.MODULE$.extractFloats((Tensor)outs.head(), TensorResources$.MODULE$.extractFloats$default$2());
        outs.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        tensors.clearSession((Buffer<Tensor>)outs);
        tensors.clearTensors();
        int dim = rawScores.length / (batchLength * maxSentenceLength);
        float[][][] batchScores = (float[][][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(rawScores)).grouped(dim).map((Function1 & Serializable & scala.Serializable)scores -> this.calcluateSoftmax((float[])scores)).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))))).grouped(maxSentenceLength).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))));
        return Predef$.MODULE$.wrapRefArray((Object[])batchScores);
    }

    public Seq<Annotation> predict(Seq<WordpieceTokenizedSentence> sentences, Seq<TokenizedSentence> originalTokenSentences, int batchSize, int maxSentenceLength) {
        return ((IterableLike)sentences.zipWithIndex(Seq$.MODULE$.canBuildFrom())).grouped(batchSize).flatMap((Function1 & Serializable & scala.Serializable)batch -> {
            Seq<int[]> encoded = this.encode((Seq<Tuple2<WordpieceTokenizedSentence, Object>>)batch, maxSentenceLength);
            Seq<float[][]> logits = this.tag(encoded);
            return (Seq)((TraversableLike)batch.zip(logits, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2 sentence = (Tuple2)tuple2._1();
                float[][] tokenVectors = (float[][])tuple2._2();
                int tokenLength = ((WordpieceTokenizedSentence)sentence._1()).tokens().length;
                float[][] tokenLogits = (float[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokenVectors)).slice(1, tokenLength + 1);
                Annotation[] labelsWithScores = (Annotation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((WordpieceTokenizedSentence)sentence._1()).tokens())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tokenLogits), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    TokenPiece token2 = (TokenPiece)tuple2._1();
                    float[] scores = (float[])tuple2._2();
                    Iterable iterable = Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TokenizedSentence)originalTokenSentences.apply(sentence._2$mcI$sp())).indexedTokens())).find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TensorflowBertClassification.$anonfun$predict$4(token2, p))).map((Function1 & Serializable & scala.Serializable)token -> {
                        String label = (String)$this.tags.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TensorflowBertClassification.$anonfun$predict$6(scores, x$3))).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NA");
                        Tuple2[] meta = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scores)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.tags.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TensorflowBertClassification.$anonfun$predict$11(x, x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7._1()).toString()), (Object)x._1().toString())})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                        return new Annotation(AnnotatorType$.MODULE$.NAMED_ENTITY(), token.begin(), token.end(), label, (Map<String, String>)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sentence"), (Object)((Object)BoxesRunTime.boxToInteger((int)sentence._2$mcI$sp())).toString())}))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])meta))), Annotation$.MODULE$.apply$default$6());
                    }));
                    return iterable;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Annotation.class)));
                Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labelsWithScores)).toSeq();
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
        }).toSeq();
    }

    public static final /* synthetic */ int $anonfun$encode$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        WordpieceTokenizedSentence wpTokSentence = (WordpieceTokenizedSentence)tuple2._1();
        int n = wpTokSentence.tokens().length;
        return n;
    }

    public static final /* synthetic */ int $anonfun$tag$1(int[] encodedSentence) {
        return encodedSentence.length;
    }

    public static final /* synthetic */ boolean $anonfun$predict$4(TokenPiece token$1, IndexedToken p) {
        return p.begin() == token$1.begin();
    }

    public static final /* synthetic */ float $anonfun$predict$7(Tuple2 x$4) {
        return BoxesRunTime.unboxToFloat((Object)x$4._1());
    }

    public static final /* synthetic */ boolean $anonfun$predict$6(float[] scores$1, Tuple2 x$3) {
        return x$3._2$mcI$sp() == ((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(scores$1)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).maxBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToFloat((float)TensorflowBertClassification.$anonfun$predict$7(x$4)), (Ordering)Ordering.Float$.MODULE$))._2$mcI$sp();
    }

    public static final /* synthetic */ boolean $anonfun$predict$11(Tuple2 x$8, Tuple2 x$6) {
        return x$6._2$mcI$sp() == x$8._2$mcI$sp();
    }

    public TensorflowBertClassification(TensorflowWrapper tensorflowWrapper, int sentenceStartTokenId, int sentenceEndTokenId, Option<byte[]> configProtoBytes, scala.collection.immutable.Map<String, Object> tags, Option<scala.collection.immutable.Map<String, String>> signatures) {
        this.tensorflowWrapper = tensorflowWrapper;
        this.sentenceStartTokenId = sentenceStartTokenId;
        this.sentenceEndTokenId = sentenceEndTokenId;
        this.configProtoBytes = configProtoBytes;
        this.tags = tags;
        this.signatures = signatures;
        this._tfBertSignatures = (scala.collection.immutable.Map)signatures.getOrElse((Function0 & Serializable & scala.Serializable)() -> ModelSignatureManager$.MODULE$.apply(ModelSignatureManager$.MODULE$.apply$default$1(), ModelSignatureManager$.MODULE$.apply$default$2(), ModelSignatureManager$.MODULE$.apply$default$3(), ModelSignatureManager$.MODULE$.apply$default$4(), ModelSignatureManager$.MODULE$.apply$default$5(), ModelSignatureManager$.MODULE$.apply$default$6()));
    }
}

